# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-08T09:27:54+00:00

from __future__ import annotations

from typing import Annotated

from fastapi import APIRouter, Depends, HTTPException
from fastapi.security import HTTPAuthorizationCredentials, HTTPBearer

from ..dependencies import *
from ..handler_registry import HandlerRegistry

router = APIRouter(tags=['Onboarding'])
security = HTTPBearer(auto_error=False)
registry = HandlerRegistry()


@registry.register()
class OnboardingHandler:
    def __init__(self):
        pass

    def on_board(self, body: Onboard) -> None:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"on_board not implemented")

    def get_on_boarding_status(self, body: StatusRequest) -> StatusResponse:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"get_on_boarding_status not implemented"
        )


@router.post('/v1/operations/onboarding', response_model=None, tags=['Onboarding'])
def on_board(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    body: Onboard,
) -> None:
    """
    Endpoint to onboard connector
    """

    token = credentials.credentials if credentials else None
    return registry.call_handler(on_board.__name__, token, body)


@router.post(
    '/v1/operations/status', response_model=StatusResponse, tags=['Onboarding']
)
def get_on_boarding_status(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    body: StatusRequest,
) -> StatusResponse:
    """
    Endpoint to get onboarding status
    """

    token = credentials.credentials if credentials else None
    return registry.call_handler(get_on_boarding_status.__name__, token, body)
