# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CellularSimsArgs', 'CellularSims']

@pulumi.input_type
class CellularSimsArgs:
    def __init__(__self__, *,
                 serial: pulumi.Input[str],
                 sim_failover: Optional[pulumi.Input['CellularSimsSimFailoverArgs']] = None,
                 sims: Optional[pulumi.Input[Sequence[pulumi.Input['CellularSimsSimArgs']]]] = None):
        """
        The set of arguments for constructing a CellularSims resource.
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input['CellularSimsSimFailoverArgs'] sim_failover: SIM Failover settings.
        :param pulumi.Input[Sequence[pulumi.Input['CellularSimsSimArgs']]] sims: List of SIMs. If a SIM was previously configured and not specified in this request, it will remain unchanged.
        """
        pulumi.set(__self__, "serial", serial)
        if sim_failover is not None:
            pulumi.set(__self__, "sim_failover", sim_failover)
        if sims is not None:
            pulumi.set(__self__, "sims", sims)

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Input[str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: pulumi.Input[str]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter(name="simFailover")
    def sim_failover(self) -> Optional[pulumi.Input['CellularSimsSimFailoverArgs']]:
        """
        SIM Failover settings.
        """
        return pulumi.get(self, "sim_failover")

    @sim_failover.setter
    def sim_failover(self, value: Optional[pulumi.Input['CellularSimsSimFailoverArgs']]):
        pulumi.set(self, "sim_failover", value)

    @property
    @pulumi.getter
    def sims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CellularSimsSimArgs']]]]:
        """
        List of SIMs. If a SIM was previously configured and not specified in this request, it will remain unchanged.
        """
        return pulumi.get(self, "sims")

    @sims.setter
    def sims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CellularSimsSimArgs']]]]):
        pulumi.set(self, "sims", value)


@pulumi.input_type
class _CellularSimsState:
    def __init__(__self__, *,
                 serial: Optional[pulumi.Input[str]] = None,
                 sim_failover: Optional[pulumi.Input['CellularSimsSimFailoverArgs']] = None,
                 sims: Optional[pulumi.Input[Sequence[pulumi.Input['CellularSimsSimArgs']]]] = None):
        """
        Input properties used for looking up and filtering CellularSims resources.
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input['CellularSimsSimFailoverArgs'] sim_failover: SIM Failover settings.
        :param pulumi.Input[Sequence[pulumi.Input['CellularSimsSimArgs']]] sims: List of SIMs. If a SIM was previously configured and not specified in this request, it will remain unchanged.
        """
        if serial is not None:
            pulumi.set(__self__, "serial", serial)
        if sim_failover is not None:
            pulumi.set(__self__, "sim_failover", sim_failover)
        if sims is not None:
            pulumi.set(__self__, "sims", sims)

    @property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[str]]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter(name="simFailover")
    def sim_failover(self) -> Optional[pulumi.Input['CellularSimsSimFailoverArgs']]:
        """
        SIM Failover settings.
        """
        return pulumi.get(self, "sim_failover")

    @sim_failover.setter
    def sim_failover(self, value: Optional[pulumi.Input['CellularSimsSimFailoverArgs']]):
        pulumi.set(self, "sim_failover", value)

    @property
    @pulumi.getter
    def sims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CellularSimsSimArgs']]]]:
        """
        List of SIMs. If a SIM was previously configured and not specified in this request, it will remain unchanged.
        """
        return pulumi.get(self, "sims")

    @sims.setter
    def sims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CellularSimsSimArgs']]]]):
        pulumi.set(self, "sims", value)


class CellularSims(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 sim_failover: Optional[pulumi.Input[pulumi.InputType['CellularSimsSimFailoverArgs']]] = None,
                 sims: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CellularSimsSimArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.CellularSims("example", serial="string")
        pulumi.export("merakiDevicesCellularSimsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/cellularSims:CellularSims example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input[pulumi.InputType['CellularSimsSimFailoverArgs']] sim_failover: SIM Failover settings.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CellularSimsSimArgs']]]] sims: List of SIMs. If a SIM was previously configured and not specified in this request, it will remain unchanged.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CellularSimsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.CellularSims("example", serial="string")
        pulumi.export("merakiDevicesCellularSimsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/cellularSims:CellularSims example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param CellularSimsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CellularSimsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 sim_failover: Optional[pulumi.Input[pulumi.InputType['CellularSimsSimFailoverArgs']]] = None,
                 sims: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CellularSimsSimArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CellularSimsArgs.__new__(CellularSimsArgs)

            if serial is None and not opts.urn:
                raise TypeError("Missing required property 'serial'")
            __props__.__dict__["serial"] = serial
            __props__.__dict__["sim_failover"] = sim_failover
            __props__.__dict__["sims"] = sims
        super(CellularSims, __self__).__init__(
            'meraki:devices/cellularSims:CellularSims',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            serial: Optional[pulumi.Input[str]] = None,
            sim_failover: Optional[pulumi.Input[pulumi.InputType['CellularSimsSimFailoverArgs']]] = None,
            sims: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CellularSimsSimArgs']]]]] = None) -> 'CellularSims':
        """
        Get an existing CellularSims resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input[pulumi.InputType['CellularSimsSimFailoverArgs']] sim_failover: SIM Failover settings.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CellularSimsSimArgs']]]] sims: List of SIMs. If a SIM was previously configured and not specified in this request, it will remain unchanged.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CellularSimsState.__new__(_CellularSimsState)

        __props__.__dict__["serial"] = serial
        __props__.__dict__["sim_failover"] = sim_failover
        __props__.__dict__["sims"] = sims
        return CellularSims(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Output[str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter(name="simFailover")
    def sim_failover(self) -> pulumi.Output['outputs.CellularSimsSimFailover']:
        """
        SIM Failover settings.
        """
        return pulumi.get(self, "sim_failover")

    @property
    @pulumi.getter
    def sims(self) -> pulumi.Output[Sequence['outputs.CellularSimsSim']]:
        """
        List of SIMs. If a SIM was previously configured and not specified in this request, it will remain unchanged.
        """
        return pulumi.get(self, "sims")

