# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetWafRulesResult',
    'AwaitableGetWafRulesResult',
    'get_waf_rules',
    'get_waf_rules_output',
]

@pulumi.output_type
class GetWafRulesResult:
    """
    A collection of values returned by getWafRules.
    """
    def __init__(__self__, exclude_modsec_rule_ids=None, id=None, modsec_rule_ids=None, publishers=None, rules=None, tags=None):
        if exclude_modsec_rule_ids and not isinstance(exclude_modsec_rule_ids, list):
            raise TypeError("Expected argument 'exclude_modsec_rule_ids' to be a list")
        pulumi.set(__self__, "exclude_modsec_rule_ids", exclude_modsec_rule_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if modsec_rule_ids and not isinstance(modsec_rule_ids, list):
            raise TypeError("Expected argument 'modsec_rule_ids' to be a list")
        pulumi.set(__self__, "modsec_rule_ids", modsec_rule_ids)
        if publishers and not isinstance(publishers, list):
            raise TypeError("Expected argument 'publishers' to be a list")
        pulumi.set(__self__, "publishers", publishers)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="excludeModsecRuleIds")
    def exclude_modsec_rule_ids(self) -> Optional[Sequence[int]]:
        """
        A list of modsecurity rules IDs to be excluded from the data set.
        """
        return pulumi.get(self, "exclude_modsec_rule_ids")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modsecRuleIds")
    def modsec_rule_ids(self) -> Optional[Sequence[int]]:
        """
        A list of modsecurity rules IDs to be used as filters for the data set.
        """
        return pulumi.get(self, "modsec_rule_ids")

    @property
    @pulumi.getter
    def publishers(self) -> Optional[Sequence[str]]:
        """
        A list of publishers to be used as filters for the data set.
        """
        return pulumi.get(self, "publishers")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetWafRulesRuleResult']:
        """
        The list of rules that results from any given combination of filters.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        A list of tags to be used as filters for the data set.
        """
        return pulumi.get(self, "tags")


class AwaitableGetWafRulesResult(GetWafRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWafRulesResult(
            exclude_modsec_rule_ids=self.exclude_modsec_rule_ids,
            id=self.id,
            modsec_rule_ids=self.modsec_rule_ids,
            publishers=self.publishers,
            rules=self.rules,
            tags=self.tags)


def get_waf_rules(exclude_modsec_rule_ids: Optional[Sequence[int]] = None,
                  modsec_rule_ids: Optional[Sequence[int]] = None,
                  publishers: Optional[Sequence[str]] = None,
                  tags: Optional[Sequence[str]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWafRulesResult:
    """
    Use this data source to access information about an existing resource.

    :param Sequence[int] exclude_modsec_rule_ids: Exclusion filter by WAF rule's ModSecurity ID.
    :param Sequence[int] modsec_rule_ids: A list of modsecurity rules IDs to be used as filters for the data set.
    :param Sequence[str] publishers: Inclusion filter by WAF rule's publishers.
    :param Sequence[str] tags: Inclusion filter by WAF rule's tags.
    """
    __args__ = dict()
    __args__['excludeModsecRuleIds'] = exclude_modsec_rule_ids
    __args__['modsecRuleIds'] = modsec_rule_ids
    __args__['publishers'] = publishers
    __args__['tags'] = tags
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('fastly:index/getWafRules:getWafRules', __args__, opts=opts, typ=GetWafRulesResult).value

    return AwaitableGetWafRulesResult(
        exclude_modsec_rule_ids=__ret__.exclude_modsec_rule_ids,
        id=__ret__.id,
        modsec_rule_ids=__ret__.modsec_rule_ids,
        publishers=__ret__.publishers,
        rules=__ret__.rules,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_waf_rules)
def get_waf_rules_output(exclude_modsec_rule_ids: Optional[pulumi.Input[Optional[Sequence[int]]]] = None,
                         modsec_rule_ids: Optional[pulumi.Input[Optional[Sequence[int]]]] = None,
                         publishers: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                         tags: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetWafRulesResult]:
    """
    Use this data source to access information about an existing resource.

    :param Sequence[int] exclude_modsec_rule_ids: Exclusion filter by WAF rule's ModSecurity ID.
    :param Sequence[int] modsec_rule_ids: A list of modsecurity rules IDs to be used as filters for the data set.
    :param Sequence[str] publishers: Inclusion filter by WAF rule's publishers.
    :param Sequence[str] tags: Inclusion filter by WAF rule's tags.
    """
    ...
