"""
Binance Derivatives Trading USDS Futures REST API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import Optional
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.errors import RequiredError
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import ClassicPortfolioMarginAccountInformationResponse


class PortfolioMarginEndpointsApi:
    """API Client for PortfolioMarginEndpointsApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def classic_portfolio_margin_account_information(
        self,
        asset: str = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ClassicPortfolioMarginAccountInformationResponse]:
        """
                Classic Portfolio Margin Account Information (USER_DATA)
                GET /fapi/v1/pmAccountInfo
                https://developers.binance.com/docs/derivatives/usds-margined-futures/portfolio-margin-endpoints/Classic-Portfolio-Margin-Account-Information

                Get Classic Portfolio Margin current account information.


        * maxWithdrawAmount is for asset transfer out to the spot wallet.

        Weight: 5

                Args:
                    asset (str):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[ClassicPortfolioMarginAccountInformationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if asset is None:
            raise RequiredError(
                field="asset", error_message="Missing required parameter 'asset'"
            )

        payload = {"asset": asset, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/pmAccountInfo",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=ClassicPortfolioMarginAccountInformationResponse,
            is_signed=True,
            signer=self._signer,
        )
