"""
Binance Derivatives Trading USDS Futures REST API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import List, Optional
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.errors import RequiredError
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import AccountTradeListResponse
from ..models import AllOrdersResponse
from ..models import AutoCancelAllOpenOrdersResponse
from ..models import CancelAllOpenOrdersResponse
from ..models import CancelMultipleOrdersResponse
from ..models import CancelOrderResponse
from ..models import ChangeInitialLeverageResponse
from ..models import ChangeMarginTypeResponse
from ..models import ChangeMultiAssetsModeResponse
from ..models import ChangePositionModeResponse
from ..models import CurrentAllOpenOrdersResponse
from ..models import GetOrderModifyHistoryResponse
from ..models import GetPositionMarginChangeHistoryResponse
from ..models import ModifyIsolatedPositionMarginResponse
from ..models import ModifyMultipleOrdersResponse
from ..models import ModifyOrderResponse
from ..models import NewOrderResponse
from ..models import PlaceMultipleOrdersResponse
from ..models import PositionAdlQuantileEstimationResponse
from ..models import PositionInformationV2Response
from ..models import PositionInformationV3Response
from ..models import QueryCurrentOpenOrderResponse
from ..models import QueryOrderResponse
from ..models import TestOrderResponse
from ..models import UsersForceOrdersResponse


from ..models import ChangeMarginTypeMarginTypeEnum
from ..models import ModifyIsolatedPositionMarginPositionSideEnum
from ..models import ModifyOrderSideEnum
from ..models import ModifyOrderPriceMatchEnum
from ..models import NewOrderSideEnum
from ..models import NewOrderPositionSideEnum
from ..models import NewOrderTimeInForceEnum
from ..models import NewOrderWorkingTypeEnum
from ..models import NewOrderNewOrderRespTypeEnum
from ..models import NewOrderPriceMatchEnum
from ..models import NewOrderSelfTradePreventionModeEnum
from ..models import TestOrderSideEnum
from ..models import TestOrderPositionSideEnum
from ..models import TestOrderTimeInForceEnum
from ..models import TestOrderWorkingTypeEnum
from ..models import TestOrderNewOrderRespTypeEnum
from ..models import TestOrderPriceMatchEnum
from ..models import TestOrderSelfTradePreventionModeEnum
from ..models import UsersForceOrdersAutoCloseTypeEnum


from ..models import ModifyMultipleOrdersBatchOrdersParameterInner
from ..models import PlaceMultipleOrdersBatchOrdersParameterInner


class TradeApi:
    """API Client for TradeApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def account_trade_list(
        self,
        symbol: str = None,
        order_id: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        from_id: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AccountTradeListResponse]:
        """
                Account Trade List (USER_DATA)
                GET /fapi/v1/userTrades
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Account-Trade-List

                Get trades for a specific account and symbol.

        * If `startTime` and `endTime` are both not sent, then the last 7 days' data will be returned.
        * The time between `startTime` and `endTime` cannot be longer than 7 days.
        * The parameter `fromId` cannot be sent with `startTime` or `endTime`.
        * Only support querying trade in the past 6 months

        Weight: 5

                Args:
                    symbol (str):
                    order_id (Optional[int]):
                    start_time (Optional[int]):
                    end_time (Optional[int]):
                    from_id (Optional[int]): ID to get aggregate trades from INCLUSIVE.
                    limit (Optional[int]): Default 100; max 1000
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[AccountTradeListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {
            "symbol": symbol,
            "order_id": order_id,
            "start_time": start_time,
            "end_time": end_time,
            "from_id": from_id,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/userTrades",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=AccountTradeListResponse,
            is_signed=True,
            signer=self._signer,
        )

    def all_orders(
        self,
        symbol: str = None,
        order_id: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AllOrdersResponse]:
        """
                All Orders (USER_DATA)
                GET /fapi/v1/allOrders
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/All-Orders

                Get all account orders; active, canceled, or filled.

        * These orders will not be found:
        * order status is `CANCELED` or `EXPIRED` **AND** order has NO filled trade **AND** created time + 3 days < current time
        * order create time + 90 days < current time

        * If `orderId` is set, it will get orders >= that `orderId`. Otherwise most recent orders are returned.
        * The query time period must be less then 7 days( default as the recent 7 days).

        Weight: 5

                Args:
                    symbol (str):
                    order_id (Optional[int]):
                    start_time (Optional[int]):
                    end_time (Optional[int]):
                    limit (Optional[int]): Default 100; max 1000
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[AllOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {
            "symbol": symbol,
            "order_id": order_id,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/allOrders",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=AllOrdersResponse,
            is_signed=True,
            signer=self._signer,
        )

    def auto_cancel_all_open_orders(
        self,
        symbol: str = None,
        countdown_time: int = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AutoCancelAllOpenOrdersResponse]:
        """
                Auto-Cancel All Open Orders (TRADE)
                POST /fapi/v1/countdownCancelAll
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Auto-Cancel-All-Open-Orders

                Cancel all open orders of the specified symbol at the end of the specified countdown.
        The endpoint should be called repeatedly as heartbeats so that the existing countdown time can be canceled and replaced by a new one.

        * Example usage:
        Call this endpoint at 30s intervals with an countdownTime of 120000 (120s).
        If this endpoint is not called within 120 seconds, all your orders of the specified symbol will be automatically canceled.
        If this endpoint is called with an countdownTime of 0, the countdown timer will be stopped.

        The system will check all countdowns **approximately every 10 milliseconds**, so please note that sufficient redundancy should be considered when using this function. We do not recommend setting the countdown time to be too precise or too small.

        Weight: 10

                Args:
                    symbol (str):
                    countdown_time (int): countdown time, 1000 for 1 second. 0 to cancel the timer
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[AutoCancelAllOpenOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if countdown_time is None:
            raise RequiredError(
                field="countdown_time",
                error_message="Missing required parameter 'countdown_time'",
            )

        payload = {
            "symbol": symbol,
            "countdown_time": countdown_time,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/fapi/v1/countdownCancelAll",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=AutoCancelAllOpenOrdersResponse,
            is_signed=True,
            signer=self._signer,
        )

    def cancel_all_open_orders(
        self,
        symbol: str = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CancelAllOpenOrdersResponse]:
        """
                Cancel All Open Orders (TRADE)
                DELETE /fapi/v1/allOpenOrders
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Cancel-All-Open-Orders

                Cancel All Open Orders

        Weight: 1

                Args:
                    symbol (str):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[CancelAllOpenOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {"symbol": symbol, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="DELETE",
            path="/fapi/v1/allOpenOrders",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=CancelAllOpenOrdersResponse,
            is_signed=True,
            signer=self._signer,
        )

    def cancel_multiple_orders(
        self,
        symbol: str = None,
        order_id_list: Optional[List[int]] = None,
        orig_client_order_id_list: Optional[List[str]] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CancelMultipleOrdersResponse]:
        """
                Cancel Multiple Orders (TRADE)
                DELETE /fapi/v1/batchOrders
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Cancel-Multiple-Orders

                Cancel Multiple Orders

        * Either `orderIdList` or `origClientOrderIdList ` must be sent.

        Weight: 1

                Args:
                    symbol (str):
                    order_id_list (Optional[List[int]]): max length 10 <br /> e.g. [1234567,2345678]
                    orig_client_order_id_list (Optional[List[str]]): max length 10<br /> e.g. ["my_id_1","my_id_2"], encode the double quotes. No space after comma.
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[CancelMultipleOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {
            "symbol": symbol,
            "order_id_list": order_id_list,
            "orig_client_order_id_list": orig_client_order_id_list,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="DELETE",
            path="/fapi/v1/batchOrders",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=CancelMultipleOrdersResponse,
            is_signed=True,
            signer=self._signer,
        )

    def cancel_order(
        self,
        symbol: str = None,
        order_id: Optional[int] = None,
        orig_client_order_id: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CancelOrderResponse]:
        """
                Cancel Order (TRADE)
                DELETE /fapi/v1/order
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Cancel-Order

                Cancel an active order.

        * Either `orderId` or `origClientOrderId` must be sent.

        Weight: 1

                Args:
                    symbol (str):
                    order_id (Optional[int]):
                    orig_client_order_id (Optional[str]):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[CancelOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {
            "symbol": symbol,
            "order_id": order_id,
            "orig_client_order_id": orig_client_order_id,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="DELETE",
            path="/fapi/v1/order",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=CancelOrderResponse,
            is_signed=True,
            signer=self._signer,
        )

    def change_initial_leverage(
        self,
        symbol: str = None,
        leverage: int = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ChangeInitialLeverageResponse]:
        """
                Change Initial Leverage(TRADE)
                POST /fapi/v1/leverage
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Change-Initial-Leverage

                Change user's initial leverage of specific symbol market.

        Weight: 1

                Args:
                    symbol (str):
                    leverage (int): target initial leverage: int from 1 to 125
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[ChangeInitialLeverageResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if leverage is None:
            raise RequiredError(
                field="leverage", error_message="Missing required parameter 'leverage'"
            )

        payload = {"symbol": symbol, "leverage": leverage, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/fapi/v1/leverage",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=ChangeInitialLeverageResponse,
            is_signed=True,
            signer=self._signer,
        )

    def change_margin_type(
        self,
        symbol: str = None,
        margin_type: ChangeMarginTypeMarginTypeEnum = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ChangeMarginTypeResponse]:
        """
                Change Margin Type(TRADE)
                POST /fapi/v1/marginType
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Change-Margin-Type

                Change symbol level margin type

        Weight: 1

                Args:
                    symbol (str):
                    margin_type (ChangeMarginTypeMarginTypeEnum): ISOLATED, CROSSED
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[ChangeMarginTypeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if margin_type is None:
            raise RequiredError(
                field="margin_type",
                error_message="Missing required parameter 'margin_type'",
            )

        payload = {
            "symbol": symbol,
            "margin_type": margin_type,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/fapi/v1/marginType",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=ChangeMarginTypeResponse,
            is_signed=True,
            signer=self._signer,
        )

    def change_multi_assets_mode(
        self,
        multi_assets_margin: str = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ChangeMultiAssetsModeResponse]:
        """
                Change Multi-Assets Mode (TRADE)
                POST /fapi/v1/multiAssetsMargin
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Change-Multi-Assets-Mode

                Change user's Multi-Assets mode (Multi-Assets Mode or Single-Asset Mode) on ***Every symbol***

        Weight: 1

                Args:
                    multi_assets_margin (str): "true": Multi-Assets Mode; "false": Single-Asset Mode
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[ChangeMultiAssetsModeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if multi_assets_margin is None:
            raise RequiredError(
                field="multi_assets_margin",
                error_message="Missing required parameter 'multi_assets_margin'",
            )

        payload = {
            "multi_assets_margin": multi_assets_margin,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/fapi/v1/multiAssetsMargin",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=ChangeMultiAssetsModeResponse,
            is_signed=True,
            signer=self._signer,
        )

    def change_position_mode(
        self,
        dual_side_position: str = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ChangePositionModeResponse]:
        """
                Change Position Mode(TRADE)
                POST /fapi/v1/positionSide/dual
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Change-Position-Mode

                Change user's position mode (Hedge Mode or One-way Mode ) on ***EVERY symbol***

        Weight: 1

                Args:
                    dual_side_position (str): "true": Hedge Mode; "false": One-way Mode
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[ChangePositionModeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if dual_side_position is None:
            raise RequiredError(
                field="dual_side_position",
                error_message="Missing required parameter 'dual_side_position'",
            )

        payload = {"dual_side_position": dual_side_position, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/fapi/v1/positionSide/dual",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=ChangePositionModeResponse,
            is_signed=True,
            signer=self._signer,
        )

    def current_all_open_orders(
        self,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CurrentAllOpenOrdersResponse]:
        """
                Current All Open Orders (USER_DATA)
                GET /fapi/v1/openOrders
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Current-All-Open-Orders

                Get all open orders on a symbol.

        * If the symbol is not sent, orders for all symbols will be returned in an array.

        Weight: 1 for a single symbol; 40 when the symbol parameter is omitted
        Careful when accessing this with no symbol.

                Args:
                    symbol (Optional[str]):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[CurrentAllOpenOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/openOrders",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=CurrentAllOpenOrdersResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_order_modify_history(
        self,
        symbol: str = None,
        order_id: Optional[int] = None,
        orig_client_order_id: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetOrderModifyHistoryResponse]:
        """
                Get Order Modify History (USER_DATA)
                GET /fapi/v1/orderAmendment
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Get-Order-Modify-History

                Get order modification history

        * Either `orderId` or `origClientOrderId` must be sent, and the `orderId` will prevail if both are sent.
        * Order modify history longer than 3 month is not avaliable

        Weight: 1

                Args:
                    symbol (str):
                    order_id (Optional[int]):
                    orig_client_order_id (Optional[str]):
                    start_time (Optional[int]):
                    end_time (Optional[int]):
                    limit (Optional[int]): Default 100; max 1000
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[GetOrderModifyHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {
            "symbol": symbol,
            "order_id": order_id,
            "orig_client_order_id": orig_client_order_id,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/orderAmendment",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetOrderModifyHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_position_margin_change_history(
        self,
        symbol: str = None,
        type: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetPositionMarginChangeHistoryResponse]:
        """
                Get Position Margin Change History (TRADE)
                GET /fapi/v1/positionMargin/history
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Get-Position-Margin-Change-History

                Get Position Margin Change History

        * Support querying future histories that are not older than 30 days
        * The time between `startTime` and `endTime`can't be more than 30 days

        Weight: 1

                Args:
                    symbol (str):
                    type (Optional[int]): 1: Add position margin，2: Reduce position margin
                    start_time (Optional[int]):
                    end_time (Optional[int]):
                    limit (Optional[int]): Default 100; max 1000
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[GetPositionMarginChangeHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {
            "symbol": symbol,
            "type": type,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/positionMargin/history",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetPositionMarginChangeHistoryResponse,
            is_signed=True,
            signer=self._signer,
        )

    def modify_isolated_position_margin(
        self,
        symbol: str = None,
        amount: float = None,
        type: str = None,
        position_side: Optional[ModifyIsolatedPositionMarginPositionSideEnum] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ModifyIsolatedPositionMarginResponse]:
        """
                Modify Isolated Position Margin(TRADE)
                POST /fapi/v1/positionMargin
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Modify-Isolated-Position-Margin

                Modify Isolated Position Margin


        * Only for isolated symbol

        Weight: 1

                Args:
                    symbol (str):
                    amount (float):
                    type (str):
                    position_side (Optional[ModifyIsolatedPositionMarginPositionSideEnum]): Default `BOTH` for One-way Mode ; `LONG` or `SHORT` for Hedge Mode. It must be sent with Hedge Mode.
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[ModifyIsolatedPositionMarginResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if amount is None:
            raise RequiredError(
                field="amount", error_message="Missing required parameter 'amount'"
            )
        if type is None:
            raise RequiredError(
                field="type", error_message="Missing required parameter 'type'"
            )

        payload = {
            "symbol": symbol,
            "amount": amount,
            "type": type,
            "position_side": position_side,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/fapi/v1/positionMargin",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=ModifyIsolatedPositionMarginResponse,
            is_signed=True,
            signer=self._signer,
        )

    def modify_multiple_orders(
        self,
        batch_orders: List[ModifyMultipleOrdersBatchOrdersParameterInner] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ModifyMultipleOrdersResponse]:
        """
                Modify Multiple Orders(TRADE)
                PUT /fapi/v1/batchOrders
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Modify-Multiple-Orders

                Modify Multiple Orders (TRADE)

        * Parameter rules are same with `Modify Order`
        * Batch modify orders are processed concurrently, and the order of matching is not guaranteed.
        * The order of returned contents for batch modify orders is the same as the order of the order list.
        * One order can only be modfied for less than 10000 times

        Weight: 5 on 10s order rate limit(X-MBX-ORDER-COUNT-10S);
        1 on 1min order rate limit(X-MBX-ORDER-COUNT-1M);
        5 on IP rate limit(x-mbx-used-weight-1m);

                Args:
                    batch_orders (List[ModifyMultipleOrdersBatchOrdersParameterInner]): order list. Max 5 orders
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[ModifyMultipleOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if batch_orders is None:
            raise RequiredError(
                field="batch_orders",
                error_message="Missing required parameter 'batch_orders'",
            )

        payload = {"batch_orders": batch_orders, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="PUT",
            path="/fapi/v1/batchOrders",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=ModifyMultipleOrdersResponse,
            is_signed=True,
            signer=self._signer,
        )

    def modify_order(
        self,
        symbol: str = None,
        side: ModifyOrderSideEnum = None,
        quantity: float = None,
        price: float = None,
        order_id: Optional[int] = None,
        orig_client_order_id: Optional[str] = None,
        price_match: Optional[ModifyOrderPriceMatchEnum] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ModifyOrderResponse]:
        """
                Modify Order (TRADE)
                PUT /fapi/v1/order
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Modify-Order

                Order modify function, currently only LIMIT order modification is supported, modified orders will be reordered in the match queue


        * Either `orderId` or `origClientOrderId` must be sent, and the `orderId` will prevail if both are sent.
        * Both `quantity` and `price` must be sent, which is different from dapi modify order endpoint.
        * When the new `quantity` or `price` doesn't satisfy PRICE_FILTER / PERCENT_FILTER / LOT_SIZE, amendment will be rejected and the order will stay as it is.
        * However the order will be cancelled by the amendment in the following situations:
        * when the order is in partially filled status and the new `quantity` <= `executedQty`
        * When the order is `GTX` and the new price will cause it to be executed immediately
        * One order can only be modfied for less than 10000 times

        Weight: 1 on 10s order rate limit(X-MBX-ORDER-COUNT-10S);
        1 on 1min order rate limit(X-MBX-ORDER-COUNT-1M);
        1 on IP rate limit(x-mbx-used-weight-1m)

                Args:
                    symbol (str):
                    side (ModifyOrderSideEnum): `SELL`, `BUY`
                    quantity (float): Order quantity, cannot be sent with `closePosition=true`
                    price (float):
                    order_id (Optional[int]):
                    orig_client_order_id (Optional[str]):
                    price_match (Optional[ModifyOrderPriceMatchEnum]): only avaliable for `LIMIT`/`STOP`/`TAKE_PROFIT` order; can be set to `OPPONENT`/ `OPPONENT_5`/ `OPPONENT_10`/ `OPPONENT_20`: /`QUEUE`/ `QUEUE_5`/ `QUEUE_10`/ `QUEUE_20`; Can't be passed together with `price`
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[ModifyOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if side is None:
            raise RequiredError(
                field="side", error_message="Missing required parameter 'side'"
            )
        if quantity is None:
            raise RequiredError(
                field="quantity", error_message="Missing required parameter 'quantity'"
            )
        if price is None:
            raise RequiredError(
                field="price", error_message="Missing required parameter 'price'"
            )

        payload = {
            "symbol": symbol,
            "side": side,
            "quantity": quantity,
            "price": price,
            "order_id": order_id,
            "orig_client_order_id": orig_client_order_id,
            "price_match": price_match,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="PUT",
            path="/fapi/v1/order",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=ModifyOrderResponse,
            is_signed=True,
            signer=self._signer,
        )

    def new_order(
        self,
        symbol: str = None,
        side: NewOrderSideEnum = None,
        type: str = None,
        position_side: Optional[NewOrderPositionSideEnum] = None,
        time_in_force: Optional[NewOrderTimeInForceEnum] = None,
        quantity: Optional[float] = None,
        reduce_only: Optional[str] = None,
        price: Optional[float] = None,
        new_client_order_id: Optional[str] = None,
        stop_price: Optional[float] = None,
        close_position: Optional[str] = None,
        activation_price: Optional[float] = None,
        callback_rate: Optional[float] = None,
        working_type: Optional[NewOrderWorkingTypeEnum] = None,
        price_protect: Optional[str] = None,
        new_order_resp_type: Optional[NewOrderNewOrderRespTypeEnum] = None,
        price_match: Optional[NewOrderPriceMatchEnum] = None,
        self_trade_prevention_mode: Optional[
            NewOrderSelfTradePreventionModeEnum
        ] = None,
        good_till_date: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[NewOrderResponse]:
        """
                New Order(TRADE)
                POST /fapi/v1/order
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/New-Order

                Send in a new order.

        * Order with type `STOP`,  parameter `timeInForce` can be sent ( default `GTC`).
        * Order with type `TAKE_PROFIT`,  parameter `timeInForce` can be sent ( default `GTC`).
        * Condition orders will be triggered when:

        * If parameter`priceProtect`is sent as true:
        * when price reaches the `stopPrice` ，the difference rate between "MARK_PRICE" and "CONTRACT_PRICE" cannot be larger than the "triggerProtect" of the symbol
        * "triggerProtect" of a symbol can be got from `GET /fapi/v1/exchangeInfo`

        * `STOP`, `STOP_MARKET`:
        * BUY: latest price ("MARK_PRICE" or "CONTRACT_PRICE") >= `stopPrice`
        * SELL: latest price ("MARK_PRICE" or "CONTRACT_PRICE") <= `stopPrice`
        * `TAKE_PROFIT`, `TAKE_PROFIT_MARKET`:
        * BUY: latest price ("MARK_PRICE" or "CONTRACT_PRICE") <= `stopPrice`
        * SELL: latest price ("MARK_PRICE" or "CONTRACT_PRICE") >= `stopPrice`
        * `TRAILING_STOP_MARKET`:
        * BUY: the lowest price after order placed `<= `activationPrice`, and the latest price >`= the lowest price * (1 + `callbackRate`)
        * SELL: the highest price after order placed >= `activationPrice`, and the latest price <= the highest price * (1 - `callbackRate`)

        * For `TRAILING_STOP_MARKET`, if you got such error code.
        ``{"code": -2021, "msg": "Order would immediately trigger."}``
        means that the parameters you send do not meet the following requirements:
        * BUY: `activationPrice` should be smaller than latest price.
        * SELL: `activationPrice` should be larger than latest price.

        * If `newOrderRespType ` is sent as `RESULT` :
        * `MARKET` order: the final FILLED result of the order will be return directly.
        * `LIMIT` order with special `timeInForce`: the final status result of the order(FILLED or EXPIRED) will be returned directly.

        * `STOP_MARKET`, `TAKE_PROFIT_MARKET` with `closePosition`=`true`:
        * Follow the same rules for condition orders.
        * If triggered，**close all** current long position( if `SELL`) or current short position( if `BUY`).
        * Cannot be used with `quantity` paremeter
        * Cannot be used with `reduceOnly` parameter
        * In Hedge Mode,cannot be used with `BUY` orders in `LONG` position side. and cannot be used with `SELL` orders in `SHORT` position side
        * `selfTradePreventionMode` is only effective when `timeInForce` set to `IOC` or `GTC` or `GTD`.
        * In extreme market conditions, timeInForce `GTD` order auto cancel time might be delayed comparing to `goodTillDate`

        Weight: 1 on 10s order rate limit(X-MBX-ORDER-COUNT-10S);
        1 on 1min order rate limit(X-MBX-ORDER-COUNT-1M);
        0 on IP rate limit(x-mbx-used-weight-1m)

                Args:
                    symbol (str):
                    side (NewOrderSideEnum): `SELL`, `BUY`
                    type (str):
                    position_side (Optional[NewOrderPositionSideEnum]): Default `BOTH` for One-way Mode ; `LONG` or `SHORT` for Hedge Mode. It must be sent with Hedge Mode.
                    time_in_force (Optional[NewOrderTimeInForceEnum]):
                    quantity (Optional[float]): Cannot be sent with `closePosition`=`true`(Close-All)
                    reduce_only (Optional[str]): "true" or "false". default "false". Cannot be sent in Hedge Mode; cannot be sent with `closePosition`=`true`
                    price (Optional[float]):
                    new_client_order_id (Optional[str]): A unique id among open orders. Automatically generated if not sent. Can only be string following the rule: `^[.A-Z:/a-z0-9_-]{1,36}$`
                    stop_price (Optional[float]): Used with `STOP/STOP_MARKET` or `TAKE_PROFIT/TAKE_PROFIT_MARKET` orders.
                    close_position (Optional[str]): `true`, `false`；Close-All，used with `STOP_MARKET` or `TAKE_PROFIT_MARKET`.
                    activation_price (Optional[float]): Used with `TRAILING_STOP_MARKET` orders, default as the latest price(supporting different `workingType`)
                    callback_rate (Optional[float]): Used with `TRAILING_STOP_MARKET` orders, min 0.1, max 10 where 1 for 1%
                    working_type (Optional[NewOrderWorkingTypeEnum]): stopPrice triggered by: "MARK_PRICE", "CONTRACT_PRICE". Default "CONTRACT_PRICE"
                    price_protect (Optional[str]): "TRUE" or "FALSE", default "FALSE". Used with `STOP/STOP_MARKET` or `TAKE_PROFIT/TAKE_PROFIT_MARKET` orders.
                    new_order_resp_type (Optional[NewOrderNewOrderRespTypeEnum]): "ACK", "RESULT", default "ACK"
                    price_match (Optional[NewOrderPriceMatchEnum]): only avaliable for `LIMIT`/`STOP`/`TAKE_PROFIT` order; can be set to `OPPONENT`/ `OPPONENT_5`/ `OPPONENT_10`/ `OPPONENT_20`: /`QUEUE`/ `QUEUE_5`/ `QUEUE_10`/ `QUEUE_20`; Can't be passed together with `price`
                    self_trade_prevention_mode (Optional[NewOrderSelfTradePreventionModeEnum]): `NONE`:No STP / `EXPIRE_TAKER`:expire taker order when STP triggers/ `EXPIRE_MAKER`:expire taker order when STP triggers/ `EXPIRE_BOTH`:expire both orders when STP triggers; default `NONE`
                    good_till_date (Optional[int]): order cancel time for timeInForce `GTD`, mandatory when `timeInforce` set to `GTD`; order the timestamp only retains second-level precision, ms part will be ignored; The goodTillDate timestamp must be greater than the current time plus 600 seconds and smaller than 253402300799000
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[NewOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if side is None:
            raise RequiredError(
                field="side", error_message="Missing required parameter 'side'"
            )
        if type is None:
            raise RequiredError(
                field="type", error_message="Missing required parameter 'type'"
            )

        payload = {
            "symbol": symbol,
            "side": side,
            "type": type,
            "position_side": position_side,
            "time_in_force": time_in_force,
            "quantity": quantity,
            "reduce_only": reduce_only,
            "price": price,
            "new_client_order_id": new_client_order_id,
            "stop_price": stop_price,
            "close_position": close_position,
            "activation_price": activation_price,
            "callback_rate": callback_rate,
            "working_type": working_type,
            "price_protect": price_protect,
            "new_order_resp_type": new_order_resp_type,
            "price_match": price_match,
            "self_trade_prevention_mode": self_trade_prevention_mode,
            "good_till_date": good_till_date,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/fapi/v1/order",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=NewOrderResponse,
            is_signed=True,
            signer=self._signer,
        )

    def place_multiple_orders(
        self,
        batch_orders: List[PlaceMultipleOrdersBatchOrdersParameterInner] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[PlaceMultipleOrdersResponse]:
        """
                Place Multiple Orders(TRADE)
                POST /fapi/v1/batchOrders
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Place-Multiple-Orders

                Place Multiple Orders

        * Paremeter rules are same with `New Order`
        * Batch orders are processed concurrently, and the order of matching is not guaranteed.
        * The order of returned contents for batch orders is the same as the order of the order list.

        Weight: 5 on 10s order rate limit(X-MBX-ORDER-COUNT-10S);
        1 on 1min order rate limit(X-MBX-ORDER-COUNT-1M);
        5 on IP rate limit(x-mbx-used-weight-1m);

                Args:
                    batch_orders (List[PlaceMultipleOrdersBatchOrdersParameterInner]): order list. Max 5 orders
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[PlaceMultipleOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if batch_orders is None:
            raise RequiredError(
                field="batch_orders",
                error_message="Missing required parameter 'batch_orders'",
            )

        payload = {"batch_orders": batch_orders, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/fapi/v1/batchOrders",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=PlaceMultipleOrdersResponse,
            is_signed=True,
            signer=self._signer,
        )

    def position_adl_quantile_estimation(
        self,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[PositionAdlQuantileEstimationResponse]:
        """
                Position ADL Quantile Estimation(USER_DATA)
                GET /fapi/v1/adlQuantile
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Position-ADL-Quantile-Estimation

                Position ADL Quantile Estimation

        * Values update every 30s.
        * Values 0, 1, 2, 3, 4 shows the queue position and possibility of ADL from low to high.
        * For positions of the symbol are in One-way Mode or isolated margined in Hedge Mode, "LONG", "SHORT", and "BOTH" will be returned to show the positions' adl quantiles of different position sides.
        * If the positions of the symbol are crossed margined in Hedge Mode:
        * "HEDGE" as a sign will be returned instead of "BOTH";
        * A same value caculated on unrealized pnls on long and short sides' positions will be shown for "LONG" and "SHORT" when there are positions in both of long and short sides.

        Weight: 5

                Args:
                    symbol (Optional[str]):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[PositionAdlQuantileEstimationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/adlQuantile",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=PositionAdlQuantileEstimationResponse,
            is_signed=True,
            signer=self._signer,
        )

    def position_information_v2(
        self,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[PositionInformationV2Response]:
        """
                Position Information V2 (USER_DATA)
                GET /fapi/v2/positionRisk
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Position-Information-V2

                Get current position information.

        Please use with user data stream `ACCOUNT_UPDATE` to meet your timeliness and accuracy needs.

        Weight: 5

                Args:
                    symbol (Optional[str]):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[PositionInformationV2Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v2/positionRisk",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=PositionInformationV2Response,
            is_signed=True,
            signer=self._signer,
        )

    def position_information_v3(
        self,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[PositionInformationV3Response]:
        """
                Position Information V3 (USER_DATA)
                GET /fapi/v3/positionRisk
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Position-Information-V3

                Get current position information(only symbol that has position or open orders will be returned).

        Please use with user data stream `ACCOUNT_UPDATE` to meet your timeliness and accuracy needs.

        Weight: 5

                Args:
                    symbol (Optional[str]):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[PositionInformationV3Response]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"symbol": symbol, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v3/positionRisk",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=PositionInformationV3Response,
            is_signed=True,
            signer=self._signer,
        )

    def query_current_open_order(
        self,
        symbol: str = None,
        order_id: Optional[int] = None,
        orig_client_order_id: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryCurrentOpenOrderResponse]:
        """
                Query Current Open Order (USER_DATA)
                GET /fapi/v1/openOrder
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Query-Current-Open-Order

                Query open order


        * Either`orderId` or `origClientOrderId` must be sent
        * If the queried order has been filled or cancelled, the error message "Order does not exist" will be returned.

        Weight: 1

                Args:
                    symbol (str):
                    order_id (Optional[int]):
                    orig_client_order_id (Optional[str]):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[QueryCurrentOpenOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {
            "symbol": symbol,
            "order_id": order_id,
            "orig_client_order_id": orig_client_order_id,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/openOrder",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QueryCurrentOpenOrderResponse,
            is_signed=True,
            signer=self._signer,
        )

    def query_order(
        self,
        symbol: str = None,
        order_id: Optional[int] = None,
        orig_client_order_id: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryOrderResponse]:
        """
                Query Order (USER_DATA)
                GET /fapi/v1/order
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Query-Order

                Check an order's status.

        * These orders will not be found:
        * order status is `CANCELED` or `EXPIRED` **AND** order has NO filled trade **AND** created time + 3 days < current time
        * order create time + 90 days < current time

        * Either `orderId` or `origClientOrderId` must be sent.
        * `orderId` is self-increment for each specific `symbol`

        Weight: 1

                Args:
                    symbol (str):
                    order_id (Optional[int]):
                    orig_client_order_id (Optional[str]):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[QueryOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        payload = {
            "symbol": symbol,
            "order_id": order_id,
            "orig_client_order_id": orig_client_order_id,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/order",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=QueryOrderResponse,
            is_signed=True,
            signer=self._signer,
        )

    def test_order(
        self,
        symbol: str = None,
        side: TestOrderSideEnum = None,
        type: str = None,
        position_side: Optional[TestOrderPositionSideEnum] = None,
        time_in_force: Optional[TestOrderTimeInForceEnum] = None,
        quantity: Optional[float] = None,
        reduce_only: Optional[str] = None,
        price: Optional[float] = None,
        new_client_order_id: Optional[str] = None,
        stop_price: Optional[float] = None,
        close_position: Optional[str] = None,
        activation_price: Optional[float] = None,
        callback_rate: Optional[float] = None,
        working_type: Optional[TestOrderWorkingTypeEnum] = None,
        price_protect: Optional[str] = None,
        new_order_resp_type: Optional[TestOrderNewOrderRespTypeEnum] = None,
        price_match: Optional[TestOrderPriceMatchEnum] = None,
        self_trade_prevention_mode: Optional[
            TestOrderSelfTradePreventionModeEnum
        ] = None,
        good_till_date: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[TestOrderResponse]:
        """
                Test Order(TRADE)
                POST /fapi/v1/order/test
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/New-Order-Test

                Testing order request, this order will not be submitted to matching engine

        * Order with type `STOP`,  parameter `timeInForce` can be sent ( default `GTC`).
        * Order with type `TAKE_PROFIT`,  parameter `timeInForce` can be sent ( default `GTC`).
        * Condition orders will be triggered when:

        * If parameter`priceProtect`is sent as true:
        * when price reaches the `stopPrice` ，the difference rate between "MARK_PRICE" and "CONTRACT_PRICE" cannot be larger than the "triggerProtect" of the symbol
        * "triggerProtect" of a symbol can be got from `GET /fapi/v1/exchangeInfo`

        * `STOP`, `STOP_MARKET`:
        * BUY: latest price ("MARK_PRICE" or "CONTRACT_PRICE") >= `stopPrice`
        * SELL: latest price ("MARK_PRICE" or "CONTRACT_PRICE") <= `stopPrice`
        * `TAKE_PROFIT`, `TAKE_PROFIT_MARKET`:
        * BUY: latest price ("MARK_PRICE" or "CONTRACT_PRICE") <= `stopPrice`
        * SELL: latest price ("MARK_PRICE" or "CONTRACT_PRICE") >= `stopPrice`
        * `TRAILING_STOP_MARKET`:
        * BUY: the lowest price after order placed `<= `activationPrice`, and the latest price >`= the lowest price * (1 + `callbackRate`)
        * SELL: the highest price after order placed >= `activationPrice`, and the latest price <= the highest price * (1 - `callbackRate`)

        * For `TRAILING_STOP_MARKET`, if you got such error code.
        ``{"code": -2021, "msg": "Order would immediately trigger."}``
        means that the parameters you send do not meet the following requirements:
        * BUY: `activationPrice` should be smaller than latest price.
        * SELL: `activationPrice` should be larger than latest price.

        * If `newOrderRespType ` is sent as `RESULT` :
        * `MARKET` order: the final FILLED result of the order will be return directly.
        * `LIMIT` order with special `timeInForce`: the final status result of the order(FILLED or EXPIRED) will be returned directly.

        * `STOP_MARKET`, `TAKE_PROFIT_MARKET` with `closePosition`=`true`:
        * Follow the same rules for condition orders.
        * If triggered，**close all** current long position( if `SELL`) or current short position( if `BUY`).
        * Cannot be used with `quantity` paremeter
        * Cannot be used with `reduceOnly` parameter
        * In Hedge Mode,cannot be used with `BUY` orders in `LONG` position side. and cannot be used with `SELL` orders in `SHORT` position side
        * `selfTradePreventionMode` is only effective when `timeInForce` set to `IOC` or `GTC` or `GTD`.
        * In extreme market conditions, timeInForce `GTD` order auto cancel time might be delayed comparing to `goodTillDate`

        Weight: 0

                Args:
                    symbol (str):
                    side (TestOrderSideEnum): `SELL`, `BUY`
                    type (str):
                    position_side (Optional[TestOrderPositionSideEnum]): Default `BOTH` for One-way Mode ; `LONG` or `SHORT` for Hedge Mode. It must be sent with Hedge Mode.
                    time_in_force (Optional[TestOrderTimeInForceEnum]):
                    quantity (Optional[float]): Cannot be sent with `closePosition`=`true`(Close-All)
                    reduce_only (Optional[str]): "true" or "false". default "false". Cannot be sent in Hedge Mode; cannot be sent with `closePosition`=`true`
                    price (Optional[float]):
                    new_client_order_id (Optional[str]): A unique id among open orders. Automatically generated if not sent. Can only be string following the rule: `^[.A-Z:/a-z0-9_-]{1,36}$`
                    stop_price (Optional[float]): Used with `STOP/STOP_MARKET` or `TAKE_PROFIT/TAKE_PROFIT_MARKET` orders.
                    close_position (Optional[str]): `true`, `false`；Close-All，used with `STOP_MARKET` or `TAKE_PROFIT_MARKET`.
                    activation_price (Optional[float]): Used with `TRAILING_STOP_MARKET` orders, default as the latest price(supporting different `workingType`)
                    callback_rate (Optional[float]): Used with `TRAILING_STOP_MARKET` orders, min 0.1, max 10 where 1 for 1%
                    working_type (Optional[TestOrderWorkingTypeEnum]): stopPrice triggered by: "MARK_PRICE", "CONTRACT_PRICE". Default "CONTRACT_PRICE"
                    price_protect (Optional[str]): "TRUE" or "FALSE", default "FALSE". Used with `STOP/STOP_MARKET` or `TAKE_PROFIT/TAKE_PROFIT_MARKET` orders.
                    new_order_resp_type (Optional[TestOrderNewOrderRespTypeEnum]): "ACK", "RESULT", default "ACK"
                    price_match (Optional[TestOrderPriceMatchEnum]): only avaliable for `LIMIT`/`STOP`/`TAKE_PROFIT` order; can be set to `OPPONENT`/ `OPPONENT_5`/ `OPPONENT_10`/ `OPPONENT_20`: /`QUEUE`/ `QUEUE_5`/ `QUEUE_10`/ `QUEUE_20`; Can't be passed together with `price`
                    self_trade_prevention_mode (Optional[TestOrderSelfTradePreventionModeEnum]): `NONE`:No STP / `EXPIRE_TAKER`:expire taker order when STP triggers/ `EXPIRE_MAKER`:expire taker order when STP triggers/ `EXPIRE_BOTH`:expire both orders when STP triggers; default `NONE`
                    good_till_date (Optional[int]): order cancel time for timeInForce `GTD`, mandatory when `timeInforce` set to `GTD`; order the timestamp only retains second-level precision, ms part will be ignored; The goodTillDate timestamp must be greater than the current time plus 600 seconds and smaller than 253402300799000
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[TestOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if side is None:
            raise RequiredError(
                field="side", error_message="Missing required parameter 'side'"
            )
        if type is None:
            raise RequiredError(
                field="type", error_message="Missing required parameter 'type'"
            )

        payload = {
            "symbol": symbol,
            "side": side,
            "type": type,
            "position_side": position_side,
            "time_in_force": time_in_force,
            "quantity": quantity,
            "reduce_only": reduce_only,
            "price": price,
            "new_client_order_id": new_client_order_id,
            "stop_price": stop_price,
            "close_position": close_position,
            "activation_price": activation_price,
            "callback_rate": callback_rate,
            "working_type": working_type,
            "price_protect": price_protect,
            "new_order_resp_type": new_order_resp_type,
            "price_match": price_match,
            "self_trade_prevention_mode": self_trade_prevention_mode,
            "good_till_date": good_till_date,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/fapi/v1/order/test",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=TestOrderResponse,
            is_signed=True,
            signer=self._signer,
        )

    def users_force_orders(
        self,
        symbol: Optional[str] = None,
        auto_close_type: Optional[UsersForceOrdersAutoCloseTypeEnum] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[UsersForceOrdersResponse]:
        """
                User's Force Orders (USER_DATA)
                GET /fapi/v1/forceOrders
                https://developers.binance.com/docs/derivatives/usds-margined-futures/trade/rest-api/Users-Force-Orders

                Query user's Force Orders

        * If "autoCloseType" is not sent, orders with both of the types will be returned
        * If "startTime" is not sent, data within 7 days before "endTime" can be queried

        Weight: 20 with symbol, 50 without symbol

                Args:
                    symbol (Optional[str]):
                    auto_close_type (Optional[UsersForceOrdersAutoCloseTypeEnum]): "LIQUIDATION" for liquidation orders, "ADL" for ADL orders.
                    start_time (Optional[int]):
                    end_time (Optional[int]):
                    limit (Optional[int]): Default 100; max 1000
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[UsersForceOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "symbol": symbol,
            "auto_close_type": auto_close_type,
            "start_time": start_time,
            "end_time": end_time,
            "limit": limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/fapi/v1/forceOrders",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=UsersForceOrdersResponse,
            is_signed=True,
            signer=self._signer,
        )
