# coding: utf-8

"""
Binance Derivatives Trading USDS Futures REST API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import json
import pprint
from pydantic import (
    BaseModel,
    ConfigDict,
    ValidationError,
)
from typing import Any, Optional
from binance_sdk_derivatives_trading_usds_futures.rest_api.models.mark_price_response1 import (
    MarkPriceResponse1,
)
from binance_sdk_derivatives_trading_usds_futures.rest_api.models.mark_price_response2 import (
    MarkPriceResponse2,
)
from typing import Union, Set, Dict
from typing_extensions import Self

MARKPRICERESPONSE_ONE_OF_SCHEMAS = ["MarkPriceResponse1", "MarkPriceResponse2"]


class MarkPriceResponse(BaseModel):
    """
    MarkPriceResponse
    """

    # data type: MarkPriceResponse1
    oneof_schema_1_validator: Optional[MarkPriceResponse1] = None
    # data type: MarkPriceResponse2
    oneof_schema_2_validator: Optional[MarkPriceResponse2] = None
    actual_instance: Optional[Union[MarkPriceResponse1, list[MarkPriceResponse2]]] = (
        None
    )
    one_of_schemas: Set[str] = {"MarkPriceResponse1", "MarkPriceResponse2"}

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError(
                    "If a position argument is used, only 1 is allowed to set `actual_instance`"
                )
            if kwargs:
                raise ValueError(
                    "If a position argument is used, keyword arguments cannot be used."
                )
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @classmethod
    def is_oneof_model(cls) -> bool:
        return True

    @classmethod
    def from_dict(cls, parsed) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        is_list = isinstance(parsed, list)

        # deserialize data into MarkPriceResponse1
        if is_list == MarkPriceResponse1.is_array():
            try:
                instance.actual_instance = MarkPriceResponse1.from_dict(parsed)
                match += 1
            except (ValidationError, ValueError) as e:
                error_messages.append(str(e))
        # deserialize data into MarkPriceResponse2
        if is_list == MarkPriceResponse2.is_array():
            try:
                instance.actual_instance = MarkPriceResponse2.from_dict(parsed)
                match += 1
            except (ValidationError, ValueError) as e:
                error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when deserializing the JSON string into MarkPriceResponse with oneOf schemas: MarkPriceResponse1, MarkPriceResponse2. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into MarkPriceResponse with oneOf schemas: MarkPriceResponse1, MarkPriceResponse2. Details: "
                + ", ".join(error_messages)
            )
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(
            self.actual_instance.to_json
        ):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(
        self,
    ) -> Optional[Union[Dict[str, Any], MarkPriceResponse1, MarkPriceResponse2]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(
            self.actual_instance.to_dict
        ):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())
