# coding: utf-8

"""
Binance Derivatives Trading USDS Futures REST API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Set
from typing_extensions import Self


class Ticker24hrPriceChangeStatisticsResponse2Inner(BaseModel):
    """
    Ticker24hrPriceChangeStatisticsResponse2Inner
    """  # noqa: E501

    symbol: Optional[StrictStr] = None
    price_change: Optional[StrictStr] = Field(default=None, alias="priceChange")
    price_change_percent: Optional[StrictStr] = Field(
        default=None, alias="priceChangePercent"
    )
    weighted_avg_price: Optional[StrictStr] = Field(
        default=None, alias="weightedAvgPrice"
    )
    last_price: Optional[StrictStr] = Field(default=None, alias="lastPrice")
    last_qty: Optional[StrictStr] = Field(default=None, alias="lastQty")
    open_price: Optional[StrictStr] = Field(default=None, alias="openPrice")
    high_price: Optional[StrictStr] = Field(default=None, alias="highPrice")
    low_price: Optional[StrictStr] = Field(default=None, alias="lowPrice")
    volume: Optional[StrictStr] = None
    quote_volume: Optional[StrictStr] = Field(default=None, alias="quoteVolume")
    open_time: Optional[StrictInt] = Field(default=None, alias="openTime")
    close_time: Optional[StrictInt] = Field(default=None, alias="closeTime")
    first_id: Optional[StrictInt] = Field(default=None, alias="firstId")
    last_id: Optional[StrictInt] = Field(default=None, alias="lastId")
    count: Optional[StrictInt] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "symbol",
        "priceChange",
        "priceChangePercent",
        "weightedAvgPrice",
        "lastPrice",
        "lastQty",
        "openPrice",
        "highPrice",
        "lowPrice",
        "volume",
        "quoteVolume",
        "openTime",
        "closeTime",
        "firstId",
        "lastId",
        "count",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Ticker24hrPriceChangeStatisticsResponse2Inner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Ticker24hrPriceChangeStatisticsResponse2Inner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "symbol": obj.get("symbol"),
                "priceChange": obj.get("priceChange"),
                "priceChangePercent": obj.get("priceChangePercent"),
                "weightedAvgPrice": obj.get("weightedAvgPrice"),
                "lastPrice": obj.get("lastPrice"),
                "lastQty": obj.get("lastQty"),
                "openPrice": obj.get("openPrice"),
                "highPrice": obj.get("highPrice"),
                "lowPrice": obj.get("lowPrice"),
                "volume": obj.get("volume"),
                "quoteVolume": obj.get("quoteVolume"),
                "openTime": obj.get("openTime"),
                "closeTime": obj.get("closeTime"),
                "firstId": obj.get("firstId"),
                "lastId": obj.get("lastId"),
                "count": obj.get("count"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
