"""
Binance Derivatives Trading USDS Futures WebSocket API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures WebSocket API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from binance_common.models import WebsocketApiResponse
from binance_common.signature import Signers
from binance_common.websocket import WebSocketAPIBase

from ..models import AccountInformationResponse
from ..models import AccountInformationV2Response
from ..models import FuturesAccountBalanceResponse
from ..models import FuturesAccountBalanceV2Response


from typing import Optional


class AccountApi:
    """API Client for AccountApi endpoints."""

    def __init__(
        self,
        websocket_api: WebSocketAPIBase,
        signer: Signers = None,
    ) -> None:
        self.websocket_api = websocket_api
        self.signer = signer

    async def account_information(
        self,
        id: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> WebsocketApiResponse[AccountInformationResponse]:
        """
            Account Information(USER_DATA)
            POST /account.status
            https://developers.binance.com/docs/derivatives/usds-margined-futures/account/websocket-api/Account-Information

            Get current account information. User in single-asset/ multi-assets mode will see different value, see comments in response section for detail.

        Weight: 5

            Args:
                id (Optional[str]): Unique WebSocket request ID.
                recv_window (Optional[int]):

            Returns:
                WebsocketApiResponse[AccountInformationResponse]

            Raises:
                RequiredError: If a required parameter is missing.

        """

        params = {
            **({"id": id} if id is not None else {}),
            **({"recv_window": recv_window} if recv_window is not None else {}),
        }

        payload = {
            "method": "/account.status".replace("/", ""),
            "params": params,
        }

        return await self.websocket_api.send_signed_message(
            payload=payload,
            response_model=AccountInformationResponse,
            signer=self.signer,
        )

    async def account_information_v2(
        self,
        id: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> WebsocketApiResponse[AccountInformationV2Response]:
        """
            Account Information V2(USER_DATA)
            POST /v2/account.status
            https://developers.binance.com/docs/derivatives/usds-margined-futures/account/websocket-api/Account-Information-V2

            Get current account information. User in single-asset/ multi-assets mode will see different value, see comments in response section for detail.

        Weight: 5

            Args:
                id (Optional[str]): Unique WebSocket request ID.
                recv_window (Optional[int]):

            Returns:
                WebsocketApiResponse[AccountInformationV2Response]

            Raises:
                RequiredError: If a required parameter is missing.

        """

        params = {
            **({"id": id} if id is not None else {}),
            **({"recv_window": recv_window} if recv_window is not None else {}),
        }

        payload = {
            "method": "/v2/account.status".replace("/", ""),
            "params": params,
        }

        return await self.websocket_api.send_signed_message(
            payload=payload,
            response_model=AccountInformationV2Response,
            signer=self.signer,
        )

    async def futures_account_balance(
        self,
        id: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> WebsocketApiResponse[FuturesAccountBalanceResponse]:
        """
            Futures Account Balance(USER_DATA)
            POST /account.balance
            https://developers.binance.com/docs/derivatives/usds-margined-futures/account/websocket-api/Futures-Account-Balance

            Query account balance info

        Weight: 5

            Args:
                id (Optional[str]): Unique WebSocket request ID.
                recv_window (Optional[int]):

            Returns:
                WebsocketApiResponse[FuturesAccountBalanceResponse]

            Raises:
                RequiredError: If a required parameter is missing.

        """

        params = {
            **({"id": id} if id is not None else {}),
            **({"recv_window": recv_window} if recv_window is not None else {}),
        }

        payload = {
            "method": "/account.balance".replace("/", ""),
            "params": params,
        }

        return await self.websocket_api.send_signed_message(
            payload=payload,
            response_model=FuturesAccountBalanceResponse,
            signer=self.signer,
        )

    async def futures_account_balance_v2(
        self,
        id: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> WebsocketApiResponse[FuturesAccountBalanceV2Response]:
        """
            Futures Account Balance V2(USER_DATA)
            POST /v2/account.balance
            https://developers.binance.com/docs/derivatives/usds-margined-futures/account/websocket-api/Futures-Account-Balance-V2

            Query account balance info

        Weight: 5

            Args:
                id (Optional[str]): Unique WebSocket request ID.
                recv_window (Optional[int]):

            Returns:
                WebsocketApiResponse[FuturesAccountBalanceV2Response]

            Raises:
                RequiredError: If a required parameter is missing.

        """

        params = {
            **({"id": id} if id is not None else {}),
            **({"recv_window": recv_window} if recv_window is not None else {}),
        }

        payload = {
            "method": "/v2/account.balance".replace("/", ""),
            "params": params,
        }

        return await self.websocket_api.send_signed_message(
            payload=payload,
            response_model=FuturesAccountBalanceV2Response,
            signer=self.signer,
        )
