"""
Binance Derivatives Trading USDS Futures WebSocket API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures WebSocket API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from binance_common.models import WebsocketApiResponse
from binance_common.signature import Signers
from binance_common.websocket import WebSocketAPIBase

from ..models import CloseUserDataStreamResponse
from ..models import KeepaliveUserDataStreamResponse
from ..models import StartUserDataStreamResponse


from typing import Optional


class UserDataStreamsApi:
    """API Client for UserDataStreamsApi endpoints."""

    def __init__(
        self,
        websocket_api: WebSocketAPIBase,
        signer: Signers = None,
    ) -> None:
        self.websocket_api = websocket_api
        self.signer = signer

    async def close_user_data_stream(
        self,
        id: Optional[str] = None,
    ) -> WebsocketApiResponse[CloseUserDataStreamResponse]:
        """
            Close User Data Stream (USER_STREAM)
            POST /userDataStream.stop
            https://developers.binance.com/docs/derivatives/usds-margined-futures/user-data-streams/Close-User-Data-Stream-Wsp

            Close out a user data stream.

        Weight: 1

            Args:
                id (Optional[str]): Unique WebSocket request ID.

            Returns:
                WebsocketApiResponse[CloseUserDataStreamResponse]

            Raises:
                RequiredError: If a required parameter is missing.

        """

        params = {
            **({"id": id} if id is not None else {}),
        }

        payload = {
            "method": "/userDataStream.stop".replace("/", ""),
            "params": params,
        }

        return await self.websocket_api.send_message(
            payload=payload, response_model=CloseUserDataStreamResponse
        )

    async def keepalive_user_data_stream(
        self,
        id: Optional[str] = None,
    ) -> WebsocketApiResponse[KeepaliveUserDataStreamResponse]:
        """
            Keepalive User Data Stream (USER_STREAM)
            POST /userDataStream.ping
            https://developers.binance.com/docs/derivatives/usds-margined-futures/user-data-streams/Keepalive-User-Data-Stream-Wsp

            Keepalive a user data stream to prevent a time out. User data streams will close after 60 minutes. It's recommended to send a ping about every 60 minutes.

        Weight: 1

            Args:
                id (Optional[str]): Unique WebSocket request ID.

            Returns:
                WebsocketApiResponse[KeepaliveUserDataStreamResponse]

            Raises:
                RequiredError: If a required parameter is missing.

        """

        params = {
            **({"id": id} if id is not None else {}),
        }

        payload = {
            "method": "/userDataStream.ping".replace("/", ""),
            "params": params,
        }

        return await self.websocket_api.send_message(
            payload=payload, response_model=KeepaliveUserDataStreamResponse
        )

    async def start_user_data_stream(
        self,
        id: Optional[str] = None,
    ) -> WebsocketApiResponse[StartUserDataStreamResponse]:
        """
            Start User Data Stream (USER_STREAM)
            POST /userDataStream.start
            https://developers.binance.com/docs/derivatives/usds-margined-futures/user-data-streams/Start-User-Data-Stream-Wsp

            Start a new user data stream. The stream will close after 60 minutes unless a keepalive is sent. If the account has an active `listenKey`, that `listenKey` will be returned and its validity will be extended for 60 minutes.

        Weight: 1

            Args:
                id (Optional[str]): Unique WebSocket request ID.

            Returns:
                WebsocketApiResponse[StartUserDataStreamResponse]

            Raises:
                RequiredError: If a required parameter is missing.

        """

        params = {
            **({"id": id} if id is not None else {}),
        }

        payload = {
            "method": "/userDataStream.start".replace("/", ""),
            "params": params,
        }

        return await self.websocket_api.send_message(
            payload=payload, response_model=StartUserDataStreamResponse
        )
