# coding: utf-8

"""
Binance Derivatives Trading USDS Futures WebSocket API

OpenAPI Specification for the Binance Derivatives Trading USDS Futures WebSocket API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Set
from typing_extensions import Self


class PositionInformationV2ResponseResultInner(BaseModel):
    """
    PositionInformationV2ResponseResultInner
    """  # noqa: E501

    symbol: Optional[StrictStr] = None
    position_side: Optional[StrictStr] = Field(default=None, alias="positionSide")
    position_amt: Optional[StrictStr] = Field(default=None, alias="positionAmt")
    entry_price: Optional[StrictStr] = Field(default=None, alias="entryPrice")
    break_even_price: Optional[StrictStr] = Field(default=None, alias="breakEvenPrice")
    mark_price: Optional[StrictStr] = Field(default=None, alias="markPrice")
    unrealized_profit: Optional[StrictStr] = Field(
        default=None, alias="unrealizedProfit"
    )
    liquidation_price: Optional[StrictStr] = Field(
        default=None, alias="liquidationPrice"
    )
    isolated_margin: Optional[StrictStr] = Field(default=None, alias="isolatedMargin")
    notional: Optional[StrictStr] = None
    margin_asset: Optional[StrictStr] = Field(default=None, alias="marginAsset")
    isolated_wallet: Optional[StrictStr] = Field(default=None, alias="isolatedWallet")
    initial_margin: Optional[StrictStr] = Field(default=None, alias="initialMargin")
    maint_margin: Optional[StrictStr] = Field(default=None, alias="maintMargin")
    position_initial_margin: Optional[StrictStr] = Field(
        default=None, alias="positionInitialMargin"
    )
    open_order_initial_margin: Optional[StrictStr] = Field(
        default=None, alias="openOrderInitialMargin"
    )
    adl: Optional[StrictInt] = None
    bid_notional: Optional[StrictStr] = Field(default=None, alias="bidNotional")
    ask_notional: Optional[StrictStr] = Field(default=None, alias="askNotional")
    update_time: Optional[StrictInt] = Field(default=None, alias="updateTime")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "symbol",
        "positionSide",
        "positionAmt",
        "entryPrice",
        "breakEvenPrice",
        "markPrice",
        "unrealizedProfit",
        "liquidationPrice",
        "isolatedMargin",
        "notional",
        "marginAsset",
        "isolatedWallet",
        "initialMargin",
        "maintMargin",
        "positionInitialMargin",
        "openOrderInitialMargin",
        "adl",
        "bidNotional",
        "askNotional",
        "updateTime",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PositionInformationV2ResponseResultInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PositionInformationV2ResponseResultInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "symbol": obj.get("symbol"),
                "positionSide": obj.get("positionSide"),
                "positionAmt": obj.get("positionAmt"),
                "entryPrice": obj.get("entryPrice"),
                "breakEvenPrice": obj.get("breakEvenPrice"),
                "markPrice": obj.get("markPrice"),
                "unrealizedProfit": obj.get("unrealizedProfit"),
                "liquidationPrice": obj.get("liquidationPrice"),
                "isolatedMargin": obj.get("isolatedMargin"),
                "notional": obj.get("notional"),
                "marginAsset": obj.get("marginAsset"),
                "isolatedWallet": obj.get("isolatedWallet"),
                "initialMargin": obj.get("initialMargin"),
                "maintMargin": obj.get("maintMargin"),
                "positionInitialMargin": obj.get("positionInitialMargin"),
                "openOrderInitialMargin": obj.get("openOrderInitialMargin"),
                "adl": obj.get("adl"),
                "bidNotional": obj.get("bidNotional"),
                "askNotional": obj.get("askNotional"),
                "updateTime": obj.get("updateTime"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
