# coding: utf-8

"""
    SensorPush Public API

    This is a swagger definition for the SensorPush public REST API. Download the definition file [here](https://api.sensorpush.com/api/v1/support/swagger/swagger-v1.json).

    The version of the OpenAPI document: v1.0.20240803
    Contact: support@sensorpush.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional

try:
    from pydantic.v1 import BaseModel, conlist
except ImportError:
    from pydantic import BaseModel, conlist

from sensorpush_api.models.report_listing import ReportListing

class ListResponse(BaseModel):
    """
    ListResponse
    """
    files: Optional[conlist(ReportListing)] = None
    __properties = ["files"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ListResponse:
        """Create an instance of ListResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item in self.files:
                if _item:
                    _items.append(_item.to_dict())
            _dict['files'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ListResponse:
        """Create an instance of ListResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ListResponse.parse_obj(obj)

        _obj = ListResponse.parse_obj({
            "files": [ReportListing.from_dict(_item) for _item in obj.get("files")] if obj.get("files") is not None else None
        })
        return _obj


