import datetime

from ameide_core_proto.common.v1 import annotations_pb2 as _annotations_pb2
from ameide_core_proto.common.v1 import common_pb2 as _common_pb2
from google.protobuf import field_mask_pb2 as _field_mask_pb2
from google.protobuf import timestamp_pb2 as _timestamp_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class OrganizationVisibility(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    ORGANIZATION_VISIBILITY_UNSPECIFIED: _ClassVar[OrganizationVisibility]
    ORGANIZATION_VISIBILITY_PRIVATE: _ClassVar[OrganizationVisibility]
    ORGANIZATION_VISIBILITY_INTERNAL: _ClassVar[OrganizationVisibility]
    ORGANIZATION_VISIBILITY_PUBLIC: _ClassVar[OrganizationVisibility]

class MembershipState(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    MEMBERSHIP_STATE_UNSPECIFIED: _ClassVar[MembershipState]
    MEMBERSHIP_STATE_INVITED: _ClassVar[MembershipState]
    MEMBERSHIP_STATE_ACTIVE: _ClassVar[MembershipState]
    MEMBERSHIP_STATE_SUSPENDED: _ClassVar[MembershipState]
    MEMBERSHIP_STATE_REMOVED: _ClassVar[MembershipState]
ORGANIZATION_VISIBILITY_UNSPECIFIED: OrganizationVisibility
ORGANIZATION_VISIBILITY_PRIVATE: OrganizationVisibility
ORGANIZATION_VISIBILITY_INTERNAL: OrganizationVisibility
ORGANIZATION_VISIBILITY_PUBLIC: OrganizationVisibility
MEMBERSHIP_STATE_UNSPECIFIED: MembershipState
MEMBERSHIP_STATE_INVITED: MembershipState
MEMBERSHIP_STATE_ACTIVE: MembershipState
MEMBERSHIP_STATE_SUSPENDED: MembershipState
MEMBERSHIP_STATE_REMOVED: MembershipState

class Organization(_message.Message):
    __slots__ = ()
    class AttributesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    KEY_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    VISIBILITY_FIELD_NUMBER: _ClassVar[int]
    SETTINGS_FIELD_NUMBER: _ClassVar[int]
    ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    REALM_NAME_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    key: str
    name: str
    description: str
    visibility: OrganizationVisibility
    settings: OrganizationSettings
    attributes: _containers.ScalarMap[str, str]
    realm_name: str
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., key: _Optional[str] = ..., name: _Optional[str] = ..., description: _Optional[str] = ..., visibility: _Optional[_Union[OrganizationVisibility, str]] = ..., settings: _Optional[_Union[OrganizationSettings, _Mapping]] = ..., attributes: _Optional[_Mapping[str, str]] = ..., realm_name: _Optional[str] = ...) -> None: ...

class OrganizationSettings(_message.Message):
    __slots__ = ()
    class FeatureTogglesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    DEFAULT_TIME_ZONE_FIELD_NUMBER: _ClassVar[int]
    DEFAULT_LOCALE_FIELD_NUMBER: _ClassVar[int]
    ALLOW_GUEST_ACCESS_FIELD_NUMBER: _ClassVar[int]
    FEATURE_TOGGLES_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    default_time_zone: str
    default_locale: str
    allow_guest_access: bool
    feature_toggles: _containers.ScalarMap[str, str]
    metadata: _containers.ScalarMap[str, str]
    def __init__(self, default_time_zone: _Optional[str] = ..., default_locale: _Optional[str] = ..., allow_guest_access: _Optional[bool] = ..., feature_toggles: _Optional[_Mapping[str, str]] = ..., metadata: _Optional[_Mapping[str, str]] = ...) -> None: ...

class OrganizationMembership(_message.Message):
    __slots__ = ()
    class AttributesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    USER_ID_FIELD_NUMBER: _ClassVar[int]
    ROLE_IDS_FIELD_NUMBER: _ClassVar[int]
    STATE_FIELD_NUMBER: _ClassVar[int]
    INVITED_AT_FIELD_NUMBER: _ClassVar[int]
    ACCEPTED_AT_FIELD_NUMBER: _ClassVar[int]
    SUSPENDED_AT_FIELD_NUMBER: _ClassVar[int]
    ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    user_id: str
    role_ids: _containers.RepeatedScalarFieldContainer[str]
    state: MembershipState
    invited_at: _timestamp_pb2.Timestamp
    accepted_at: _timestamp_pb2.Timestamp
    suspended_at: _timestamp_pb2.Timestamp
    attributes: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., user_id: _Optional[str] = ..., role_ids: _Optional[_Iterable[str]] = ..., state: _Optional[_Union[MembershipState, str]] = ..., invited_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., accepted_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., suspended_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., attributes: _Optional[_Mapping[str, str]] = ...) -> None: ...

class CreateOrganizationRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization: Organization
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization: _Optional[_Union[Organization, _Mapping]] = ...) -> None: ...

class CreateOrganizationResponse(_message.Message):
    __slots__ = ()
    ORGANIZATION_FIELD_NUMBER: _ClassVar[int]
    organization: Organization
    def __init__(self, organization: _Optional[_Union[Organization, _Mapping]] = ...) -> None: ...

class UpdateOrganizationRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_FIELD_NUMBER: _ClassVar[int]
    UPDATE_MASK_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization: Organization
    update_mask: _field_mask_pb2.FieldMask
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization: _Optional[_Union[Organization, _Mapping]] = ..., update_mask: _Optional[_Union[_field_mask_pb2.FieldMask, _Mapping]] = ...) -> None: ...

class UpdateOrganizationResponse(_message.Message):
    __slots__ = ()
    ORGANIZATION_FIELD_NUMBER: _ClassVar[int]
    organization: Organization
    def __init__(self, organization: _Optional[_Union[Organization, _Mapping]] = ...) -> None: ...

class DeleteOrganizationRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    HARD_DELETE_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization_id: str
    hard_delete: bool
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization_id: _Optional[str] = ..., hard_delete: _Optional[bool] = ...) -> None: ...

class DeleteOrganizationResponse(_message.Message):
    __slots__ = ()
    def __init__(self) -> None: ...

class GetOrganizationRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization_id: _Optional[str] = ...) -> None: ...

class GetOrganizationResponse(_message.Message):
    __slots__ = ()
    ORGANIZATION_FIELD_NUMBER: _ClassVar[int]
    organization: Organization
    def __init__(self, organization: _Optional[_Union[Organization, _Mapping]] = ...) -> None: ...

class ListOrganizationsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    USER_ID_FIELD_NUMBER: _ClassVar[int]
    ORG_KEYS_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    pagination: _common_pb2.PaginationRequest
    tenant_id: str
    user_id: str
    org_keys: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ..., tenant_id: _Optional[str] = ..., user_id: _Optional[str] = ..., org_keys: _Optional[_Iterable[str]] = ...) -> None: ...

class ListOrganizationsResponse(_message.Message):
    __slots__ = ()
    ORGANIZATIONS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    organizations: _containers.RepeatedCompositeFieldContainer[Organization]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, organizations: _Optional[_Iterable[_Union[Organization, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class ListOrganizationMembershipsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    STATE_FILTER_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization_id: str
    pagination: _common_pb2.PaginationRequest
    state_filter: MembershipState
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ..., state_filter: _Optional[_Union[MembershipState, str]] = ...) -> None: ...

class ListOrganizationMembershipsResponse(_message.Message):
    __slots__ = ()
    MEMBERSHIPS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    memberships: _containers.RepeatedCompositeFieldContainer[OrganizationMembership]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, memberships: _Optional[_Iterable[_Union[OrganizationMembership, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class UpdateOrganizationMembershipRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    MEMBERSHIP_FIELD_NUMBER: _ClassVar[int]
    UPDATE_MASK_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    membership: OrganizationMembership
    update_mask: _field_mask_pb2.FieldMask
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., membership: _Optional[_Union[OrganizationMembership, _Mapping]] = ..., update_mask: _Optional[_Union[_field_mask_pb2.FieldMask, _Mapping]] = ...) -> None: ...

class UpdateOrganizationMembershipResponse(_message.Message):
    __slots__ = ()
    MEMBERSHIP_FIELD_NUMBER: _ClassVar[int]
    membership: OrganizationMembership
    def __init__(self, membership: _Optional[_Union[OrganizationMembership, _Mapping]] = ...) -> None: ...
