from google.protobuf import descriptor_pb2 as _descriptor_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class PIIType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    PII_TYPE_UNSPECIFIED: _ClassVar[PIIType]
    PII_TYPE_NONE: _ClassVar[PIIType]
    PII_TYPE_PSEUDONYMOUS: _ClassVar[PIIType]
    PII_TYPE_REDACTED: _ClassVar[PIIType]
PII_TYPE_UNSPECIFIED: PIIType
PII_TYPE_NONE: PIIType
PII_TYPE_PSEUDONYMOUS: PIIType
PII_TYPE_REDACTED: PIIType
EVENT_METADATA_FIELD_NUMBER: _ClassVar[int]
event_metadata: _descriptor.FieldDescriptor

class EventMetadata(_message.Message):
    __slots__ = ()
    class PiiFieldsEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: PIIType
        def __init__(self, key: _Optional[str] = ..., value: _Optional[_Union[PIIType, str]] = ...) -> None: ...
    EVENT_NAME_FIELD_NUMBER: _ClassVar[int]
    METRICS_FIELD_NUMBER: _ClassVar[int]
    PII_FIELDS_FIELD_NUMBER: _ClassVar[int]
    STABILITY_FIELD_NUMBER: _ClassVar[int]
    SINCE_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    event_name: str
    metrics: _containers.RepeatedCompositeFieldContainer[MetricDefinition]
    pii_fields: _containers.ScalarMap[str, PIIType]
    stability: str
    since: str
    description: str
    def __init__(self, event_name: _Optional[str] = ..., metrics: _Optional[_Iterable[_Union[MetricDefinition, _Mapping]]] = ..., pii_fields: _Optional[_Mapping[str, PIIType]] = ..., stability: _Optional[str] = ..., since: _Optional[str] = ..., description: _Optional[str] = ...) -> None: ...

class MetricDefinition(_message.Message):
    __slots__ = ()
    class Kind(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        KIND_UNSPECIFIED: _ClassVar[MetricDefinition.Kind]
        KIND_COUNTER: _ClassVar[MetricDefinition.Kind]
        KIND_HISTOGRAM: _ClassVar[MetricDefinition.Kind]
        KIND_UP_DOWN: _ClassVar[MetricDefinition.Kind]
    KIND_UNSPECIFIED: MetricDefinition.Kind
    KIND_COUNTER: MetricDefinition.Kind
    KIND_HISTOGRAM: MetricDefinition.Kind
    KIND_UP_DOWN: MetricDefinition.Kind
    class DefaultLabelsEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    KIND_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    LABELS_FIELD_NUMBER: _ClassVar[int]
    DEFAULT_LABELS_FIELD_NUMBER: _ClassVar[int]
    DELTA_FIELD_NUMBER: _ClassVar[int]
    VALUE_FIELD_FIELD_NUMBER: _ClassVar[int]
    UNIT_FIELD_NUMBER: _ClassVar[int]
    kind: MetricDefinition.Kind
    name: str
    labels: _containers.RepeatedScalarFieldContainer[str]
    default_labels: _containers.ScalarMap[str, str]
    delta: int
    value_field: str
    unit: str
    def __init__(self, kind: _Optional[_Union[MetricDefinition.Kind, str]] = ..., name: _Optional[str] = ..., labels: _Optional[_Iterable[str]] = ..., default_labels: _Optional[_Mapping[str, str]] = ..., delta: _Optional[int] = ..., value_field: _Optional[str] = ..., unit: _Optional[str] = ...) -> None: ...

class AuthSigninAttemptEvent(_message.Message):
    __slots__ = ()
    PROVIDER_FIELD_NUMBER: _ClassVar[int]
    ENDUSER_PSEUDO_ID_FIELD_NUMBER: _ClassVar[int]
    CLIENT_ID_FIELD_NUMBER: _ClassVar[int]
    IP_ADDRESS_FIELD_NUMBER: _ClassVar[int]
    provider: str
    enduser_pseudo_id: str
    client_id: str
    ip_address: str
    def __init__(self, provider: _Optional[str] = ..., enduser_pseudo_id: _Optional[str] = ..., client_id: _Optional[str] = ..., ip_address: _Optional[str] = ...) -> None: ...

class AuthSigninSuccessEvent(_message.Message):
    __slots__ = ()
    PROVIDER_FIELD_NUMBER: _ClassVar[int]
    ENDUSER_PSEUDO_ID_FIELD_NUMBER: _ClassVar[int]
    EMAIL_FIELD_NUMBER: _ClassVar[int]
    SESSION_ID_FIELD_NUMBER: _ClassVar[int]
    SESSION_DURATION_MS_FIELD_NUMBER: _ClassVar[int]
    provider: str
    enduser_pseudo_id: str
    email: str
    session_id: str
    session_duration_ms: int
    def __init__(self, provider: _Optional[str] = ..., enduser_pseudo_id: _Optional[str] = ..., email: _Optional[str] = ..., session_id: _Optional[str] = ..., session_duration_ms: _Optional[int] = ...) -> None: ...

class AuthSigninErrorEvent(_message.Message):
    __slots__ = ()
    PROVIDER_FIELD_NUMBER: _ClassVar[int]
    ERROR_TYPE_FIELD_NUMBER: _ClassVar[int]
    ERROR_MESSAGE_FIELD_NUMBER: _ClassVar[int]
    TRACE_ID_FIELD_NUMBER: _ClassVar[int]
    provider: str
    error_type: str
    error_message: str
    trace_id: str
    def __init__(self, provider: _Optional[str] = ..., error_type: _Optional[str] = ..., error_message: _Optional[str] = ..., trace_id: _Optional[str] = ...) -> None: ...

class AuthSignoutSuccessEvent(_message.Message):
    __slots__ = ()
    ENDUSER_PSEUDO_ID_FIELD_NUMBER: _ClassVar[int]
    SESSION_DURATION_SECONDS_FIELD_NUMBER: _ClassVar[int]
    SIGNOUT_TYPE_FIELD_NUMBER: _ClassVar[int]
    enduser_pseudo_id: str
    session_duration_seconds: int
    signout_type: str
    def __init__(self, enduser_pseudo_id: _Optional[str] = ..., session_duration_seconds: _Optional[int] = ..., signout_type: _Optional[str] = ...) -> None: ...

class AuthTokenRefreshEvent(_message.Message):
    __slots__ = ()
    PROVIDER_FIELD_NUMBER: _ClassVar[int]
    ENDUSER_PSEUDO_ID_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    DURATION_SECONDS_FIELD_NUMBER: _ClassVar[int]
    TOKEN_EXPIRES_IN_FIELD_NUMBER: _ClassVar[int]
    provider: str
    enduser_pseudo_id: str
    status: str
    duration_seconds: float
    token_expires_in: int
    def __init__(self, provider: _Optional[str] = ..., enduser_pseudo_id: _Optional[str] = ..., status: _Optional[str] = ..., duration_seconds: _Optional[float] = ..., token_expires_in: _Optional[int] = ...) -> None: ...

class AuthTokenExpiredEvent(_message.Message):
    __slots__ = ()
    PROVIDER_FIELD_NUMBER: _ClassVar[int]
    ENDUSER_PSEUDO_ID_FIELD_NUMBER: _ClassVar[int]
    TOKEN_TYPE_FIELD_NUMBER: _ClassVar[int]
    REASON_FIELD_NUMBER: _ClassVar[int]
    provider: str
    enduser_pseudo_id: str
    token_type: str
    reason: str
    def __init__(self, provider: _Optional[str] = ..., enduser_pseudo_id: _Optional[str] = ..., token_type: _Optional[str] = ..., reason: _Optional[str] = ...) -> None: ...

class AuthSessionCreatedEvent(_message.Message):
    __slots__ = ()
    SESSION_ID_FIELD_NUMBER: _ClassVar[int]
    ENDUSER_PSEUDO_ID_FIELD_NUMBER: _ClassVar[int]
    PROVIDER_FIELD_NUMBER: _ClassVar[int]
    EXPIRES_AT_FIELD_NUMBER: _ClassVar[int]
    session_id: str
    enduser_pseudo_id: str
    provider: str
    expires_at: int
    def __init__(self, session_id: _Optional[str] = ..., enduser_pseudo_id: _Optional[str] = ..., provider: _Optional[str] = ..., expires_at: _Optional[int] = ...) -> None: ...

class AuthSessionDestroyedEvent(_message.Message):
    __slots__ = ()
    SESSION_ID_FIELD_NUMBER: _ClassVar[int]
    REASON_FIELD_NUMBER: _ClassVar[int]
    DURATION_SECONDS_FIELD_NUMBER: _ClassVar[int]
    session_id: str
    reason: str
    duration_seconds: int
    def __init__(self, session_id: _Optional[str] = ..., reason: _Optional[str] = ..., duration_seconds: _Optional[int] = ...) -> None: ...

class BpmnDiagramSavedEvent(_message.Message):
    __slots__ = ()
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    USER_PSEUDO_ID_FIELD_NUMBER: _ClassVar[int]
    SIZE_BYTES_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_COUNT_FIELD_NUMBER: _ClassVar[int]
    PROCESS_ID_FIELD_NUMBER: _ClassVar[int]
    SAVE_DURATION_SECONDS_FIELD_NUMBER: _ClassVar[int]
    element_id: str
    user_pseudo_id: str
    size_bytes: int
    element_count: int
    process_id: str
    save_duration_seconds: float
    def __init__(self, element_id: _Optional[str] = ..., user_pseudo_id: _Optional[str] = ..., size_bytes: _Optional[int] = ..., element_count: _Optional[int] = ..., process_id: _Optional[str] = ..., save_duration_seconds: _Optional[float] = ...) -> None: ...

class BpmnSaveFailedEvent(_message.Message):
    __slots__ = ()
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    ERROR_TYPE_FIELD_NUMBER: _ClassVar[int]
    ERROR_MESSAGE_FIELD_NUMBER: _ClassVar[int]
    TRACE_ID_FIELD_NUMBER: _ClassVar[int]
    element_id: str
    error_type: str
    error_message: str
    trace_id: str
    def __init__(self, element_id: _Optional[str] = ..., error_type: _Optional[str] = ..., error_message: _Optional[str] = ..., trace_id: _Optional[str] = ...) -> None: ...

class BpmnImportSuccessEvent(_message.Message):
    __slots__ = ()
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    SOURCE_FIELD_NUMBER: _ClassVar[int]
    SIZE_BYTES_FIELD_NUMBER: _ClassVar[int]
    DURATION_SECONDS_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_COUNT_FIELD_NUMBER: _ClassVar[int]
    BPMN_VERSION_FIELD_NUMBER: _ClassVar[int]
    element_id: str
    source: str
    size_bytes: int
    duration_seconds: float
    element_count: int
    bpmn_version: str
    def __init__(self, element_id: _Optional[str] = ..., source: _Optional[str] = ..., size_bytes: _Optional[int] = ..., duration_seconds: _Optional[float] = ..., element_count: _Optional[int] = ..., bpmn_version: _Optional[str] = ...) -> None: ...

class BpmnImportFailedEvent(_message.Message):
    __slots__ = ()
    SOURCE_FIELD_NUMBER: _ClassVar[int]
    ERROR_TYPE_FIELD_NUMBER: _ClassVar[int]
    ERROR_MESSAGE_FIELD_NUMBER: _ClassVar[int]
    SIZE_BYTES_FIELD_NUMBER: _ClassVar[int]
    source: str
    error_type: str
    error_message: str
    size_bytes: int
    def __init__(self, source: _Optional[str] = ..., error_type: _Optional[str] = ..., error_message: _Optional[str] = ..., size_bytes: _Optional[int] = ...) -> None: ...

class BpmnExportSuccessEvent(_message.Message):
    __slots__ = ()
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    FORMAT_FIELD_NUMBER: _ClassVar[int]
    SIZE_BYTES_FIELD_NUMBER: _ClassVar[int]
    DURATION_SECONDS_FIELD_NUMBER: _ClassVar[int]
    element_id: str
    format: str
    size_bytes: int
    duration_seconds: float
    def __init__(self, element_id: _Optional[str] = ..., format: _Optional[str] = ..., size_bytes: _Optional[int] = ..., duration_seconds: _Optional[float] = ...) -> None: ...

class BpmnExportFailedEvent(_message.Message):
    __slots__ = ()
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    FORMAT_FIELD_NUMBER: _ClassVar[int]
    ERROR_TYPE_FIELD_NUMBER: _ClassVar[int]
    ERROR_MESSAGE_FIELD_NUMBER: _ClassVar[int]
    element_id: str
    format: str
    error_type: str
    error_message: str
    def __init__(self, element_id: _Optional[str] = ..., format: _Optional[str] = ..., error_type: _Optional[str] = ..., error_message: _Optional[str] = ...) -> None: ...

class BpmnValidationEvent(_message.Message):
    __slots__ = ()
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    RESULT_FIELD_NUMBER: _ClassVar[int]
    ISSUES_FIELD_NUMBER: _ClassVar[int]
    TOTAL_ISSUES_FIELD_NUMBER: _ClassVar[int]
    element_id: str
    result: str
    issues: _containers.RepeatedCompositeFieldContainer[ValidationIssue]
    total_issues: int
    def __init__(self, element_id: _Optional[str] = ..., result: _Optional[str] = ..., issues: _Optional[_Iterable[_Union[ValidationIssue, _Mapping]]] = ..., total_issues: _Optional[int] = ...) -> None: ...

class ValidationIssue(_message.Message):
    __slots__ = ()
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_TYPE_FIELD_NUMBER: _ClassVar[int]
    SEVERITY_FIELD_NUMBER: _ClassVar[int]
    MESSAGE_FIELD_NUMBER: _ClassVar[int]
    RULE_FIELD_NUMBER: _ClassVar[int]
    element_id: str
    element_type: str
    severity: str
    message: str
    rule: str
    def __init__(self, element_id: _Optional[str] = ..., element_type: _Optional[str] = ..., severity: _Optional[str] = ..., message: _Optional[str] = ..., rule: _Optional[str] = ...) -> None: ...

class MiddlewareRedirectEvent(_message.Message):
    __slots__ = ()
    FROM_PATH_FIELD_NUMBER: _ClassVar[int]
    TO_PATH_FIELD_NUMBER: _ClassVar[int]
    REASON_FIELD_NUMBER: _ClassVar[int]
    IS_INTERNAL_FIELD_NUMBER: _ClassVar[int]
    from_path: str
    to_path: str
    reason: str
    is_internal: bool
    def __init__(self, from_path: _Optional[str] = ..., to_path: _Optional[str] = ..., reason: _Optional[str] = ..., is_internal: _Optional[bool] = ...) -> None: ...

class MiddlewareBlockEvent(_message.Message):
    __slots__ = ()
    PATH_FIELD_NUMBER: _ClassVar[int]
    REASON_FIELD_NUMBER: _ClassVar[int]
    METHOD_FIELD_NUMBER: _ClassVar[int]
    IP_ADDRESS_FIELD_NUMBER: _ClassVar[int]
    path: str
    reason: str
    method: str
    ip_address: str
    def __init__(self, path: _Optional[str] = ..., reason: _Optional[str] = ..., method: _Optional[str] = ..., ip_address: _Optional[str] = ...) -> None: ...

class ApiRequestEvent(_message.Message):
    __slots__ = ()
    METHOD_FIELD_NUMBER: _ClassVar[int]
    PATH_FIELD_NUMBER: _ClassVar[int]
    STATUS_CODE_FIELD_NUMBER: _ClassVar[int]
    DURATION_SECONDS_FIELD_NUMBER: _ClassVar[int]
    RESPONSE_SIZE_BYTES_FIELD_NUMBER: _ClassVar[int]
    TRACE_ID_FIELD_NUMBER: _ClassVar[int]
    method: str
    path: str
    status_code: int
    duration_seconds: float
    response_size_bytes: int
    trace_id: str
    def __init__(self, method: _Optional[str] = ..., path: _Optional[str] = ..., status_code: _Optional[int] = ..., duration_seconds: _Optional[float] = ..., response_size_bytes: _Optional[int] = ..., trace_id: _Optional[str] = ...) -> None: ...

class DatabaseQueryEvent(_message.Message):
    __slots__ = ()
    OPERATION_FIELD_NUMBER: _ClassVar[int]
    TABLE_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    DURATION_SECONDS_FIELD_NUMBER: _ClassVar[int]
    ROWS_AFFECTED_FIELD_NUMBER: _ClassVar[int]
    ERROR_CODE_FIELD_NUMBER: _ClassVar[int]
    operation: str
    table: str
    status: str
    duration_seconds: float
    rows_affected: int
    error_code: str
    def __init__(self, operation: _Optional[str] = ..., table: _Optional[str] = ..., status: _Optional[str] = ..., duration_seconds: _Optional[float] = ..., rows_affected: _Optional[int] = ..., error_code: _Optional[str] = ...) -> None: ...
