class e{constructor(){this.container=null,this.events=[],this.sessions=new Map,this.currentSession=null,this.selectedSessionFilter="all",this.timeRange="30min",this.searchTerm="",this.initialized=!1,this.expandedSessions=new Set,this.expandedAgents=new Set,this.expandedTools=new Set,this.selectedItem=null}initialize(){if(console.log("ActivityTree.initialize() called, initialized:",this.initialized),this.initialized)return void console.log("Activity tree already initialized, skipping");if(this.container=document.getElementById("activity-tree-container"),!this.container&&(this.container=document.getElementById("activity-tree"),!this.container))return void console.error("Activity tree container not found in DOM");const e=document.getElementById("activity-tab");if(e){if(!e.classList.contains("active"))return console.log("Activity tab not active, initializing but deferring render"),this.setupControls(),this.subscribeToEvents(),void(this.initialized=!0);this.setupControls(),this.createLinearTreeView(),this.subscribeToEvents(),this.initialized=!0,console.log("Activity tree initialization complete")}else console.error("Activity tab panel (#activity-tab) not found in DOM")}forceShow(){console.log("ActivityTree.forceShow() called"),this.container||(this.container=document.getElementById("activity-tree-container")||document.getElementById("activity-tree"),this.container)?(this.createLinearTreeView(),this.renderTree()):console.error("Cannot find activity tree container")}renderWhenVisible(){if(console.log("ActivityTree.renderWhenVisible() called"),!this.initialized)return console.log("Not initialized yet, calling initialize..."),void this.initialize();this.createLinearTreeView(),this.renderTree()}setupControls(){const e=document.getElementById("time-range");e&&e.addEventListener("change",e=>{this.timeRange=e.target.value,console.log(`ActivityTree: Time range changed to: ${this.timeRange}`),this.renderTree()}),document.addEventListener("sessionFilterChanged",e=>{this.selectedSessionFilter=e.detail.sessionId||"all",console.log(`ActivityTree: Session filter changed to: ${this.selectedSessionFilter} (from SessionManager)`),this.renderTree()}),document.addEventListener("sessionChanged",e=>{this.selectedSessionFilter=e.detail.sessionId||"all",console.log(`ActivityTree: Session changed to: ${this.selectedSessionFilter} (from SessionManager - backward compat)`),this.renderTree()}),setTimeout(()=>{if(window.sessionManager){const e=window.sessionManager.getCurrentFilter();e!==this.selectedSessionFilter&&(this.selectedSessionFilter=e||"all",console.log(`ActivityTree: Initialized with current session filter: ${this.selectedSessionFilter}`),this.renderTree())}},100);const t=document.getElementById("expand-all");t&&t.addEventListener("click",()=>this.expandAllSessions());const s=document.getElementById("collapse-all");s&&s.addEventListener("click",()=>this.collapseAllSessions());const n=document.getElementById("reset-zoom");n&&(n.style.display="inline-block",n.addEventListener("click",()=>this.resetZoom()));const i=document.getElementById("activity-search");i&&i.addEventListener("input",e=>{this.searchTerm=e.target.value.toLowerCase(),this.renderTree()})}createLinearTreeView(){console.log("Creating linear tree view"),this.container.innerHTML="";const e=document.createElement("div");e.id="linear-tree",e.className="linear-tree",this.container.appendChild(e),console.log("Linear tree view created")}subscribeToEvents(){if(!window.socketClient)return console.warn("Socket client not available for activity tree"),void setTimeout(()=>this.subscribeToEvents(),1e3);console.log("ActivityTree: Setting up event subscription"),window.socketClient.onEventUpdate((e,t)=>{console.log(`ActivityTree: onEventUpdate called with ${e.length} total events and ${t.size} sessions`),this.sessions.clear();for(const[n,i]of t.entries()){const e={id:n,timestamp:new Date(i.lastActivity||i.startTime||new Date),expanded:this.expandedSessions.has(n)||!0,agents:new Map,todos:[],userInstructions:[],tools:[],status:"active",currentTodoTool:null,working_directory:i.working_directory,git_branch:i.git_branch,eventCount:i.eventCount};this.sessions.set(n,e)}const s=e.length-this.events.length;if(s>0){const t=e.slice(this.events.length);console.log(`ActivityTree: Processing ${s} new events`,t),t.forEach(e=>{this.processEvent(e)})}this.events=[...e],this.renderTree(),console.log("ActivityTree: Sessions after sync with socket client:",Array.from(this.sessions.entries()))});const e=window.socketClient?.getState();if(e&&e.events.length>0){console.log(`ActivityTree: Loading existing data - ${e.events.length} events, ${e.sessions.size} sessions`),this.sessions.clear();for(const[t,s]of e.sessions.entries()){const e={id:t,timestamp:new Date(s.lastActivity||s.startTime||new Date),expanded:this.expandedSessions.has(t)||!0,agents:new Map,todos:[],userInstructions:[],tools:[],status:"active",currentTodoTool:null,working_directory:s.working_directory,git_branch:s.git_branch,eventCount:s.eventCount};this.sessions.set(t,e)}e.events.forEach(e=>{this.processEvent(e)}),this.events=[...e.events],this.renderTree(),console.log("ActivityTree: Initial sessions state:",Array.from(this.sessions.entries()))}else console.log("ActivityTree: No existing events found"),this.events=[],this.sessions.clear(),this.renderTree()}processEvent(e){if(!e)return void console.log("ActivityTree: Ignoring null event");let t,s=this.getEventType(e);if(!s)return;console.log(`ActivityTree: Processing event: ${s}`,e),e.timestamp?(t=new Date(e.timestamp),isNaN(t.getTime())&&(console.warn("ActivityTree: Invalid timestamp, using current time:",e.timestamp),t=new Date)):(console.warn("ActivityTree: No timestamp found, using current time"),t=new Date);const n=e.session_id||e.data?.session_id;if(!n)return void console.log(`ActivityTree: Skipping event without session_id: ${s}`);if(!this.sessions.has(n))return void console.warn(`ActivityTree: Session ${n} not found in authoritative sessions - skipping event`);const i=this.sessions.get(n);switch(s){case"Start":this.currentSession=i;break;case"user_prompt":this.processUserInstruction(e,i);break;case"TodoWrite":this.processTodoWrite(e,i);break;case"SubagentStart":this.processSubagentStart(e,i);break;case"SubagentStop":this.processSubagentStop(e,i);break;case"PreToolUse":this.processToolUse(e,i);break;case"PostToolUse":this.updateToolStatus(e,i,"completed")}this.updateStats()}getEventType(e){if(e.hook_event_name)return e.hook_event_name;if("hook"===e.type&&e.subtype){return{pre_tool:"PreToolUse",post_tool:"PostToolUse",subagent_start:"SubagentStart",subagent_stop:"SubagentStop",todo_write:"TodoWrite"}[e.subtype]}if("todo"===e.type&&"updated"===e.subtype)return"TodoWrite";if("subagent"===e.type){if("started"===e.subtype)return"SubagentStart";if("stopped"===e.subtype)return"SubagentStop"}return"start"===e.type?"Start":"user_prompt"===e.type||"user_prompt"===e.subtype?"user_prompt":null}processUserInstruction(e,t){const s=e.prompt_text||e.data?.prompt_text||e.prompt||"";if(!s)return;const n={id:`instruction-${t.id}-${Date.now()}`,text:s,preview:s.length>100?s.substring(0,100)+"...":s,timestamp:e.timestamp||(new Date).toISOString(),type:"user_instruction"};t.userInstructions.push(n),t.userInstructions.length>5&&(t.userInstructions=t.userInstructions.slice(-5))}processTodoWrite(e,t){let s=e.todos||e.data?.todos||e.data||[];if(s&&"object"==typeof s&&s.todos&&(s=s.todos),!Array.isArray(s)||0===s.length)return;t.todos=s.map(t=>({content:t.content,activeForm:t.activeForm,status:t.status,timestamp:e.timestamp}));const n={id:`todo-session-${t.id}-${Date.now()}`,name:"TodoWrite",type:"tool",icon:"📝",timestamp:e.timestamp,status:"active",params:{todos:s},isPrioritizedTool:!0};t.tools=t.tools.filter(e=>"TodoWrite"!==e.name),t.tools.unshift(n),t.currentTodoTool=n;const i=e.session_id||e.data?.session_id;let a=null;if(i&&t.agents.has(i))a=t.agents.get(i);else{const e=Array.from(t.agents.values()).filter(e=>"active"===e.status||"in_progress"===e.status).sort((e,t)=>new Date(t.timestamp)-new Date(e.timestamp));if(e.length>0)a=e[0];else{const e=Array.from(t.agents.values()).sort((e,t)=>new Date(t.timestamp)-new Date(e.timestamp));e.length>0&&(a=e[0])}}if(a){const t={id:`todo-agent-${a.id}-${Date.now()}`,name:"TodoWrite",type:"tool",icon:"📝",timestamp:e.timestamp,status:"active",params:{todos:s},isPrioritizedTool:!0};a.tools=a.tools.filter(e=>"TodoWrite"!==e.name),a.tools.unshift(t)}}processSubagentStart(e,t){const s=e.agent_name||e.data?.agent_name||e.data?.agent_type||e.agent_type||e.agent||"unknown",n=e.session_id||e.data?.session_id,i=n||`agent-${Date.now()}-${Math.random()}`;if(t.agents.has(i)){const s=t.agents.get(i);s.status="active",s.timestamp=e.timestamp}else{const a={id:i,name:s,type:"agent",icon:this.getAgentIcon(s),timestamp:e.timestamp,status:"active",tools:[],sessionId:n,isPM:!1};t.agents.set(i,a)}}processSubagentStop(e,t){const s=e.session_id||e.data?.session_id;if(s&&t.agents.has(s)){t.agents.get(s).status="completed"}}processToolUse(e,t){const s=e.tool_name||e.data?.tool_name||e.tool||e.data?.tool||"unknown",n=e.tool_parameters||e.data?.tool_parameters||e.parameters||e.data?.parameters||{},i=e.session_id||e.data?.session_id,a={id:`tool-${Date.now()}-${Math.random()}`,name:s,type:"tool",icon:this.getToolIcon(s),timestamp:e.timestamp,status:"in_progress",params:n,eventId:e.id};let o=null;if(i&&t.agents.has(i))o=t.agents.get(i);else{const e=Array.from(t.agents.values()).filter(e=>"active"===e.status).sort((e,t)=>new Date(t.timestamp)-new Date(e.timestamp));if(!(e.length>0))return void t.tools.push(a);o=e[0]}o&&o.tools.push(a)}updateToolStatus(e,t,s){const n=t=>{if(t.tools){const n=t.tools.find(t=>t.eventId===e.id);if(n)return n.status=s,!0}return!1};for(let i of t.agents.values())if(n(i))return;!t.tools||n(t)}renderTree(){const e=document.getElementById("linear-tree");if(!e)return;e.innerHTML="";const t=Array.from(this.sessions.values()).sort((e,t)=>new Date(t.timestamp)-new Date(e.timestamp));for(let s of t){if("all"!==this.selectedSessionFilter&&this.selectedSessionFilter!==s.id)continue;const t=this.createSessionElement(s);e.appendChild(t)}}createSessionElement(e){const t=this.expandedSessions.has(e.id)||e.expanded;let s;try{const t=e.timestamp instanceof Date?e.timestamp:new Date(e.timestamp);isNaN(t.getTime())?(s="Invalid Date",console.warn("ActivityTree: Invalid session timestamp:",e.timestamp)):s=t.toLocaleString()}catch(l){s="Invalid Date",console.error("ActivityTree: Error formatting session timestamp:",l,e.timestamp)}const n=document.createElement("div");n.className="tree-node session",n.dataset.sessionId=e.id;const i=t?"▼":"▶",a=e.agents?e.agents.size:0,o=e.todos?e.todos.length:0,r=e.userInstructions?e.userInstructions.length:0;return console.log(`ActivityTree: Rendering session ${e.id}: ${a} agents, ${r} instructions, ${o} todos at ${s}`),n.innerHTML=`\n            <div class="tree-node-content" onclick="window.activityTreeInstance.toggleSession('${e.id}')">\n                <span class="tree-expand-icon">${i}</span>\n                <span class="tree-icon">🎯</span>\n                <span class="tree-label">PM Session</span>\n                <span class="tree-meta">${s} • ${a} agent(s) • ${r} instruction(s) • ${o} todo(s)</span>\n            </div>\n            <div class="tree-children" style="display: ${t?"block":"none"}">\n                ${this.renderSessionContent(e)}\n            </div>\n        `,n}renderSessionContent(e){let t="";if(e.userInstructions&&e.userInstructions.length>0)for(let n of e.userInstructions.slice(-3))t+=this.renderUserInstructionElement(n,1);if(e.todos&&e.todos.length>0&&(t+=this.renderTodoChecklistElement(e.todos,1)),e.tools&&e.tools.length>0)for(let n of e.tools)t+=this.renderToolElement(n,1);const s=Array.from(e.agents.values()).sort((e,t)=>new Date(t.timestamp)-new Date(e.timestamp));for(let n of s)t+=this.renderAgentElement(n,1);return t}renderUserInstructionElement(e,t){return`\n            <div class="tree-node user-instruction ${this.selectedItem&&"instruction"===this.selectedItem.type&&this.selectedItem.data.id===e.id?"selected":""}" data-level="${t}">\n                <div class="tree-node-content">\n                    <span class="tree-expand-icon"></span>\n                    <span class="tree-icon">💬</span>\n                    <span class="tree-label clickable" onclick="window.activityTreeInstance.selectItem(${this.escapeJson(e)}, 'instruction', event)">User: "${this.escapeHtml(e.preview)}"</span>\n                    <span class="tree-status status-active">instruction</span>\n                </div>\n            </div>\n        `}renderTodoChecklistElement(e,t){const s=`checklist-${Date.now()}`,n=!1!==this.expandedTools.has(s),i=n?"▼":"▶";let a=0,o=0;e.forEach(e=>{"completed"===e.status?a++:"in_progress"===e.status&&o++});let r="";r=o>0?`${o} in progress, ${a} completed`:a===e.length&&e.length>0?`All ${e.length} completed`:`${e.length} todo(s)`;let l=`\n            <div class="tree-node todo-checklist" data-level="${t}">\n                <div class="tree-node-content">\n                    <span class="tree-expand-icon" onclick="window.activityTreeInstance.toggleTodoChecklist('${s}'); event.stopPropagation();">${i}</span>\n                    <span class="tree-icon">☑️</span>\n                    <span class="tree-label">TODOs</span>\n                    <span class="tree-params">${r}</span>\n                    <span class="tree-status status-active">checklist</span>\n                </div>\n        `;if(n){l+='<div class="tree-children">';for(let s of e){const e=this.getCheckboxIcon(s.status),n=`status-${s.status}`,i="in_progress"===s.status?s.activeForm:s.content;l+=`\n                    <div class="tree-node todo-item ${n}" data-level="${t+1}">\n                        <div class="tree-node-content">\n                            <span class="tree-expand-icon"></span>\n                            <span class="tree-icon">${e}</span>\n                            <span class="tree-label">${this.escapeHtml(i)}</span>\n                            <span class="tree-status ${n}">${s.status.replace("_"," ")}</span>\n                        </div>\n                    </div>\n                `}l+="</div>"}return l+="</div>",l}renderAgentElement(e,t){const s="active"===e.status?"status-active":"status-completed",n=this.expandedAgents.has(e.id),i=e.tools&&e.tools.length>0,a=i?n?"▼":"▶":"";let o=`\n            <div class="tree-node agent ${s} ${this.selectedItem&&"agent"===this.selectedItem.type&&this.selectedItem.data.id===e.id?"selected":""}" data-level="${t}">\n                <div class="tree-node-content">\n                    ${a?`<span class="tree-expand-icon" onclick="window.activityTreeInstance.toggleAgent('${e.id}'); event.stopPropagation();">${a}</span>`:'<span class="tree-expand-icon"></span>'}\n                    <span class="tree-icon">${e.icon}</span>\n                    <span class="tree-label clickable" onclick="window.activityTreeInstance.selectItem(${this.escapeJson(e)}, 'agent', event)">${e.name}</span>\n                    <span class="tree-status ${s}">${e.status}</span>\n                </div>\n        `;if(i&&n){o+='<div class="tree-children">';for(let s of e.tools)o+=this.renderToolElement(s,t+1);o+="</div>"}return o+="</div>",o}renderToolElement(e,t){const s=`status-${e.status}`,n=this.getToolParams(e);return`\n            <div class="tree-node tool ${s} ${this.selectedItem&&"tool"===this.selectedItem.type&&this.selectedItem.data.id===e.id?"selected":""}" data-level="${t}">\n                <div class="tree-node-content">\n                    <span class="tree-expand-icon"></span>\n                    <span class="tree-icon">${e.icon}</span>\n                    <span class="tree-label clickable" onclick="window.activityTreeInstance.selectItem(${this.escapeJson(e)}, 'tool', event)">${e.name} (click to view details)</span>\n                    <span class="tree-params">${n}</span>\n                    <span class="tree-status ${s}">${e.status}</span>\n                </div>\n            </div>\n        `}getToolParams(e){if(!e.params)return"";if("Read"===e.name&&e.params.file_path)return e.params.file_path;if("Edit"===e.name&&e.params.file_path)return e.params.file_path;if("Write"===e.name&&e.params.file_path)return e.params.file_path;if("Bash"===e.name&&e.params.command){const t=e.params.command;return t.length>50?t.substring(0,50)+"...":t}return"WebFetch"===e.name&&e.params.url?e.params.url:""}getStatusIcon(e){return{pending:"⏸️",in_progress:"🔄",completed:"✅"}[e]||"❓"}getCheckboxIcon(e){return{pending:"⏳",in_progress:"🔄",completed:"✅"}[e]||"❓"}getAgentIcon(e){return{engineer:"👷",research:"🔬",qa:"🧪",ops:"⚙️",pm:"📊",architect:"🏗️"}[e.toLowerCase()]||"🤖"}getToolIcon(e){return{read:"👁️",write:"✍️",edit:"✏️",bash:"💻",webfetch:"🌐",grep:"🔍",glob:"📂",todowrite:"📝"}[e.toLowerCase()]||"🔧"}toggleSession(e){this.expandedSessions.has(e)?this.expandedSessions.delete(e):this.expandedSessions.add(e);const t=this.sessions.get(e);t&&(t.expanded=this.expandedSessions.has(e)),this.renderTree()}expandAllSessions(){for(let e of this.sessions.keys()){this.expandedSessions.add(e);const t=this.sessions.get(e);t&&(t.expanded=!0)}this.renderTree()}collapseAllSessions(){this.expandedSessions.clear();for(let e of this.sessions.values())e.expanded=!1;this.renderTree()}updateStats(){const e=this.countTotalNodes(),t=this.countActiveNodes(),s=this.calculateMaxDepth(),n=document.getElementById("node-count"),i=document.getElementById("active-count"),a=document.getElementById("tree-depth");n&&(n.textContent=e),i&&(i.textContent=t),a&&(a.textContent=s),console.log(`ActivityTree: Stats updated - Nodes: ${e}, Active: ${t}, Depth: ${s}`)}countTotalNodes(){let e=0;for(let t of this.sessions.values()){e+=1,e+=t.agents.size,t.userInstructions&&(e+=t.userInstructions.length),t.todos&&(e+=t.todos.length),t.tools&&(e+=t.tools.length);for(let s of t.agents.values())s.tools&&(e+=s.tools.length)}return e}countActiveNodes(){let e=0;for(let t of this.sessions.values()){if("active"===t.status&&e++,t.todos)for(let s of t.todos)"in_progress"===s.status&&e++;if(t.tools)for(let s of t.tools)"in_progress"===s.status&&e++;for(let s of t.agents.values())if("active"===s.status&&e++,s.tools)for(let t of s.tools)"in_progress"===t.status&&e++}return e}calculateMaxDepth(){let e=0;for(let t of this.sessions.values()){let s=1;t.userInstructions&&t.userInstructions.length>0&&(s=Math.max(s,2)),t.todos&&t.todos.length>0&&(s=Math.max(s,3)),t.tools&&t.tools.length>0&&(s=Math.max(s,2));for(let e of t.agents.values())e.tools&&e.tools.length>0&&(s=Math.max(s,3));e=Math.max(e,s)}return e}toggleAgent(e){this.expandedAgents.has(e)?this.expandedAgents.delete(e):this.expandedAgents.add(e),this.renderTree()}toggleTool(e){console.log("Tool expansion is disabled. Tools now show data in the left pane when clicked.")}toggleTodoChecklist(e){this.expandedTools.has(e)?this.expandedTools.delete(e):this.expandedTools.add(e),this.renderTree()}selectItem(e,t,s){s&&s.stopPropagation(),this.selectedItem={data:e,type:t},this.displayItemData(e,t),this.renderTree()}displayItemData(e,t){const s=document.getElementById("module-data-content");if(!s)return;let n="",i="";switch(t){case"agent":i=`🤖 Agent: ${e.name}`,n=this.formatAgentData(e);break;case"tool":i=`🔧 Tool: ${e.name}`,n=this.formatToolData(e);break;case"instruction":i="💬 User Instruction",n=this.formatInstructionData(e);break;default:i="📊 Item Details",n=this.formatGenericData(e)}s.innerHTML=`\n            <div class="module-item-details">\n                <div class="module-item-header">\n                    <h6>${i}</h6>\n                    <span class="module-item-timestamp">${new Date(e.timestamp).toLocaleString()}</span>\n                </div>\n                <div class="module-item-content">\n                    ${n}\n                </div>\n            </div>\n        `;const a=document.querySelector(".module-data-header h5");a&&(a.textContent=i)}formatAgentData(e){return`\n            <div class="agent-details">\n                <div class="detail-row">\n                    <span class="detail-label">Name:</span>\n                    <span class="detail-value">${e.name}</span>\n                </div>\n                <div class="detail-row">\n                    <span class="detail-label">Status:</span>\n                    <span class="detail-value status-${e.status}">${e.status}</span>\n                </div>\n                <div class="detail-row">\n                    <span class="detail-label">Session ID:</span>\n                    <span class="detail-value">${e.sessionId||"N/A"}</span>\n                </div>\n                <div class="detail-row">\n                    <span class="detail-label">Tools Used:</span>\n                    <span class="detail-value">${e.tools?e.tools.length:0}</span>\n                </div>\n                ${e.tools&&e.tools.length>0?`\n                    <div class="detail-section">\n                        <span class="detail-section-title">Tools:</span>\n                        <div class="tools-list">\n                            ${e.tools.map(e=>`\n                                <div class="tool-summary">\n                                    <span class="tool-icon">${this.getToolIcon(e.name)}</span>\n                                    <span class="tool-name">${e.name}</span>\n                                    <span class="tool-status status-${e.status}">${e.status}</span>\n                                </div>\n                            `).join("")}\n                        </div>\n                    </div>\n                `:""}\n            </div>\n        `}formatToolData(e){const t=e.params?Object.keys(e.params):[];return`\n            <div class="tool-details">\n                <div class="detail-row">\n                    <span class="detail-label">Tool:</span>\n                    <span class="detail-value">${e.icon} ${e.name}</span>\n                </div>\n                <div class="detail-row">\n                    <span class="detail-label">Status:</span>\n                    <span class="detail-value">\n                        <span class="status-badge status-${e.status}">${e.status.replace("_"," ")}</span>\n                    </span>\n                </div>\n                <div class="detail-row">\n                    <span class="detail-label">Timestamp:</span>\n                    <span class="detail-value">${new Date(e.timestamp).toLocaleString()}</span>\n                </div>\n                ${t.length>0?`\n                    <div class="detail-section">\n                        <span class="detail-section-title">Parameters (${t.length}):</span>\n                        <div class="params-list">\n                            ${t.map(t=>{const s=e.params[t];return`\n                                    <div class="param-item">\n                                        <div class="param-key">${t}:</div>\n                                        <div class="param-value">${this.formatDetailedParamValue(s)}</div>\n                                    </div>\n                                `}).join("")}\n                        </div>\n                    </div>\n                `:'\n                    <div class="detail-section">\n                        <span class="detail-section-title">Parameters:</span>\n                        <div class="params-list">\n                            <div class="param-item">\n                                <div class="param-value">No parameters</div>\n                            </div>\n                        </div>\n                    </div>\n                '}\n                ${e.result?`\n                    <div class="detail-section">\n                        <span class="detail-section-title">Result:</span>\n                        <pre class="tool-result">${this.escapeHtml(JSON.stringify(e.result,null,2))}</pre>\n                    </div>\n                `:""}\n            </div>\n        `}formatParamValue(e){return"string"==typeof e&&e.length>100?e.substring(0,100)+"...":"object"==typeof e?JSON.stringify(e):String(e)}formatDetailedParamValue(e){if("string"==typeof e)return e.length>500?`<pre class="param-text-long">${this.escapeHtml(e.substring(0,500)+"...\n\n[Content truncated - "+e.length+" total characters]")}</pre>`:e.length>100?`<pre class="param-text">${this.escapeHtml(e)}</pre>`:`<span class="param-text-short">${this.escapeHtml(e)}</span>`;if("object"!=typeof e)return`<span class="param-primitive">${this.escapeHtml(String(e))}</span>`;try{return`<pre class="param-json">${this.escapeHtml(JSON.stringify(e,null,2))}</pre>`}catch(t){return'<span class="param-error">Error displaying object</span>'}}formatInstructionData(e){return`\n            <div class="instruction-details">\n                <div class="detail-row">\n                    <span class="detail-label">Text:</span>\n                    <span class="detail-value">${this.escapeHtml(e.text)}</span>\n                </div>\n                <div class="detail-row">\n                    <span class="detail-label">Timestamp:</span>\n                    <span class="detail-value">${new Date(e.timestamp).toLocaleString()}</span>\n                </div>\n                <div class="detail-row">\n                    <span class="detail-label">Length:</span>\n                    <span class="detail-value">${e.text.length} characters</span>\n                </div>\n            </div>\n        `}formatGenericData(e){if("object"==typeof e){let t='<div class="generic-details">';const s=["id","name","type","status","timestamp","text","content"];for(let n of s)if(void 0!==e[n]){let s=e[n];"string"==typeof s&&s.length>200&&(s=s.substring(0,200)+"..."),t+=`\n                        <div class="detail-row">\n                            <span class="detail-label">${n}:</span>\n                            <span class="detail-value">${this.escapeHtml(String(s))}</span>\n                        </div>\n                    `}return t+="</div>",t}return`<div class="simple-value">${this.escapeHtml(String(e))}</div>`}escapeHtml(e){const t=document.createElement("div");return t.textContent=e,t.innerHTML}resetZoom(){this.svg&&this.zoom&&this.svg.transition().duration(this.duration).call(this.zoom.transform,d3.zoomIdentity)}escapeJson(e){return JSON.stringify(e).replace(/'/g,"&apos;").replace(/"/g,"&quot;")}}window.ActivityTree=e;const t=()=>{let t=null;const s=()=>{t||(console.log("Creating new Activity Tree instance..."),t=new e,window.activityTreeInstance=t,window.activityTree=()=>t),setTimeout(()=>{console.log("Attempting to initialize Activity Tree visualization..."),t.initialize()},100)};document.querySelectorAll(".tab-button").forEach(e=>{e.addEventListener("click",e=>{"activity"===e.target.getAttribute("data-tab")&&(console.log("Activity tab button clicked, initializing tree..."),s(),t&&setTimeout(()=>{t.renderWhenVisible(),t.forceShow()},150))})}),document.addEventListener("tabChanged",e=>{e.detail&&"activity"===e.detail.newTab&&(console.log("Tab changed to activity, initializing tree..."),s(),t&&setTimeout(()=>{t.renderWhenVisible(),t.forceShow()},150))});const n=document.querySelector(".tab-button.active");n&&"activity"===n.getAttribute("data-tab")&&(console.log("Activity tab is active on load, initializing tree..."),s());const i=document.getElementById("activity-tab");i&&i.classList.contains("active")&&(console.log("Activity panel is active on load, initializing tree..."),t||s())};"loading"===document.readyState?document.addEventListener("DOMContentLoaded",t):t();
//# sourceMappingURL=activity-tree.js.map
