# Generated by Django 2.2.4 on 2019-08-22 21:47

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("psu_base", "0007_auto_20190813_1122"),
    ]

    operations = [
        migrations.CreateModel(
            name="AdminScript",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "app_code",
                    models.CharField(
                        blank=True,
                        default=None,
                        help_text="Application that this script belongs to. NULL applies to all apps (global)",
                        max_length=15,
                        null=True,
                        verbose_name="Application Code",
                    ),
                ),
                ("last_updated", models.DateTimeField(auto_now=True)),
                (
                    "developer",
                    models.CharField(
                        help_text="This developer who last modified this script",
                        max_length=30,
                        verbose_name="Developer",
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        help_text="What does the script do. Why is it needed.",
                        max_length=100,
                        verbose_name="Description of the Script",
                    ),
                ),
                (
                    "target_username",
                    models.CharField(
                        help_text="This script will apply only to the specified user",
                        max_length=30,
                        verbose_name="Targeted User",
                    ),
                ),
                (
                    "target_url",
                    models.CharField(
                        help_text="This script will apply only to the specified user",
                        max_length=80,
                        verbose_name="Targeted User",
                    ),
                ),
                (
                    "enabled",
                    models.CharField(
                        choices=[("N", "No"), ("Y", "Yes")],
                        default="N",
                        help_text="Is this script enabled?",
                        max_length=1,
                    ),
                ),
                ("eff_date", models.DateTimeField(blank=True, null=True)),
                ("end_date", models.DateTimeField(blank=True, null=True)),
                (
                    "javascript",
                    models.CharField(
                        blank=True,
                        help_text="JavaScript code to run when page loads",
                        max_length=4000,
                        null=True,
                        verbose_name="JavaScript Code",
                    ),
                ),
            ],
        ),
    ]
