# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplianceTrafficShapingRulesArgs', 'ApplianceTrafficShapingRules']

@pulumi.input_type
class ApplianceTrafficShapingRulesArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 default_rules_enabled: Optional[pulumi.Input[bool]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingRulesRuleArgs']]]] = None):
        """
        The set of arguments for constructing a ApplianceTrafficShapingRules resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[bool] default_rules_enabled: Whether default traffic shaping rules are enabled (true) or disabled (false). There are 4 default rules, which can be seen on your network's traffic shaping page. Note that default rules count against the rule limit of 8.
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingRulesRuleArgs']]] rules: An array of traffic shaping rules. Rules are applied in the order that
               they are specified in. An empty list (or null) means no rules. Note that
               you are allowed a maximum of 8 rules.
        """
        pulumi.set(__self__, "network_id", network_id)
        if default_rules_enabled is not None:
            pulumi.set(__self__, "default_rules_enabled", default_rules_enabled)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="defaultRulesEnabled")
    def default_rules_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether default traffic shaping rules are enabled (true) or disabled (false). There are 4 default rules, which can be seen on your network's traffic shaping page. Note that default rules count against the rule limit of 8.
        """
        return pulumi.get(self, "default_rules_enabled")

    @default_rules_enabled.setter
    def default_rules_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default_rules_enabled", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingRulesRuleArgs']]]]:
        """
        An array of traffic shaping rules. Rules are applied in the order that
        they are specified in. An empty list (or null) means no rules. Note that
        you are allowed a maximum of 8 rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingRulesRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _ApplianceTrafficShapingRulesState:
    def __init__(__self__, *,
                 default_rules_enabled: Optional[pulumi.Input[bool]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingRulesRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering ApplianceTrafficShapingRules resources.
        :param pulumi.Input[bool] default_rules_enabled: Whether default traffic shaping rules are enabled (true) or disabled (false). There are 4 default rules, which can be seen on your network's traffic shaping page. Note that default rules count against the rule limit of 8.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingRulesRuleArgs']]] rules: An array of traffic shaping rules. Rules are applied in the order that
               they are specified in. An empty list (or null) means no rules. Note that
               you are allowed a maximum of 8 rules.
        """
        if default_rules_enabled is not None:
            pulumi.set(__self__, "default_rules_enabled", default_rules_enabled)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="defaultRulesEnabled")
    def default_rules_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether default traffic shaping rules are enabled (true) or disabled (false). There are 4 default rules, which can be seen on your network's traffic shaping page. Note that default rules count against the rule limit of 8.
        """
        return pulumi.get(self, "default_rules_enabled")

    @default_rules_enabled.setter
    def default_rules_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default_rules_enabled", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingRulesRuleArgs']]]]:
        """
        An array of traffic shaping rules. Rules are applied in the order that
        they are specified in. An empty list (or null) means no rules. Note that
        you are allowed a maximum of 8 rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplianceTrafficShapingRulesRuleArgs']]]]):
        pulumi.set(self, "rules", value)


class ApplianceTrafficShapingRules(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_rules_enabled: Optional[pulumi.Input[bool]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplianceTrafficShapingRulesRuleArgs', 'ApplianceTrafficShapingRulesRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceTrafficShapingRules:ApplianceTrafficShapingRules example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] default_rules_enabled: Whether default traffic shaping rules are enabled (true) or disabled (false). There are 4 default rules, which can be seen on your network's traffic shaping page. Note that default rules count against the rule limit of 8.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplianceTrafficShapingRulesRuleArgs', 'ApplianceTrafficShapingRulesRuleArgsDict']]]] rules: An array of traffic shaping rules. Rules are applied in the order that
               they are specified in. An empty list (or null) means no rules. Note that
               you are allowed a maximum of 8 rules.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplianceTrafficShapingRulesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceTrafficShapingRules:ApplianceTrafficShapingRules example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param ApplianceTrafficShapingRulesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplianceTrafficShapingRulesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_rules_enabled: Optional[pulumi.Input[bool]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplianceTrafficShapingRulesRuleArgs', 'ApplianceTrafficShapingRulesRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplianceTrafficShapingRulesArgs.__new__(ApplianceTrafficShapingRulesArgs)

            __props__.__dict__["default_rules_enabled"] = default_rules_enabled
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["rules"] = rules
        super(ApplianceTrafficShapingRules, __self__).__init__(
            'meraki:networks/applianceTrafficShapingRules:ApplianceTrafficShapingRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_rules_enabled: Optional[pulumi.Input[bool]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplianceTrafficShapingRulesRuleArgs', 'ApplianceTrafficShapingRulesRuleArgsDict']]]]] = None) -> 'ApplianceTrafficShapingRules':
        """
        Get an existing ApplianceTrafficShapingRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] default_rules_enabled: Whether default traffic shaping rules are enabled (true) or disabled (false). There are 4 default rules, which can be seen on your network's traffic shaping page. Note that default rules count against the rule limit of 8.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplianceTrafficShapingRulesRuleArgs', 'ApplianceTrafficShapingRulesRuleArgsDict']]]] rules: An array of traffic shaping rules. Rules are applied in the order that
               they are specified in. An empty list (or null) means no rules. Note that
               you are allowed a maximum of 8 rules.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplianceTrafficShapingRulesState.__new__(_ApplianceTrafficShapingRulesState)

        __props__.__dict__["default_rules_enabled"] = default_rules_enabled
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["rules"] = rules
        return ApplianceTrafficShapingRules(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultRulesEnabled")
    def default_rules_enabled(self) -> pulumi.Output[bool]:
        """
        Whether default traffic shaping rules are enabled (true) or disabled (false). There are 4 default rules, which can be seen on your network's traffic shaping page. Note that default rules count against the rule limit of 8.
        """
        return pulumi.get(self, "default_rules_enabled")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.ApplianceTrafficShapingRulesRule']]:
        """
        An array of traffic shaping rules. Rules are applied in the order that
        they are specified in. An empty list (or null) means no rules. Note that
        you are allowed a maximum of 8 rules.
        """
        return pulumi.get(self, "rules")

