# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SyslogServersArgs', 'SyslogServers']

@pulumi.input_type
class SyslogServersArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['SyslogServersServerArgs']]]] = None):
        """
        The set of arguments for constructing a SyslogServers resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['SyslogServersServerArgs']]] servers: List of the syslog servers for this network
        """
        pulumi.set(__self__, "network_id", network_id)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyslogServersServerArgs']]]]:
        """
        List of the syslog servers for this network
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyslogServersServerArgs']]]]):
        pulumi.set(self, "servers", value)


@pulumi.input_type
class _SyslogServersState:
    def __init__(__self__, *,
                 network_id: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['SyslogServersServerArgs']]]] = None):
        """
        Input properties used for looking up and filtering SyslogServers resources.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['SyslogServersServerArgs']]] servers: List of the syslog servers for this network
        """
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyslogServersServerArgs']]]]:
        """
        List of the syslog servers for this network
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyslogServersServerArgs']]]]):
        pulumi.set(self, "servers", value)


class SyslogServers(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyslogServersServerArgs', 'SyslogServersServerArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SyslogServers("example",
            network_id="string",
            servers=[{
                "host": "1.2.3.4",
                "port": 443,
                "roles": [
                    "Wireless event log",
                    "URLs",
                ],
            }])
        pulumi.export("merakiNetworksSyslogServersExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/syslogServers:SyslogServers example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyslogServersServerArgs', 'SyslogServersServerArgsDict']]]] servers: List of the syslog servers for this network
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SyslogServersArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SyslogServers("example",
            network_id="string",
            servers=[{
                "host": "1.2.3.4",
                "port": 443,
                "roles": [
                    "Wireless event log",
                    "URLs",
                ],
            }])
        pulumi.export("merakiNetworksSyslogServersExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/syslogServers:SyslogServers example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param SyslogServersArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SyslogServersArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyslogServersServerArgs', 'SyslogServersServerArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SyslogServersArgs.__new__(SyslogServersArgs)

            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["servers"] = servers
        super(SyslogServers, __self__).__init__(
            'meraki:networks/syslogServers:SyslogServers',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SyslogServersServerArgs', 'SyslogServersServerArgsDict']]]]] = None) -> 'SyslogServers':
        """
        Get an existing SyslogServers resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['SyslogServersServerArgs', 'SyslogServersServerArgsDict']]]] servers: List of the syslog servers for this network
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SyslogServersState.__new__(_SyslogServersState)

        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["servers"] = servers
        return SyslogServers(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Output[Sequence['outputs.SyslogServersServer']]:
        """
        List of the syslog servers for this network
        """
        return pulumi.get(self, "servers")

