"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .capability_requirement_status import CapabilityRequirementStatus
from .url import URL, URLTypedDict
from mollie.types import BaseModel, Nullable, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityCapabilityRequirementLinksTypedDict(TypedDict):
    dashboard: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityCapabilityRequirementLinks(BaseModel):
    dashboard: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityCapabilityRequirementTypedDict(TypedDict):
    id: str
    r"""The name of this requirement, referring to the task to be fulfilled by the organization
    to enable or re-enable the capability. The name is unique among other requirements
    of the same capability.
    """
    status: CapabilityRequirementStatus
    r"""The status of the requirement depends on its due date.
    If no due date is given, the status will be `requested`.
    """
    due_date: Nullable[str]
    r"""Due date until the requirement must be fulfilled, if any. The date is shown in ISO-8601 format."""
    links: EntityCapabilityRequirementLinksTypedDict


class EntityCapabilityRequirement(BaseModel):
    id: str
    r"""The name of this requirement, referring to the task to be fulfilled by the organization
    to enable or re-enable the capability. The name is unique among other requirements
    of the same capability.
    """

    status: Annotated[
        CapabilityRequirementStatus, PlainValidator(validate_open_enum(False))
    ]
    r"""The status of the requirement depends on its due date.
    If no due date is given, the status will be `requested`.
    """

    due_date: Annotated[Nullable[str], pydantic.Field(alias="dueDate")]
    r"""Due date until the requirement must be fulfilled, if any. The date is shown in ISO-8601 format."""

    links: Annotated[EntityCapabilityRequirementLinks, pydantic.Field(alias="_links")]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["dueDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
