"""
Workflow exception messages for internationalization
Contains all messages used by workflow exceptions
"""

WORKFLOW_EXCEPTION_MESSAGES = {
    # WorkflowValidationError
    "workflow.validation_error_title": {
        "en": "❌ Workflow Validation Error",
        "zh": "❌ Workflow 验证错误",
        "ja": "❌ Workflow 検証エラー",
        "ar": "❌ خطأ في التحقق من Workflow",
        "ru": "❌ Ошибка валидации Workflow",
    },
    "workflow.field_path": {
        "en": "Field Path",
        "zh": "字段路径",
        "ja": "フィールドパス",
        "ar": "مسار الحقل",
        "ru": "Путь к полю",
    },
    "workflow.expected_value": {
        "en": "Expected",
        "zh": "期望值",
        "ja": "期待値",
        "ar": "القيمة المتوقعة",
        "ru": "Ожидается",
    },
    "workflow.actual_value": {
        "en": "Actual",
        "zh": "实际值",
        "ja": "実際の値",
        "ar": "القيمة الفعلية",
        "ru": "Фактически",
    },
    "workflow.fix_suggestion": {
        "en": "💡 Fix Suggestion",
        "zh": "💡 修复建议",
        "ja": "💡 修正提案",
        "ar": "💡 اقتراح الإصلاح",
        "ru": "💡 Предложение по исправлению",
    },
    # WorkflowFileNotFoundError
    "workflow.file_not_found_title": {
        "en": "❌ Workflow File Not Found",
        "zh": "❌ Workflow 文件未找到",
        "ja": "❌ Workflow ファイルが見つかりません",
        "ar": "❌ ملف Workflow غير موجود",
        "ru": "❌ Файл Workflow не найден",
    },
    "workflow.searched_paths": {
        "en": "Searched Paths",
        "zh": "已搜索的路径",
        "ja": "検索されたパス",
        "ar": "المسارات المبحوثة",
        "ru": "Поиск по путям",
    },
    "workflow.please_check": {
        "en": "💡 Please Check",
        "zh": "💡 请检查",
        "ja": "💡 確認事項",
        "ar": "💡 يرجى التحقق",
        "ru": "💡 Пожалуйста, проверьте",
    },
    "workflow.check_name_correct": {
        "en": "1. workflow name is correct",
        "zh": "1. workflow 名称是否正确",
        "ja": "1. workflow 名が正しいか",
        "ar": "1. اسم workflow صحيح",
        "ru": "1. имя workflow правильное",
    },
    "workflow.check_file_exists": {
        "en": "2. workflow file exists in one of the following directories",
        "zh": "2. workflow 文件是否存在于以下目录之一",
        "ja": "2. workflow ファイルが次のディレクトリのいずれかに存在するか",
        "ar": "2. ملف workflow موجود في أحد الدلائل التالية",
        "ru": "2. файл workflow существует в одной из следующих директорий",
    },
    # WorkflowParseError
    "workflow.parse_error_title": {
        "en": "❌ Workflow YAML Parse Error",
        "zh": "❌ Workflow YAML 解析错误",
        "ja": "❌ Workflow YAML 解析エラー",
        "ar": "❌ خطأ في تحليل Workflow YAML",
        "ru": "❌ Ошибка парсинга Workflow YAML",
    },
    "workflow.file": {
        "en": "File",
        "zh": "文件",
        "ja": "ファイル",
        "ar": "الملف",
        "ru": "Файл",
    },
    "workflow.line_number": {
        "en": "Line",
        "zh": "行号",
        "ja": "行番号",
        "ar": "رقم السطر",
        "ru": "Строка",
    },
    "workflow.error_type": {
        "en": "Error Type",
        "zh": "错误类型",
        "ja": "エラー種別",
        "ar": "نوع الخطأ",
        "ru": "Тип ошибки",
    },
    "workflow.error_details": {
        "en": "Error Details",
        "zh": "错误详情",
        "ja": "エラー詳細",
        "ar": "تفاصيل الخطأ",
        "ru": "Подробности ошибки",
    },
    "workflow.common_issues": {
        "en": "💡 Common Issues",
        "zh": "💡 常见问题",
        "ja": "💡 よくある問題",
        "ar": "💡 المشكلات الشائعة",
        "ru": "💡 Частые проблемы",
    },
    "workflow.check_yaml_syntax": {
        "en": "- Check YAML syntax (indentation, colons, quotes)",
        "zh": "- 检查 YAML 语法是否正确（缩进、冒号、引号）",
        "ja": "- YAML 構文を確認（インデント、コロン、引用符）",
        "ar": "- تحقق من بناء YAML الصحيح (المسافة البادئة، النقطتان، علامات الاقتباس)",
        "ru": "- Проверьте синтаксис YAML (отступы, двоеточия, кавычки)",
    },
    "workflow.no_tab_characters": {
        "en": "- Ensure no Tab characters (YAML only supports spaces)",
        "zh": "- 确保没有使用 Tab 字符（YAML 只支持空格）",
        "ja": "- Tab 文字を使用していないことを確認（YAMLはスペースのみサポート）",
        "ar": "- تأكد من عدم استخدام أحرف Tab (YAML يدعم المسافات فقط)",
        "ru": "- Убедитесь, что нет символов Tab (YAML поддерживает только пробелы)",
    },
    "workflow.check_special_chars": {
        "en": "- Verify special characters are properly escaped",
        "zh": "- 验证特殊字符是否正确转义",
        "ja": "- 特殊文字が適切にエスケープされているか確認",
        "ar": "- تحقق من تجاهل الأحرف الخاصة بشكل صحيح",
        "ru": "- Проверьте правильное экранирование специальных символов",
    },
    # WorkflowStepError
    "workflow.step_error_title": {
        "en": "❌ Workflow Step Execution Error",
        "zh": "❌ Workflow 步骤执行错误",
        "ja": "❌ Workflow ステップ実行エラー",
        "ar": "❌ خطأ في تنفيذ خطوة Workflow",
        "ru": "❌ Ошибка выполнения шага Workflow",
    },
    "workflow.step_id": {
        "en": "Step ID",
        "zh": "步骤 ID",
        "ja": "ステップ ID",
        "ar": "معرف الخطوة",
        "ru": "ID шага",
    },
    "workflow.agent_id": {
        "en": "Agent ID",
        "zh": "代理 ID",
        "ja": "エージェント ID",
        "ar": "معرف الوكيل",
        "ru": "ID агента",
    },
    "workflow.error": {
        "en": "Error",
        "zh": "错误",
        "ja": "エラー",
        "ar": "خطأ",
        "ru": "Ошибка",
    },
    "workflow.cause_type": {
        "en": "Cause Type",
        "zh": "原因类型",
        "ja": "原因タイプ",
        "ar": "نوع السبب",
        "ru": "Тип причины",
    },
    "workflow.cause_details": {
        "en": "Cause Details",
        "zh": "原因详情",
        "ja": "原因詳細",
        "ar": "تفاصيل السبب",
        "ru": "Подробности причины",
    },
    # WorkflowDependencyError
    "workflow.dependency_error_title": {
        "en": "❌ Workflow Dependency Error",
        "zh": "❌ Workflow 依赖错误",
        "ja": "❌ Workflow 依存関係エラー",
        "ar": "❌ خطأ في تبعية Workflow",
        "ru": "❌ Ошибка зависимостей Workflow",
    },
    "workflow.involved_step": {
        "en": "Involved Step",
        "zh": "涉及步骤",
        "ja": "関連ステップ",
        "ar": "الخطوة المعنية",
        "ru": "Затронутый шаг",
    },
    "workflow.dependency_chain": {
        "en": "Dependency Chain",
        "zh": "依赖链",
        "ja": "依存チェーン",
        "ar": "سلسلة التبعية",
        "ru": "Цепочка зависимостей",
    },
    "workflow.check_needs_field": {
        "en": "- Check if steps referenced in 'needs' field exist",
        "zh": "- 检查 needs 字段引用的步骤是否存在",
        "ja": "- 'needs' フィールドで参照されているステップが存在するか確認",
        "ar": "- تحقق من وجود الخطوات المشار إليها في حقل 'needs'",
        "ru": "- Проверьте существование шагов, на которые ссылается поле 'needs'",
    },
    "workflow.no_circular_dependency": {
        "en": "- Ensure no circular dependencies (A depends on B, B depends on A)",
        "zh": "- 确保没有循环依赖（A依赖B，B依赖A）",
        "ja": "- 循環依存がないことを確認（AがBに依存、BがAに依存）",
        "ar": "- تأكد من عدم وجود تبعيات دائرية (A يعتمد على B، B يعتمد على A)",
        "ru": "- Убедитесь в отсутствии циклических зависимостей (A зависит от B, B зависит от A)",
    },
    "workflow.check_step_id_spelling": {
        "en": "- Verify step ID spelling in dependencies",
        "zh": "- 验证依赖的步骤 ID 拼写是否正确",
        "ja": "- 依存関係のステップ ID のスペルを確認",
        "ar": "- تحقق من تهجئة معرف الخطوة في التبعيات",
        "ru": "- Проверьте правильность написания ID шага в зависимостях",
    },
    # WorkflowAgentNotFoundError
    "workflow.agent_not_found_title": {
        "en": "❌ Workflow Agent Not Found",
        "zh": "❌ Workflow 代理不存在",
        "ja": "❌ Workflow エージェントが見つかりません",
        "ar": "❌ وكيل Workflow غير موجود",
        "ru": "❌ Агент Workflow не найден",
    },
    "workflow.referenced_agent": {
        "en": "Referenced Agent",
        "zh": "引用的代理",
        "ja": "参照されたエージェント",
        "ar": "الوكيل المشار إليه",
        "ru": "Ссылаемый агент",
    },
    "workflow.in_step": {
        "en": "In Step",
        "zh": "所在步骤",
        "ja": "所在ステップ",
        "ar": "في الخطوة",
        "ru": "В шаге",
    },
    "workflow.available_agents": {
        "en": "Available Agents",
        "zh": "可用的代理",
        "ja": "利用可能なエージェント",
        "ar": "الوكلاء المتاحون",
        "ru": "Доступные агенты",
    },
    "workflow.no_agents": {
        "en": "(none)",
        "zh": "(无)",
        "ja": "(なし)",
        "ar": "(لا يوجد)",
        "ru": "(нет)",
    },
    "workflow.check_agent_spelling": {
        "en": "- Check if agent field spelling is correct in steps",
        "zh": "- 检查步骤中的 agent 字段拼写是否正确",
        "ja": "- ステップのエージェントフィールドのスペルが正しいか確認",
        "ar": "- تحقق من صحة تهجئة حقل الوكيل في الخطوات",
        "ru": "- Проверьте правильность написания поля agent в шагах",
    },
    "workflow.ensure_agent_defined": {
        "en": "- Ensure the agent is defined in spec.agents",
        "zh": "- 确保在 spec.agents 中定义了该代理",
        "ja": "- spec.agents でエージェントが定義されているか確認",
        "ar": "- تأكد من تعريف الوكيل في spec.agents",
        "ru": "- Убедитесь, что агент определен в spec.agents",
    },
    # WorkflowTemplateError
    "workflow.template_error_title": {
        "en": "❌ Workflow Template Rendering Error",
        "zh": "❌ Workflow 模板渲染错误",
        "ja": "❌ Workflow テンプレートレンダリングエラー",
        "ar": "❌ خطأ في عرض قالب Workflow",
        "ru": "❌ Ошибка рендеринга шаблона Workflow",
    },
    "workflow.expression": {
        "en": "Expression",
        "zh": "表达式",
        "ja": "式",
        "ar": "التعبير",
        "ru": "Выражение",
    },
    "workflow.template_snippet": {
        "en": "Template Snippet",
        "zh": "模板片段",
        "ja": "テンプレートスニペット",
        "ar": "مقتطف القالب",
        "ru": "Фрагмент шаблона",
    },
    "workflow.available_context_keys": {
        "en": "Available Context Keys",
        "zh": "当前上下文可用的键",
        "ja": "利用可能なコンテキストキー",
        "ar": "مفاتيح السياق المتاحة",
        "ru": "Доступные ключи контекста",
    },
    "workflow.check_expression_syntax": {
        "en": "- Check expression syntax: ${vars.key}, ${steps.stepId.outputs.key}",
        "zh": "- 检查表达式语法: ${vars.key}, ${steps.stepId.outputs.key}",
        "ja": "- 式の構文を確認: ${vars.key}, ${steps.stepId.outputs.key}",
        "ar": "- تحقق من بناء التعبير: ${vars.key}, ${steps.stepId.outputs.key}",
        "ru": "- Проверьте синтаксис выражения: ${vars.key}, ${steps.stepId.outputs.key}",
    },
    "workflow.ensure_variable_defined": {
        "en": "- Ensure referenced variables or step outputs are defined",
        "zh": "- 确保引用的变量或步骤输出已定义",
        "ja": "- 参照される変数またはステップ出力が定義されているか確認",
        "ar": "- تأكد من تعريف المتغيرات أو مخرجات الخطوات المشار إليها",
        "ru": "- Убедитесь, что ссылаемые переменные или выходы шагов определены",
    },
    "workflow.check_execution_order": {
        "en": "- Verify step execution order (can only reference outputs from executed steps)",
        "zh": "- 验证步骤执行顺序（只能引用已执行步骤的输出）",
        "ja": "- ステップ実行順序を確認（実行済みステップの出力のみ参照可能）",
        "ar": "- تحقق من ترتيب تنفيذ الخطوات (يمكن الإشارة فقط إلى مخرجات الخطوات المنفذة)",
        "ru": "- Проверьте порядок выполнения шагов (можно ссылаться только на выходы выполненных шагов)",
    },
    # WorkflowAgentDefinitionError
    "workflow.agent_definition_error_title": {
        "en": "❌ Workflow Agent Definition Error",
        "zh": "❌ Workflow 代理定义错误",
        "ja": "❌ Workflow エージェント定義エラー",
        "ar": "❌ خطأ في تعريف وكيل Workflow",
        "ru": "❌ Ошибка определения агента Workflow",
    },
    "workflow.agent_path": {
        "en": "Agent Path",
        "zh": "代理路径",
        "ja": "エージェントパス",
        "ar": "مسار الوكيل",
        "ru": "Путь агента",
    },
    "workflow.check_agent_file_exists": {
        "en": "- Check if agent file exists in .autocoderagents/ directory",
        "zh": "- 检查代理文件是否存在于 .autocoderagents/ 目录",
        "ja": "- エージェントファイルが .autocoderagents/ ディレクトリに存在するか確認",
        "ar": "- تحقق من وجود ملف الوكيل في دليل .autocoderagents/",
        "ru": "- Проверьте существование файла агента в директории .autocoderagents/",
    },
    "workflow.ensure_agent_content_valid": {
        "en": "- Ensure agent file content meets format requirements",
        "zh": "- 确保代理文件内容符合格式要求",
        "ja": "- エージェントファイルの内容が形式要件を満たしているか確認",
        "ar": "- تأكد من أن محتوى ملف الوكيل يلبي متطلبات التنسيق",
        "ru": "- Убедитесь, что содержимое файла агента соответствует требованиям формата",
    },
    "workflow.check_path_spelling": {
        "en": "- Verify agent file path spelling is correct",
        "zh": "- 验证代理文件路径拼写是否正确",
        "ja": "- エージェントファイルパスのスペルが正しいか確認",
        "ar": "- تحقق من صحة تهجئة مسار ملف الوكيل",
        "ru": "- Проверьте правильность написания пути к файлу агента",
    },
    # WorkflowConversationError
    "workflow.conversation_error_title": {
        "en": "❌ Workflow Conversation Management Error",
        "zh": "❌ Workflow 会话管理错误",
        "ja": "❌ Workflow 会話管理エラー",
        "ar": "❌ خطأ في إدارة محادثة Workflow",
        "ru": "❌ Ошибка управления беседой Workflow",
    },
    "workflow.conversation_action": {
        "en": "Conversation Action",
        "zh": "会话动作",
        "ja": "会話アクション",
        "ar": "إجراء المحادثة",
        "ru": "Действие беседы",
    },
    "workflow.conversation_id": {
        "en": "Conversation ID",
        "zh": "会话 ID",
        "ja": "会話 ID",
        "ar": "معرف المحادثة",
        "ru": "ID беседы",
    },
    # WorkflowConditionError
    "workflow.condition_error_title": {
        "en": "❌ Workflow Condition Evaluation Error",
        "zh": "❌ Workflow 条件评估错误",
        "ja": "❌ Workflow 条件評価エラー",
        "ar": "❌ خطأ في تقييم شرط Workflow",
        "ru": "❌ Ошибка оценки условия Workflow",
    },
    "workflow.condition_type": {
        "en": "Condition Type",
        "zh": "条件类型",
        "ja": "条件タイプ",
        "ar": "نوع الشرط",
        "ru": "Тип условия",
    },
    "workflow.condition_details": {
        "en": "Condition Details",
        "zh": "条件详情",
        "ja": "条件詳細",
        "ar": "تفاصيل الشرط",
        "ru": "Подробности условия",
    },
    "workflow.check_when_syntax": {
        "en": "- Check 'when' condition syntax is correct",
        "zh": "- 检查 when 条件的语法是否正确",
        "ja": "- 'when' 条件の構文が正しいか確認",
        "ar": "- تحقق من صحة بناء شرط 'when'",
        "ru": "- Проверьте правильность синтаксиса условия 'when'",
    },
    "workflow.verify_regex_pattern": {
        "en": "- Verify regex pattern is valid",
        "zh": "- 验证正则表达式模式是否有效",
        "ja": "- 正規表現パターンが有効か確認",
        "ar": "- تحقق من صحة نمط التعبير المنتظم",
        "ru": "- Проверьте действительность шаблона регулярного выражения",
    },
    "workflow.ensure_jsonpath_correct": {
        "en": "- Ensure JSONPath expression format is correct",
        "zh": "- 确保 JSONPath 表达式格式正确",
        "ja": "- JSONPath 式の形式が正しいか確認",
        "ar": "- تأكد من صحة تنسيق تعبير JSONPath",
        "ru": "- Убедитесь, что формат выражения JSONPath правильный",
    },
    # WorkflowOutputExtractionError
    "workflow.output_extraction_error_title": {
        "en": "❌ Workflow Output Extraction Error",
        "zh": "❌ Workflow 输出提取错误",
        "ja": "❌ Workflow 出力抽出エラー",
        "ar": "❌ خطأ في استخراج مخرجات Workflow",
        "ru": "❌ Ошибка извлечения выхода Workflow",
    },
    "workflow.output_key": {
        "en": "Output Key",
        "zh": "输出键",
        "ja": "出力キー",
        "ar": "مفتاح الإخراج",
        "ru": "Ключ вывода",
    },
    "workflow.extraction_method": {
        "en": "Extraction Method",
        "zh": "提取方法",
        "ja": "抽出方法",
        "ar": "طريقة الاستخراج",
        "ru": "Метод извлечения",
    },
    "workflow.check_jsonpath_expression": {
        "en": "- Check if JSONPath expression is correct",
        "zh": "- 检查 JSONPath 表达式是否正确",
        "ja": "- JSONPath 式が正しいか確認",
        "ar": "- تحقق من صحة تعبير JSONPath",
        "ru": "- Проверьте правильность выражения JSONPath",
    },
    "workflow.verify_regex_and_group": {
        "en": "- Verify regex pattern and grouping",
        "zh": "- 验证正则表达式模式和分组",
        "ja": "- 正規表現パターンとグループを確認",
        "ar": "- تحقق من نمط التعبير المنتظم والتجميع",
        "ru": "- Проверьте шаблон регулярного выражения и группировку",
    },
    "workflow.ensure_format_matches": {
        "en": "- Ensure attempt_result format matches extraction method",
        "zh": "- 确保 attempt_result 格式与提取方法匹配",
        "ja": "- attempt_result の形式が抽出方法と一致するか確認",
        "ar": "- تأكد من تطابق تنسيق attempt_result مع طريقة الاستخراج",
        "ru": "- Убедитесь, что формат attempt_result соответствует методу извлечения",
    },
    # WorkflowAgentResolutionError
    "workflow.agent_resolution_error_title": {
        "en": "❌ Workflow Agent Resolution Error",
        "zh": "❌ Workflow 代理解析错误",
        "ja": "❌ Workflow エージェント解決エラー",
        "ar": "❌ خطأ في حل وكيل Workflow",
        "ru": "❌ Ошибка разрешения агента Workflow",
    },
    "workflow.agent_resolution_failed": {
        "en": "Failed to resolve agent definition file",
        "zh": "无法解析代理定义文件",
        "ja": "エージェント定義ファイルの解決に失敗しました",
        "ar": "فشل في حل ملف تعريف الوكيل",
        "ru": "Не удалось разрешить файл определения агента",
    },
    "workflow.agent_not_found_at_path": {
        "en": "Agent file not found",
        "zh": "未找到代理文件",
        "ja": "エージェントファイルが見つかりません",
        "ar": "ملف الوكيل غير موجود",
        "ru": "Файл агента не найден",
    },
    "workflow.searched_agent_paths": {
        "en": "Searched Paths",
        "zh": "已搜索的路径",
        "ja": "検索されたパス",
        "ar": "المسارات المبحوثة",
        "ru": "Поиск по путям",
    },
    "workflow.check_agent_path_exists": {
        "en": "- Ensure agent definition file exists in one of the priority directories",
        "zh": "- 确保代理定义文件存在于优先级目录之一",
        "ja": "- エージェント定義ファイルが優先ディレクトリのいずれかに存在することを確認",
        "ar": "- تأكد من وجود ملف تعريف الوكيل في أحد الدلائل ذات الأولوية",
        "ru": "- Убедитесь, что файл определения агента существует в одной из приоритетных директорий",
    },
    "workflow.verify_agent_path_correct": {
        "en": "- Verify agent path in YAML configuration is correct",
        "zh": "- 验证 YAML 配置中的代理路径是否正确",
        "ja": "- YAML 設定のエージェントパスが正しいか確認",
        "ar": "- تحقق من صحة مسار الوكيل في تكوين YAML",
        "ru": "- Проверьте правильность пути агента в конфигурации YAML",
    },
    # WorkflowModelValidationError
    "workflow.model_validation_error_title": {
        "en": "❌ Workflow Model Validation Error",
        "zh": "❌ Workflow 模型验证错误",
        "ja": "❌ Workflow モデル検証エラー",
        "ar": "❌ خطأ في التحقق من نموذج Workflow",
        "ru": "❌ Ошибка валидации модели Workflow",
    },
    "workflow.model_not_found": {
        "en": "Model not found",
        "zh": "未找到模型",
        "ja": "モデルが見つかりません",
        "ar": "النموذج غير موجود",
        "ru": "Модель не найдена",
    },
    "workflow.model_key_missing": {
        "en": "API key is not configured for model",
        "zh": "模型未配置 API 密钥",
        "ja": "モデルの API キーが設定されていません",
        "ar": "مفتاح API غير مكون للنموذج",
        "ru": "API ключ не настроен для модели",
    },
    "workflow.model_validation_failed": {
        "en": "Model validation failed",
        "zh": "模型验证失败",
        "ja": "モデル検証に失敗しました",
        "ar": "فشل التحقق من النموذج",
        "ru": "Проверка модели не удалась",
    },
    "workflow.model_name": {
        "en": "Model Name",
        "zh": "模型名称",
        "ja": "モデル名",
        "ar": "اسم النموذج",
        "ru": "Имя модели",
    },
    "workflow.check_model_registered": {
        "en": "- Ensure model is registered in LLM configuration",
        "zh": "- 确保模型已在 LLM 配置中注册",
        "ja": "- モデルが LLM 設定に登録されているか確認",
        "ar": "- تأكد من تسجيل النموذج في تكوين LLM",
        "ru": "- Убедитесь, что модель зарегистрирована в конфигурации LLM",
    },
    "workflow.check_api_key_configured": {
        "en": "- Verify API key is configured for the model",
        "zh": "- 验证模型的 API 密钥是否已配置",
        "ja": "- モデルの API キーが設定されているか確認",
        "ar": "- تحقق من تكوين مفتاح API للنموذج",
        "ru": "- Проверьте настройку API ключа для модели",
    },
    "workflow.check_model_name_spelling": {
        "en": "- Check model name spelling in configuration",
        "zh": "- 检查配置中的模型名称拼写",
        "ja": "- 設定のモデル名のスペルを確認",
        "ar": "- تحقق من تهجئة اسم النموذج في التكوين",
        "ru": "- Проверьте правильность написания имени модели в конфигурации",
    },
}
