# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from dataclasses import dataclass
import typing_extensions
import urllib3
from pydantic import RootModel
from carbon.request_before_hook import request_before_hook
import json
from urllib3._collections import HTTPHeaderDict

from carbon.api_response import AsyncGeneratorResponse
from carbon import api_client, exceptions
from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from carbon import schemas  # noqa: F401

from carbon.model.text_embedding_generators import TextEmbeddingGenerators as TextEmbeddingGeneratorsSchema
from carbon.model.http_validation_error import HTTPValidationError as HTTPValidationErrorSchema
from carbon.model.user_file import UserFile as UserFileSchema
from carbon.model.body_create_upload_file_uploadfile_post import BodyCreateUploadFileUploadfilePost as BodyCreateUploadFileUploadfilePostSchema

from carbon.type.http_validation_error import HTTPValidationError
from carbon.type.user_file import UserFile
from carbon.type.body_create_upload_file_uploadfile_post import BodyCreateUploadFileUploadfilePost
from carbon.type.text_embedding_generators import TextEmbeddingGenerators

from ...api_client import Dictionary
from carbon.pydantic.user_file import UserFile as UserFilePydantic
from carbon.pydantic.http_validation_error import HTTPValidationError as HTTPValidationErrorPydantic
from carbon.pydantic.body_create_upload_file_uploadfile_post import BodyCreateUploadFileUploadfilePost as BodyCreateUploadFileUploadfilePostPydantic
from carbon.pydantic.text_embedding_generators import TextEmbeddingGenerators as TextEmbeddingGeneratorsPydantic

# Query params


class ChunkSizeSchema(
    schemas.IntBase,
    schemas.NoneBase,
    schemas.Schema,
    schemas.NoneDecimalMixin
):


    def __new__(
        cls,
        *args: typing.Union[None, decimal.Decimal, int, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'ChunkSizeSchema':
        return super().__new__(
            cls,
            *args,
            _configuration=_configuration,
        )


class ChunkOverlapSchema(
    schemas.IntBase,
    schemas.NoneBase,
    schemas.Schema,
    schemas.NoneDecimalMixin
):


    def __new__(
        cls,
        *args: typing.Union[None, decimal.Decimal, int, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'ChunkOverlapSchema':
        return super().__new__(
            cls,
            *args,
            _configuration=_configuration,
        )
SkipEmbeddingGenerationSchema = schemas.BoolSchema
SetPageAsBoundarySchema = schemas.BoolSchema
EmbeddingModelSchema = TextEmbeddingGeneratorsSchema
UseOcrSchema = schemas.BoolSchema
GenerateSparseVectorsSchema = schemas.BoolSchema
PrependFilenameToChunksSchema = schemas.BoolSchema


class MaxItemsPerChunkSchema(
    schemas.IntBase,
    schemas.NoneBase,
    schemas.Schema,
    schemas.NoneDecimalMixin
):


    def __new__(
        cls,
        *args: typing.Union[None, decimal.Decimal, int, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'MaxItemsPerChunkSchema':
        return super().__new__(
            cls,
            *args,
            _configuration=_configuration,
        )
RequestRequiredQueryParams = typing_extensions.TypedDict(
    'RequestRequiredQueryParams',
    {
    }
)
RequestOptionalQueryParams = typing_extensions.TypedDict(
    'RequestOptionalQueryParams',
    {
        'chunk_size': typing.Union[ChunkSizeSchema, None, decimal.Decimal, int, ],
        'chunk_overlap': typing.Union[ChunkOverlapSchema, None, decimal.Decimal, int, ],
        'skip_embedding_generation': typing.Union[SkipEmbeddingGenerationSchema, bool, ],
        'set_page_as_boundary': typing.Union[SetPageAsBoundarySchema, bool, ],
        'embedding_model': typing.Union[EmbeddingModelSchema, ],
        'use_ocr': typing.Union[UseOcrSchema, bool, ],
        'generate_sparse_vectors': typing.Union[GenerateSparseVectorsSchema, bool, ],
        'prepend_filename_to_chunks': typing.Union[PrependFilenameToChunksSchema, bool, ],
        'max_items_per_chunk': typing.Union[MaxItemsPerChunkSchema, None, decimal.Decimal, int, ],
    },
    total=False
)


class RequestQueryParams(RequestRequiredQueryParams, RequestOptionalQueryParams):
    pass


request_query_chunk_size = api_client.QueryParameter(
    name="chunk_size",
    style=api_client.ParameterStyle.FORM,
    schema=ChunkSizeSchema,
    explode=True,
)
request_query_chunk_overlap = api_client.QueryParameter(
    name="chunk_overlap",
    style=api_client.ParameterStyle.FORM,
    schema=ChunkOverlapSchema,
    explode=True,
)
request_query_skip_embedding_generation = api_client.QueryParameter(
    name="skip_embedding_generation",
    style=api_client.ParameterStyle.FORM,
    schema=SkipEmbeddingGenerationSchema,
    explode=True,
)
request_query_set_page_as_boundary = api_client.QueryParameter(
    name="set_page_as_boundary",
    style=api_client.ParameterStyle.FORM,
    schema=SetPageAsBoundarySchema,
    explode=True,
)
request_query_embedding_model = api_client.QueryParameter(
    name="embedding_model",
    style=api_client.ParameterStyle.FORM,
    schema=TextEmbeddingGeneratorsSchema,
    explode=True,
)
request_query_use_ocr = api_client.QueryParameter(
    name="use_ocr",
    style=api_client.ParameterStyle.FORM,
    schema=UseOcrSchema,
    explode=True,
)
request_query_generate_sparse_vectors = api_client.QueryParameter(
    name="generate_sparse_vectors",
    style=api_client.ParameterStyle.FORM,
    schema=GenerateSparseVectorsSchema,
    explode=True,
)
request_query_prepend_filename_to_chunks = api_client.QueryParameter(
    name="prepend_filename_to_chunks",
    style=api_client.ParameterStyle.FORM,
    schema=PrependFilenameToChunksSchema,
    explode=True,
)
request_query_max_items_per_chunk = api_client.QueryParameter(
    name="max_items_per_chunk",
    style=api_client.ParameterStyle.FORM,
    schema=MaxItemsPerChunkSchema,
    explode=True,
)
# body param
SchemaForRequestBodyMultipartFormData = BodyCreateUploadFileUploadfilePostSchema


request_body_body_create_upload_file_uploadfile_post = api_client.RequestBody(
    content={
        'multipart/form-data': api_client.MediaType(
            schema=SchemaForRequestBodyMultipartFormData),
    },
    required=True,
)
SchemaFor200ResponseBodyApplicationJson = UserFileSchema


@dataclass
class ApiResponseFor200(api_client.ApiResponse):
    body: UserFile


@dataclass
class ApiResponseFor200Async(api_client.AsyncApiResponse):
    body: UserFile


_response_for_200 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor200,
    response_cls_async=ApiResponseFor200Async,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor200ResponseBodyApplicationJson),
    },
)
SchemaFor422ResponseBodyApplicationJson = HTTPValidationErrorSchema


@dataclass
class ApiResponseFor422(api_client.ApiResponse):
    body: HTTPValidationError


@dataclass
class ApiResponseFor422Async(api_client.AsyncApiResponse):
    body: HTTPValidationError


_response_for_422 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor422,
    response_cls_async=ApiResponseFor422Async,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor422ResponseBodyApplicationJson),
    },
)
_all_accept_content_types = (
    'application/json',
)


class BaseApi(api_client.Api):

    def _upload_mapped_args(
        self,
        file: typing.IO,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[bool] = None,
        set_page_as_boundary: typing.Optional[bool] = None,
        embedding_model: typing.Optional[TextEmbeddingGenerators] = None,
        use_ocr: typing.Optional[bool] = None,
        generate_sparse_vectors: typing.Optional[bool] = None,
        prepend_filename_to_chunks: typing.Optional[bool] = None,
        max_items_per_chunk: typing.Optional[typing.Optional[int]] = None,
    ) -> api_client.MappedArgs:
        args: api_client.MappedArgs = api_client.MappedArgs()
        _query_params = {}
        _body = {}
        if file is not None:
            _body["file"] = file
        args.body = _body
        if chunk_size is not None:
            _query_params["chunk_size"] = chunk_size
        if chunk_overlap is not None:
            _query_params["chunk_overlap"] = chunk_overlap
        if skip_embedding_generation is not None:
            _query_params["skip_embedding_generation"] = skip_embedding_generation
        if set_page_as_boundary is not None:
            _query_params["set_page_as_boundary"] = set_page_as_boundary
        if embedding_model is not None:
            _query_params["embedding_model"] = embedding_model
        if use_ocr is not None:
            _query_params["use_ocr"] = use_ocr
        if generate_sparse_vectors is not None:
            _query_params["generate_sparse_vectors"] = generate_sparse_vectors
        if prepend_filename_to_chunks is not None:
            _query_params["prepend_filename_to_chunks"] = prepend_filename_to_chunks
        if max_items_per_chunk is not None:
            _query_params["max_items_per_chunk"] = max_items_per_chunk
        args.query = _query_params
        return args

    async def _aupload_oapg(
        self,
        body: typing.Any = None,
            query_params: typing.Optional[dict] = {},
        skip_deserialization: bool = True,
        timeout: typing.Optional[typing.Union[float, typing.Tuple]] = None,
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        content_type: str = 'multipart/form-data',
        stream: bool = False,
        **kwargs,
    ) -> typing.Union[
        ApiResponseFor200Async,
        api_client.ApiResponseWithoutDeserializationAsync,
        AsyncGeneratorResponse,
    ]:
        """
        Create Upload File
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        self._verify_typed_dict_inputs_oapg(RequestQueryParams, query_params)
        used_path = path.value
    
        prefix_separator_iterator = None
        for parameter in (
            request_query_chunk_size,
            request_query_chunk_overlap,
            request_query_skip_embedding_generation,
            request_query_set_page_as_boundary,
            request_query_embedding_model,
            request_query_use_ocr,
            request_query_generate_sparse_vectors,
            request_query_prepend_filename_to_chunks,
            request_query_max_items_per_chunk,
        ):
            parameter_data = query_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            if prefix_separator_iterator is None:
                prefix_separator_iterator = parameter.get_prefix_separator_iterator()
            serialized_data = parameter.serialize(parameter_data, prefix_separator_iterator)
            for serialized_value in serialized_data.values():
                used_path += serialized_value
    
        _headers = HTTPHeaderDict()
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add('Accept', accept_content_type)
        method = 'post'.upper()
        _headers.add('Content-Type', content_type)
    
        if body is schemas.unset:
            raise exceptions.ApiValueError(
                'The required body parameter has an invalid value of: unset. Set a valid value instead')
        _fields = None
        _body = None
        request_before_hook(
            resource_path=used_path,
            method=method,
            configuration=self.api_client.configuration,
            path_template='/uploadfile',
            body=body,
            auth_settings=_auth,
            headers=_headers,
        )
        serialized_data = request_body_body_create_upload_file_uploadfile_post.serialize(body, content_type)
        if 'fields' in serialized_data:
            _fields = serialized_data['fields']
        elif 'body' in serialized_data:
            _body = serialized_data['body']
    
        response = await self.api_client.async_call_api(
            resource_path=used_path,
            method=method,
            headers=_headers,
            fields=_fields,
            serialized_body=_body,
            body=body,
            auth_settings=_auth,
            prefix_separator_iterator=prefix_separator_iterator,
            timeout=timeout,
            **kwargs
        )
    
        if stream:
            if not 200 <= response.http_response.status <= 299:
                body = (await response.http_response.content.read()).decode("utf-8")
                raise exceptions.ApiStreamingException(
                    status=response.http_response.status,
                    reason=response.http_response.reason,
                    body=body,
                )
    
            async def stream_iterator():
                """
                iterates over response.http_response.content and closes connection once iteration has finished
                """
                async for line in response.http_response.content:
                    if line == b'\r\n':
                        continue
                    yield line
                response.http_response.close()
                await response.session.close()
            return AsyncGeneratorResponse(
                content=stream_iterator(),
                headers=response.http_response.headers,
                status=response.http_response.status,
                response=response.http_response
            )
    
        response_for_status = _status_code_to_response.get(str(response.http_response.status))
        if response_for_status:
            api_response = await response_for_status.deserialize_async(
                                                    response,
                                                    self.api_client.configuration,
                                                    skip_deserialization=skip_deserialization
                                                )
        else:
            # If response data is JSON then deserialize for SDK consumer convenience
            is_json = api_client.JSONDetector._content_type_is_json(response.http_response.headers.get('Content-Type', ''))
            api_response = api_client.ApiResponseWithoutDeserializationAsync(
                body=await response.http_response.json() if is_json else await response.http_response.text(),
                response=response.http_response,
                round_trip_time=response.round_trip_time,
                status=response.http_response.status,
                headers=response.http_response.headers,
            )
    
        if not 200 <= api_response.status <= 299:
            raise exceptions.ApiException(api_response=api_response)
    
        # cleanup session / response
        response.http_response.close()
        await response.session.close()
    
        return api_response


    def _upload_oapg(
        self,
        body: typing.Any = None,
            query_params: typing.Optional[dict] = {},
        skip_deserialization: bool = True,
        timeout: typing.Optional[typing.Union[float, typing.Tuple]] = None,
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        content_type: str = 'multipart/form-data',
        stream: bool = False,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]:
        """
        Create Upload File
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        self._verify_typed_dict_inputs_oapg(RequestQueryParams, query_params)
        used_path = path.value
    
        prefix_separator_iterator = None
        for parameter in (
            request_query_chunk_size,
            request_query_chunk_overlap,
            request_query_skip_embedding_generation,
            request_query_set_page_as_boundary,
            request_query_embedding_model,
            request_query_use_ocr,
            request_query_generate_sparse_vectors,
            request_query_prepend_filename_to_chunks,
            request_query_max_items_per_chunk,
        ):
            parameter_data = query_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            if prefix_separator_iterator is None:
                prefix_separator_iterator = parameter.get_prefix_separator_iterator()
            serialized_data = parameter.serialize(parameter_data, prefix_separator_iterator)
            for serialized_value in serialized_data.values():
                used_path += serialized_value
    
        _headers = HTTPHeaderDict()
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add('Accept', accept_content_type)
        method = 'post'.upper()
        _headers.add('Content-Type', content_type)
    
        if body is schemas.unset:
            raise exceptions.ApiValueError(
                'The required body parameter has an invalid value of: unset. Set a valid value instead')
        _fields = None
        _body = None
        request_before_hook(
            resource_path=used_path,
            method=method,
            configuration=self.api_client.configuration,
            path_template='/uploadfile',
            body=body,
            auth_settings=_auth,
            headers=_headers,
        )
        serialized_data = request_body_body_create_upload_file_uploadfile_post.serialize(body, content_type)
        if 'fields' in serialized_data:
            _fields = serialized_data['fields']
        elif 'body' in serialized_data:
            _body = serialized_data['body']
    
        response = self.api_client.call_api(
            resource_path=used_path,
            method=method,
            headers=_headers,
            fields=_fields,
            serialized_body=_body,
            body=body,
            auth_settings=_auth,
            prefix_separator_iterator=prefix_separator_iterator,
            timeout=timeout,
        )
    
        response_for_status = _status_code_to_response.get(str(response.http_response.status))
        if response_for_status:
            api_response = response_for_status.deserialize(
                                                    response,
                                                    self.api_client.configuration,
                                                    skip_deserialization=skip_deserialization
                                                )
        else:
            # If response data is JSON then deserialize for SDK consumer convenience
            is_json = api_client.JSONDetector._content_type_is_json(response.http_response.headers.get('Content-Type', ''))
            api_response = api_client.ApiResponseWithoutDeserialization(
                body=json.loads(response.http_response.data) if is_json else response.http_response.data,
                response=response.http_response,
                round_trip_time=response.round_trip_time,
                status=response.http_response.status,
                headers=response.http_response.headers,
            )
    
        if not 200 <= api_response.status <= 299:
            raise exceptions.ApiException(api_response=api_response)
    
        return api_response


class UploadRaw(BaseApi):
    # this class is used by api classes that refer to endpoints with operationId fn names

    async def aupload(
        self,
        file: typing.IO,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[bool] = None,
        set_page_as_boundary: typing.Optional[bool] = None,
        embedding_model: typing.Optional[TextEmbeddingGenerators] = None,
        use_ocr: typing.Optional[bool] = None,
        generate_sparse_vectors: typing.Optional[bool] = None,
        prepend_filename_to_chunks: typing.Optional[bool] = None,
        max_items_per_chunk: typing.Optional[typing.Optional[int]] = None,
        **kwargs,
    ) -> typing.Union[
        ApiResponseFor200Async,
        api_client.ApiResponseWithoutDeserializationAsync,
        AsyncGeneratorResponse,
    ]:
        args = self._upload_mapped_args(
            file=file,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            set_page_as_boundary=set_page_as_boundary,
            embedding_model=embedding_model,
            use_ocr=use_ocr,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            max_items_per_chunk=max_items_per_chunk,
        )
        return await self._aupload_oapg(
            body=args.body,
            query_params=args.query,
            **kwargs,
        )
    
    def upload(
        self,
        file: typing.IO,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[bool] = None,
        set_page_as_boundary: typing.Optional[bool] = None,
        embedding_model: typing.Optional[TextEmbeddingGenerators] = None,
        use_ocr: typing.Optional[bool] = None,
        generate_sparse_vectors: typing.Optional[bool] = None,
        prepend_filename_to_chunks: typing.Optional[bool] = None,
        max_items_per_chunk: typing.Optional[typing.Optional[int]] = None,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]:
        args = self._upload_mapped_args(
            file=file,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            set_page_as_boundary=set_page_as_boundary,
            embedding_model=embedding_model,
            use_ocr=use_ocr,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            max_items_per_chunk=max_items_per_chunk,
        )
        return self._upload_oapg(
            body=args.body,
            query_params=args.query,
        )

class Upload(BaseApi):

    async def aupload(
        self,
        file: typing.IO,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[bool] = None,
        set_page_as_boundary: typing.Optional[bool] = None,
        embedding_model: typing.Optional[TextEmbeddingGenerators] = None,
        use_ocr: typing.Optional[bool] = None,
        generate_sparse_vectors: typing.Optional[bool] = None,
        prepend_filename_to_chunks: typing.Optional[bool] = None,
        max_items_per_chunk: typing.Optional[typing.Optional[int]] = None,
        validate: bool = False,
        **kwargs,
    ) -> UserFilePydantic:
        raw_response = await self.raw.aupload(
            file=file,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            set_page_as_boundary=set_page_as_boundary,
            embedding_model=embedding_model,
            use_ocr=use_ocr,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            max_items_per_chunk=max_items_per_chunk,
            **kwargs,
        )
        if validate:
            return UserFilePydantic(**raw_response.body)
        return api_client.construct_model_instance(UserFilePydantic, raw_response.body)
    
    
    def upload(
        self,
        file: typing.IO,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[bool] = None,
        set_page_as_boundary: typing.Optional[bool] = None,
        embedding_model: typing.Optional[TextEmbeddingGenerators] = None,
        use_ocr: typing.Optional[bool] = None,
        generate_sparse_vectors: typing.Optional[bool] = None,
        prepend_filename_to_chunks: typing.Optional[bool] = None,
        max_items_per_chunk: typing.Optional[typing.Optional[int]] = None,
        validate: bool = False,
    ) -> UserFilePydantic:
        raw_response = self.raw.upload(
            file=file,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            set_page_as_boundary=set_page_as_boundary,
            embedding_model=embedding_model,
            use_ocr=use_ocr,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            max_items_per_chunk=max_items_per_chunk,
        )
        if validate:
            return UserFilePydantic(**raw_response.body)
        return api_client.construct_model_instance(UserFilePydantic, raw_response.body)


class ApiForpost(BaseApi):
    # this class is used by api classes that refer to endpoints by path and http method names

    async def apost(
        self,
        file: typing.IO,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[bool] = None,
        set_page_as_boundary: typing.Optional[bool] = None,
        embedding_model: typing.Optional[TextEmbeddingGenerators] = None,
        use_ocr: typing.Optional[bool] = None,
        generate_sparse_vectors: typing.Optional[bool] = None,
        prepend_filename_to_chunks: typing.Optional[bool] = None,
        max_items_per_chunk: typing.Optional[typing.Optional[int]] = None,
        **kwargs,
    ) -> typing.Union[
        ApiResponseFor200Async,
        api_client.ApiResponseWithoutDeserializationAsync,
        AsyncGeneratorResponse,
    ]:
        args = self._upload_mapped_args(
            file=file,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            set_page_as_boundary=set_page_as_boundary,
            embedding_model=embedding_model,
            use_ocr=use_ocr,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            max_items_per_chunk=max_items_per_chunk,
        )
        return await self._aupload_oapg(
            body=args.body,
            query_params=args.query,
            **kwargs,
        )
    
    def post(
        self,
        file: typing.IO,
        chunk_size: typing.Optional[typing.Optional[int]] = None,
        chunk_overlap: typing.Optional[typing.Optional[int]] = None,
        skip_embedding_generation: typing.Optional[bool] = None,
        set_page_as_boundary: typing.Optional[bool] = None,
        embedding_model: typing.Optional[TextEmbeddingGenerators] = None,
        use_ocr: typing.Optional[bool] = None,
        generate_sparse_vectors: typing.Optional[bool] = None,
        prepend_filename_to_chunks: typing.Optional[bool] = None,
        max_items_per_chunk: typing.Optional[typing.Optional[int]] = None,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]:
        args = self._upload_mapped_args(
            file=file,
            chunk_size=chunk_size,
            chunk_overlap=chunk_overlap,
            skip_embedding_generation=skip_embedding_generation,
            set_page_as_boundary=set_page_as_boundary,
            embedding_model=embedding_model,
            use_ocr=use_ocr,
            generate_sparse_vectors=generate_sparse_vectors,
            prepend_filename_to_chunks=prepend_filename_to_chunks,
            max_items_per_chunk=max_items_per_chunk,
        )
        return self._upload_oapg(
            body=args.body,
            query_params=args.query,
        )

