# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING

from carbon.type.embedding_generators_nullable import EmbeddingGeneratorsNullable
from carbon.type.file_content_types_nullable import FileContentTypesNullable
from carbon.type.get_embedding_documents_body_file_ids import GetEmbeddingDocumentsBodyFileIds
from carbon.type.get_embedding_documents_body_parent_file_ids import GetEmbeddingDocumentsBodyParentFileIds
from carbon.type.get_embedding_documents_body_query_vector import GetEmbeddingDocumentsBodyQueryVector
from carbon.type.get_embedding_documents_body_tags import GetEmbeddingDocumentsBodyTags
from carbon.type.hybrid_search_tuning_params_nullable import HybridSearchTuningParamsNullable

class RequiredGetEmbeddingDocumentsBody(TypedDict):
    # Query for which to get related chunks and embeddings.
    query: str

    # Number of related chunks to return.
    k: int

class OptionalGetEmbeddingDocumentsBody(TypedDict, total=False):
    tags: GetEmbeddingDocumentsBodyTags

    query_vector: GetEmbeddingDocumentsBodyQueryVector

    file_ids: GetEmbeddingDocumentsBodyFileIds

    parent_file_ids: GetEmbeddingDocumentsBodyParentFileIds

    # A set of tags to limit the search to. Use this instead of `tags`, which is deprecated.
    tags_v2: typing.Optional[typing.Dict[str, typing.Union[bool, date, datetime, dict, float, int, list, str, None]]]

    # Flag to control whether or not to include tags for each chunk in the response.
    include_tags: typing.Optional[bool]

    # Flag to control whether or not to include embedding vectors in the response.
    include_vectors: typing.Optional[bool]

    # Flag to control whether or not to include a signed URL to the raw file containing each chunk         in the response.
    include_raw_file: typing.Optional[bool]

    # Flag to control whether or not to perform hybrid search.
    hybrid_search: typing.Optional[bool]

    hybrid_search_tuning_parameters: HybridSearchTuningParamsNullable

    media_type: FileContentTypesNullable

    embedding_model: EmbeddingGeneratorsNullable

class GetEmbeddingDocumentsBody(RequiredGetEmbeddingDocumentsBody, OptionalGetEmbeddingDocumentsBody):
    pass
