# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING

from carbon.type.data_source_type import DataSourceType
from carbon.type.embedding_generators_nullable import EmbeddingGeneratorsNullable

class RequiredOAuthURLRequest(TypedDict):
    service: DataSourceType

class OptionalOAuthURLRequest(TypedDict, total=False):
    tags: typing.Union[bool, date, datetime, dict, float, int, list, str, None]

    scope: typing.Optional[str]

    chunk_size: typing.Optional[int]

    chunk_overlap: typing.Optional[int]

    skip_embedding_generation: typing.Optional[bool]

    embedding_model: EmbeddingGeneratorsNullable

    zendesk_subdomain: typing.Optional[str]

    microsoft_tenant: typing.Optional[str]

    sharepoint_site_name: typing.Optional[str]

    confluence_subdomain: typing.Optional[str]

    generate_sparse_vectors: typing.Optional[bool]

    prepend_filename_to_chunks: typing.Optional[bool]

    max_items_per_chunk: typing.Optional[int]

    salesforce_domain: typing.Optional[str]

    # Used to specify whether Carbon should attempt to sync all your files automatically when authorization         is complete. This is only supported for a subset of connectors and will be ignored for the rest. Supported         connectors: Intercom, Zendesk, Gitbook, Confluence, Salesforce, Freshdesk
    sync_files_on_connection: typing.Optional[bool]

    set_page_as_boundary: bool

    # Used to specify a data source to sync from if you have multiple connected. It can be skipped if          you only have one data source of that type connected or are connecting a new account.
    data_source_id: typing.Optional[int]

    # Used to connect a new data source. If not specified, we will attempt to create a sync URL         for an existing data source based on type and ID.
    connecting_new_account: typing.Optional[bool]

class OAuthURLRequest(RequiredOAuthURLRequest, OptionalOAuthURLRequest):
    pass
