import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway.html#api_management_id ApiManagementGateway#api_management_id}.
     *
     * @stability stable
     */
    readonly apiManagementId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway.html#description ApiManagementGateway#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway.html#name ApiManagementGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * location_data block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway.html#location_data ApiManagementGateway#location_data}
     *
     * @stability stable
     */
    readonly locationData: ApiManagementGatewayLocationData;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway.html#timeouts ApiManagementGateway#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementGatewayTimeouts;
}
/**
 * @stability stable
 */
export interface ApiManagementGatewayLocationData {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway.html#city ApiManagementGateway#city}.
     *
     * @stability stable
     */
    readonly city?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway.html#district ApiManagementGateway#district}.
     *
     * @stability stable
     */
    readonly district?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway.html#name ApiManagementGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway.html#region ApiManagementGateway#region}.
     *
     * @stability stable
     */
    readonly region?: string;
}
export declare function apiManagementGatewayLocationDataToTerraform(struct?: ApiManagementGatewayLocationDataOutputReference | ApiManagementGatewayLocationData): any;
/**
 * @stability stable
 */
export declare class ApiManagementGatewayLocationDataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementGatewayLocationData | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementGatewayLocationData | undefined);
    private _city?;
    /**
     * @stability stable
     */
    get city(): string;
    /**
     * @stability stable
     */
    set city(value: string);
    /**
     * @stability stable
     */
    resetCity(): void;
    /**
     * @stability stable
     */
    get cityInput(): string | undefined;
    private _district?;
    /**
     * @stability stable
     */
    get district(): string;
    /**
     * @stability stable
     */
    set district(value: string);
    /**
     * @stability stable
     */
    resetDistrict(): void;
    /**
     * @stability stable
     */
    get districtInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementGatewayTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway.html#create ApiManagementGateway#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway.html#delete ApiManagementGateway#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway.html#read ApiManagementGateway#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway.html#update ApiManagementGateway#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementGatewayTimeoutsToTerraform(struct?: ApiManagementGatewayTimeoutsOutputReference | ApiManagementGatewayTimeouts): any;
/**
 * @stability stable
 */
export declare class ApiManagementGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementGatewayTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway.html azurerm_api_management_gateway}.
 *
 * @stability stable
 */
export declare class ApiManagementGateway extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway.html azurerm_api_management_gateway} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementGatewayConfig);
    private _apiManagementId?;
    /**
     * @stability stable
     */
    get apiManagementId(): string;
    /**
     * @stability stable
     */
    set apiManagementId(value: string);
    /**
     * @stability stable
     */
    get apiManagementIdInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _locationData;
    /**
     * @stability stable
     */
    get locationData(): ApiManagementGatewayLocationDataOutputReference;
    /**
     * @stability stable
     */
    putLocationData(value: ApiManagementGatewayLocationData): void;
    /**
     * @stability stable
     */
    get locationDataInput(): ApiManagementGatewayLocationData | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementGatewayTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementGatewayTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
