import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BatchJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_job.html#batch_pool_id BatchJob#batch_pool_id}.
     *
     * @stability stable
     */
    readonly batchPoolId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_job.html#common_environment_properties BatchJob#common_environment_properties}.
     *
     * @stability stable
     */
    readonly commonEnvironmentProperties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_job.html#display_name BatchJob#display_name}.
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_job.html#name BatchJob#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_job.html#priority BatchJob#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_job.html#task_retry_maximum BatchJob#task_retry_maximum}.
     *
     * @stability stable
     */
    readonly taskRetryMaximum?: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_job.html#timeouts BatchJob#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BatchJobTimeouts;
}
/**
 * @stability stable
 */
export interface BatchJobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_job.html#create BatchJob#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_job.html#delete BatchJob#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_job.html#read BatchJob#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/batch_job.html#update BatchJob#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function batchJobTimeoutsToTerraform(struct?: BatchJobTimeoutsOutputReference | BatchJobTimeouts): any;
/**
 * @stability stable
 */
export declare class BatchJobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BatchJobTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BatchJobTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/batch_job.html azurerm_batch_job}.
 *
 * @stability stable
 */
export declare class BatchJob extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/batch_job.html azurerm_batch_job} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BatchJobConfig);
    private _batchPoolId?;
    /**
     * @stability stable
     */
    get batchPoolId(): string;
    /**
     * @stability stable
     */
    set batchPoolId(value: string);
    /**
     * @stability stable
     */
    get batchPoolIdInput(): string | undefined;
    private _commonEnvironmentProperties?;
    /**
     * @stability stable
     */
    get commonEnvironmentProperties(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set commonEnvironmentProperties(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCommonEnvironmentProperties(): void;
    /**
     * @stability stable
     */
    get commonEnvironmentPropertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _taskRetryMaximum?;
    /**
     * @stability stable
     */
    get taskRetryMaximum(): number;
    /**
     * @stability stable
     */
    set taskRetryMaximum(value: number);
    /**
     * @stability stable
     */
    resetTaskRetryMaximum(): void;
    /**
     * @stability stable
     */
    get taskRetryMaximumInput(): number | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BatchJobTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BatchJobTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BatchJobTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
