import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermMysqlServerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_server.html#name DataAzurermMysqlServer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_server.html#resource_group_name DataAzurermMysqlServer#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_server.html#timeouts DataAzurermMysqlServer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermMysqlServerTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermMysqlServerIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermMysqlServerThreatDetectionPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get disabledAlerts(): string[];
    /**
     * @stability stable
     */
    get emailAccountAdmins(): any;
    /**
     * @stability stable
     */
    get emailAddresses(): string[];
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get retentionDays(): number;
    /**
     * @stability stable
     */
    get storageAccountAccessKey(): string;
    /**
     * @stability stable
     */
    get storageEndpoint(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermMysqlServerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_server.html#read DataAzurermMysqlServer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermMysqlServerTimeoutsToTerraform(struct?: DataAzurermMysqlServerTimeoutsOutputReference | DataAzurermMysqlServerTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermMysqlServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermMysqlServerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermMysqlServerTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_server.html azurerm_mysql_server}.
 *
 * @stability stable
 */
export declare class DataAzurermMysqlServer extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_server.html azurerm_mysql_server} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermMysqlServerConfig);
    /**
     * @stability stable
     */
    get administratorLogin(): string;
    /**
     * @stability stable
     */
    get autoGrowEnabled(): any;
    /**
     * @stability stable
     */
    get backupRetentionDays(): number;
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get geoRedundantBackupEnabled(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    identity(index: string): DataAzurermMysqlServerIdentity;
    /**
     * @stability stable
     */
    get infrastructureEncryptionEnabled(): any;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): any;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get restorePointInTime(): string;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    get sslEnforcementEnabled(): any;
    /**
     * @stability stable
     */
    get sslMinimalTlsVersionEnforced(): string;
    /**
     * @stability stable
     */
    get storageMb(): number;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    threatDetectionPolicy(index: string): DataAzurermMysqlServerThreatDetectionPolicy;
    /**
     * @stability stable
     */
    get version(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermMysqlServerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermMysqlServerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermMysqlServerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
