import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermStreamAnalyticsJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/stream_analytics_job.html#name DataAzurermStreamAnalyticsJob#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/stream_analytics_job.html#resource_group_name DataAzurermStreamAnalyticsJob#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/stream_analytics_job.html#timeouts DataAzurermStreamAnalyticsJob#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermStreamAnalyticsJobTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermStreamAnalyticsJobIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermStreamAnalyticsJobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/stream_analytics_job.html#read DataAzurermStreamAnalyticsJob#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermStreamAnalyticsJobTimeoutsToTerraform(struct?: DataAzurermStreamAnalyticsJobTimeoutsOutputReference | DataAzurermStreamAnalyticsJobTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermStreamAnalyticsJobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermStreamAnalyticsJobTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermStreamAnalyticsJobTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/stream_analytics_job.html azurerm_stream_analytics_job}.
 *
 * @stability stable
 */
export declare class DataAzurermStreamAnalyticsJob extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/stream_analytics_job.html azurerm_stream_analytics_job} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermStreamAnalyticsJobConfig);
    /**
     * @stability stable
     */
    get compatibilityLevel(): string;
    /**
     * @stability stable
     */
    get dataLocale(): string;
    /**
     * @stability stable
     */
    get eventsLateArrivalMaxDelayInSeconds(): number;
    /**
     * @stability stable
     */
    get eventsOutOfOrderMaxDelayInSeconds(): number;
    /**
     * @stability stable
     */
    get eventsOutOfOrderPolicy(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    identity(index: string): DataAzurermStreamAnalyticsJobIdentity;
    /**
     * @stability stable
     */
    get jobId(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get outputErrorPolicy(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get streamingUnits(): number;
    /**
     * @stability stable
     */
    get transformationQuery(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermStreamAnalyticsJobTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermStreamAnalyticsJobTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermStreamAnalyticsJobTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
