import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermUserAssignedIdentityConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/user_assigned_identity.html#name DataAzurermUserAssignedIdentity#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/user_assigned_identity.html#resource_group_name DataAzurermUserAssignedIdentity#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/user_assigned_identity.html#timeouts DataAzurermUserAssignedIdentity#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermUserAssignedIdentityTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermUserAssignedIdentityTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/user_assigned_identity.html#read DataAzurermUserAssignedIdentity#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermUserAssignedIdentityTimeoutsToTerraform(struct?: DataAzurermUserAssignedIdentityTimeoutsOutputReference | DataAzurermUserAssignedIdentityTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermUserAssignedIdentityTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermUserAssignedIdentityTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermUserAssignedIdentityTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/user_assigned_identity.html azurerm_user_assigned_identity}.
 *
 * @stability stable
 */
export declare class DataAzurermUserAssignedIdentity extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/user_assigned_identity.html azurerm_user_assigned_identity} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermUserAssignedIdentityConfig);
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get principalId(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermUserAssignedIdentityTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermUserAssignedIdentityTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermUserAssignedIdentityTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
