import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataShareDatasetKustoClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_kusto_cluster.html#kusto_cluster_id DataShareDatasetKustoCluster#kusto_cluster_id}.
     *
     * @stability stable
     */
    readonly kustoClusterId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_kusto_cluster.html#name DataShareDatasetKustoCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_kusto_cluster.html#share_id DataShareDatasetKustoCluster#share_id}.
     *
     * @stability stable
     */
    readonly shareId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_kusto_cluster.html#timeouts DataShareDatasetKustoCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataShareDatasetKustoClusterTimeouts;
}
/**
 * @stability stable
 */
export interface DataShareDatasetKustoClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_kusto_cluster.html#create DataShareDatasetKustoCluster#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_kusto_cluster.html#delete DataShareDatasetKustoCluster#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_kusto_cluster.html#read DataShareDatasetKustoCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataShareDatasetKustoClusterTimeoutsToTerraform(struct?: DataShareDatasetKustoClusterTimeoutsOutputReference | DataShareDatasetKustoClusterTimeouts): any;
/**
 * @stability stable
 */
export declare class DataShareDatasetKustoClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataShareDatasetKustoClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataShareDatasetKustoClusterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_kusto_cluster.html azurerm_data_share_dataset_kusto_cluster}.
 *
 * @stability stable
 */
export declare class DataShareDatasetKustoCluster extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_kusto_cluster.html azurerm_data_share_dataset_kusto_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataShareDatasetKustoClusterConfig);
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _kustoClusterId?;
    /**
     * @stability stable
     */
    get kustoClusterId(): string;
    /**
     * @stability stable
     */
    set kustoClusterId(value: string);
    /**
     * @stability stable
     */
    get kustoClusterIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get kustoClusterLocation(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _shareId?;
    /**
     * @stability stable
     */
    get shareId(): string;
    /**
     * @stability stable
     */
    set shareId(value: string);
    /**
     * @stability stable
     */
    get shareIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataShareDatasetKustoClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataShareDatasetKustoClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataShareDatasetKustoClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
