import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EventhubNamespaceCustomerManagedKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_customer_managed_key.html#eventhub_namespace_id EventhubNamespaceCustomerManagedKey#eventhub_namespace_id}.
     *
     * @stability stable
     */
    readonly eventhubNamespaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_customer_managed_key.html#key_vault_key_ids EventhubNamespaceCustomerManagedKey#key_vault_key_ids}.
     *
     * @stability stable
     */
    readonly keyVaultKeyIds: string[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_customer_managed_key.html#timeouts EventhubNamespaceCustomerManagedKey#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: EventhubNamespaceCustomerManagedKeyTimeouts;
}
/**
 * @stability stable
 */
export interface EventhubNamespaceCustomerManagedKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_customer_managed_key.html#create EventhubNamespaceCustomerManagedKey#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_customer_managed_key.html#delete EventhubNamespaceCustomerManagedKey#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_customer_managed_key.html#read EventhubNamespaceCustomerManagedKey#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_customer_managed_key.html#update EventhubNamespaceCustomerManagedKey#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function eventhubNamespaceCustomerManagedKeyTimeoutsToTerraform(struct?: EventhubNamespaceCustomerManagedKeyTimeoutsOutputReference | EventhubNamespaceCustomerManagedKeyTimeouts): any;
/**
 * @stability stable
 */
export declare class EventhubNamespaceCustomerManagedKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventhubNamespaceCustomerManagedKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventhubNamespaceCustomerManagedKeyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_customer_managed_key.html azurerm_eventhub_namespace_customer_managed_key}.
 *
 * @stability stable
 */
export declare class EventhubNamespaceCustomerManagedKey extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_customer_managed_key.html azurerm_eventhub_namespace_customer_managed_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EventhubNamespaceCustomerManagedKeyConfig);
    private _eventhubNamespaceId?;
    /**
     * @stability stable
     */
    get eventhubNamespaceId(): string;
    /**
     * @stability stable
     */
    set eventhubNamespaceId(value: string);
    /**
     * @stability stable
     */
    get eventhubNamespaceIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyVaultKeyIds?;
    /**
     * @stability stable
     */
    get keyVaultKeyIds(): string[];
    /**
     * @stability stable
     */
    set keyVaultKeyIds(value: string[]);
    /**
     * @stability stable
     */
    get keyVaultKeyIdsInput(): string[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): EventhubNamespaceCustomerManagedKeyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: EventhubNamespaceCustomerManagedKeyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): EventhubNamespaceCustomerManagedKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
