import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkSecurityGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#location NetworkSecurityGroup#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#name NetworkSecurityGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#resource_group_name NetworkSecurityGroup#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#security_rule NetworkSecurityGroup#security_rule}.
     *
     * @stability stable
     */
    readonly securityRule?: NetworkSecurityGroupSecurityRule[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#tags NetworkSecurityGroup#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#timeouts NetworkSecurityGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkSecurityGroupTimeouts;
}
/**
 * @stability stable
 */
export interface NetworkSecurityGroupSecurityRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#access NetworkSecurityGroup#access}.
     *
     * @stability stable
     */
    readonly access?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#description NetworkSecurityGroup#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#destination_address_prefix NetworkSecurityGroup#destination_address_prefix}.
     *
     * @stability stable
     */
    readonly destinationAddressPrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#destination_address_prefixes NetworkSecurityGroup#destination_address_prefixes}.
     *
     * @stability stable
     */
    readonly destinationAddressPrefixes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#destination_application_security_group_ids NetworkSecurityGroup#destination_application_security_group_ids}.
     *
     * @stability stable
     */
    readonly destinationApplicationSecurityGroupIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#destination_port_range NetworkSecurityGroup#destination_port_range}.
     *
     * @stability stable
     */
    readonly destinationPortRange?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#destination_port_ranges NetworkSecurityGroup#destination_port_ranges}.
     *
     * @stability stable
     */
    readonly destinationPortRanges?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#direction NetworkSecurityGroup#direction}.
     *
     * @stability stable
     */
    readonly direction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#name NetworkSecurityGroup#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#priority NetworkSecurityGroup#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#protocol NetworkSecurityGroup#protocol}.
     *
     * @stability stable
     */
    readonly protocol?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#source_address_prefix NetworkSecurityGroup#source_address_prefix}.
     *
     * @stability stable
     */
    readonly sourceAddressPrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#source_address_prefixes NetworkSecurityGroup#source_address_prefixes}.
     *
     * @stability stable
     */
    readonly sourceAddressPrefixes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#source_application_security_group_ids NetworkSecurityGroup#source_application_security_group_ids}.
     *
     * @stability stable
     */
    readonly sourceApplicationSecurityGroupIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#source_port_range NetworkSecurityGroup#source_port_range}.
     *
     * @stability stable
     */
    readonly sourcePortRange?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#source_port_ranges NetworkSecurityGroup#source_port_ranges}.
     *
     * @stability stable
     */
    readonly sourcePortRanges?: string[];
}
export declare function networkSecurityGroupSecurityRuleToTerraform(struct?: NetworkSecurityGroupSecurityRule): any;
/**
 * @stability stable
 */
export interface NetworkSecurityGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#create NetworkSecurityGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#delete NetworkSecurityGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#read NetworkSecurityGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html#update NetworkSecurityGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function networkSecurityGroupTimeoutsToTerraform(struct?: NetworkSecurityGroupTimeoutsOutputReference | NetworkSecurityGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class NetworkSecurityGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkSecurityGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkSecurityGroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html azurerm_network_security_group}.
 *
 * @stability stable
 */
export declare class NetworkSecurityGroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_group.html azurerm_network_security_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkSecurityGroupConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _securityRule?;
    /**
     * @stability stable
     */
    get securityRule(): NetworkSecurityGroupSecurityRule[];
    /**
     * @stability stable
     */
    set securityRule(value: NetworkSecurityGroupSecurityRule[]);
    /**
     * @stability stable
     */
    resetSecurityRule(): void;
    /**
     * @stability stable
     */
    get securityRuleInput(): NetworkSecurityGroupSecurityRule[] | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NetworkSecurityGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkSecurityGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkSecurityGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
