"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const sns = require("@aws-cdk/aws-sns");
const sqs = require("@aws-cdk/aws-sqs");
const core_1 = require("@aws-cdk/core");
const destinations = require("../lib");
// After deploy, test with:
// aws lambda invoke --function-name <deployed fn name> --invocation-type Event --payload '"OK"' response.json
// aws lambda invoke --function-name <deployed fn name> --invocation-type Event --payload '"NOT OK"' response.json
class TestStack extends core_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const topic = new sns.Topic(this, 'Topic');
        const queue = new sqs.Queue(this, 'Queue');
        const fn = new lambda.Function(this, 'SnsSqs', {
            runtime: lambda.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: lambda.Code.fromInline(`exports.handler = async (event) => {
        if (event === 'OK') return 'success';
        throw new Error('failure');
      };`),
            onFailure: new destinations.SnsDestination(topic),
            onSuccess: new destinations.SqsDestination(queue),
            maxEventAge: core_1.Duration.hours(3),
            retryAttempts: 1
        });
        const onSuccessLambda = new lambda.Function(this, 'OnSucces', {
            runtime: lambda.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: lambda.Code.fromInline(`exports.handler = async (event) => {
        console.log(event);
      };`),
        });
        new lambda.Function(this, 'EventBusLambda', {
            runtime: lambda.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: lambda.Code.fromInline(`exports.handler = async (event) => {
        if (event === 'OK') return 'success';
        throw new Error('failure');
      };`),
            onFailure: new destinations.EventBridgeDestination(),
            onSuccess: new destinations.LambdaDestination(onSuccessLambda),
        });
        const version = fn.addVersion('MySpecialVersion');
        new lambda.Alias(this, 'MySpecialAlias', {
            aliasName: 'MySpecialAlias',
            version,
            onSuccess: new destinations.SqsDestination(queue),
            onFailure: new destinations.SnsDestination(topic),
            maxEventAge: core_1.Duration.hours(2),
            retryAttempts: 0
        });
    }
}
const app = new core_1.App();
new TestStack(app, 'aws-cdk-lambda-destinations');
app.synth();
//# sourceMappingURL=data:application/json;base64,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