"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnDroplet = exports.toJson_CfnDropletProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnDropletProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnDropletProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Backups': obj.backups,
        'Image': obj.image,
        'Ipv6': obj.ipv6,
        'Monitoring': obj.monitoring,
        'Name': obj.name,
        'PrivateNetworking': obj.privateNetworking,
        'Region': obj.region,
        'ResizeDisk': obj.resizeDisk,
        'Size': obj.size,
        'SshKeys': obj.sshKeys?.map(y => y),
        'Tags': obj.tags?.map(y => y),
        'UserData': obj.userData,
        'VolumeIds': obj.volumeIds?.map(y => y),
        'VpcUuid': obj.vpcUuid,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnDropletProps = toJson_CfnDropletProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `TF::DigitalOcean::Droplet`
 *
 * @cloudformationResource TF::DigitalOcean::Droplet
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
class CfnDroplet extends cdk.CfnResource {
    /**
     * Create a new `TF::DigitalOcean::Droplet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDroplet.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnDropletProps(props) });
        this.props = props;
        this.attrTfcfnid = cdk.Token.asString(this.getAtt('tfcfnid'));
        this.attrCreatedAt = cdk.Token.asString(this.getAtt('CreatedAt'));
        this.attrDisk = cdk.Token.asNumber(this.getAtt('Disk'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrIpv4Address = cdk.Token.asString(this.getAtt('Ipv4Address'));
        this.attrIpv4AddressPrivate = cdk.Token.asString(this.getAtt('Ipv4AddressPrivate'));
        this.attrIpv6Address = cdk.Token.asString(this.getAtt('Ipv6Address'));
        this.attrLocked = this.getAtt('Locked');
        this.attrMemory = cdk.Token.asNumber(this.getAtt('Memory'));
        this.attrPriceHourly = cdk.Token.asNumber(this.getAtt('PriceHourly'));
        this.attrPriceMonthly = cdk.Token.asNumber(this.getAtt('PriceMonthly'));
        this.attrStatus = cdk.Token.asString(this.getAtt('Status'));
        this.attrUrn = cdk.Token.asString(this.getAtt('Urn'));
        this.attrVcpus = cdk.Token.asNumber(this.getAtt('Vcpus'));
    }
}
exports.CfnDroplet = CfnDroplet;
_a = JSII_RTTI_SYMBOL_1;
CfnDroplet[_a] = { fqn: "@cdk-cloudformation/tf-digitalocean-droplet.CfnDroplet", version: "1.0.0-alpha.6" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnDroplet.CFN_RESOURCE_TYPE_NAME = "TF::DigitalOcean::Droplet";
//# sourceMappingURL=data:application/json;base64,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