/*
  C interface for calling bpsline-fortran code
  NOTE: The bpline-fortran code is modified for the C-interface by changing
  the dimension arguments of the input arrays to be allocated first
  (rather than unallocated in the original code, see db3ink in bspline_sub_module.f90). This is
  so that the arrays passed into the function can be correctly sized and operated on.
*/
#ifndef BSPLINEINTERFACE_H_
#define BSPLINEINTERFACE_H_

#include <FCheader.h> // This file should be generated by cmake

extern "C" {
    void FC_bspline_sub_module_db3ink(double* x, long int* nx, double* y, long int* ny, double* z, long int* nz,
        double* fcn, int* kx, int* ky, int* kz, int* iknot, double* tx, double* ty, double* tz,
        double* bcoef, int* iflag);
    void FC_db3interp(double* x, double* y, double* z, int* idx, int* idy, int* idz,
        double* tx, double* ty, double* tz, long int* ntx, long int* nty, long int* ntz,
        long int* nx, long int* ny, long int* nz, int* kx, int* ky, int* kz, double* bcoef,
        double* f, int* iflag, int* inbvx, int* inbvy, int* inbvz,
        int* iloy, int* iloz, int* extrap, double* affine, double* grid_mat_source, double* grid_mat_target,
        double* mask);
}
#endif
