# coding: utf-8

"""

    No descripton provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class FeaturesApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_feature(self, **kwargs):
        """
        Create an enumerated sequence feature
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_feature(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FeatureRequest body: 
        :return: Feature
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_feature_with_http_info(**kwargs)
        else:
            (data) = self.create_feature_with_http_info(**kwargs)
            return data

    def create_feature_with_http_info(self, **kwargs):
        """
        Create an enumerated sequence feature
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_feature_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FeatureRequest body: 
        :return: Feature
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_feature" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/features'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Feature',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_feature_by_path(self, locus, term, rank, accession, **kwargs):
        """
        Retrieve an enumerated sequence feature
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_feature_by_path(locus, term, rank, accession, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str locus: locus name or URI (required)
        :param str term: Sequence Ontology (SO) term name, accession, or URI (required)
        :param int rank: feature rank, must be at least 1 (required)
        :param int accession: accession, must be at least 1 (required)
        :return: Feature
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_feature_by_path_with_http_info(locus, term, rank, accession, **kwargs)
        else:
            (data) = self.get_feature_by_path_with_http_info(locus, term, rank, accession, **kwargs)
            return data

    def get_feature_by_path_with_http_info(self, locus, term, rank, accession, **kwargs):
        """
        Retrieve an enumerated sequence feature
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_feature_by_path_with_http_info(locus, term, rank, accession, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str locus: locus name or URI (required)
        :param str term: Sequence Ontology (SO) term name, accession, or URI (required)
        :param int rank: feature rank, must be at least 1 (required)
        :param int accession: accession, must be at least 1 (required)
        :return: Feature
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['locus', 'term', 'rank', 'accession']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_feature_by_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'locus' is set
        if ('locus' not in params) or (params['locus'] is None):
            raise ValueError("Missing the required parameter `locus` when calling `get_feature_by_path`")
        # verify the required parameter 'term' is set
        if ('term' not in params) or (params['term'] is None):
            raise ValueError("Missing the required parameter `term` when calling `get_feature_by_path`")
        # verify the required parameter 'rank' is set
        if ('rank' not in params) or (params['rank'] is None):
            raise ValueError("Missing the required parameter `rank` when calling `get_feature_by_path`")
        # verify the required parameter 'accession' is set
        if ('accession' not in params) or (params['accession'] is None):
            raise ValueError("Missing the required parameter `accession` when calling `get_feature_by_path`")

        resource_path = '/features/{locus}/{term}/{rank}/{accession}'.replace('{format}', 'json')
        path_params = {}
        if 'locus' in params:
            path_params['locus'] = params['locus']
        if 'term' in params:
            path_params['term'] = params['term']
        if 'rank' in params:
            path_params['rank'] = params['rank']
        if 'accession' in params:
            path_params['accession'] = params['accession']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Feature',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_feature_by_query(self, **kwargs):
        """
        Retrieve an enumerated sequence feature
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_feature_by_query(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str locus: locus name or URI
        :param str term: Sequence Ontology (SO) term name, accession, or URI
        :param int rank: feature rank, must be at least 1
        :param int accession: accession, must be at least 1
        :return: Feature
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_feature_by_query_with_http_info(**kwargs)
        else:
            (data) = self.get_feature_by_query_with_http_info(**kwargs)
            return data

    def get_feature_by_query_with_http_info(self, **kwargs):
        """
        Retrieve an enumerated sequence feature
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_feature_by_query_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str locus: locus name or URI
        :param str term: Sequence Ontology (SO) term name, accession, or URI
        :param int rank: feature rank, must be at least 1
        :param int accession: accession, must be at least 1
        :return: Feature
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['locus', 'term', 'rank', 'accession']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_feature_by_query" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/features'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'locus' in params:
            query_params['locus'] = params['locus']
        if 'term' in params:
            query_params['term'] = params['term']
        if 'rank' in params:
            query_params['rank'] = params['rank']
        if 'accession' in params:
            query_params['accession'] = params['accession']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Feature',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_features(self, locus, **kwargs):
        """
        List the enumerated sequence features at a locus
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_features(locus, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str locus: locus name or URI (required)
        :return: list[Feature]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_features_with_http_info(locus, **kwargs)
        else:
            (data) = self.list_features_with_http_info(locus, **kwargs)
            return data

    def list_features_with_http_info(self, locus, **kwargs):
        """
        List the enumerated sequence features at a locus
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_features_with_http_info(locus, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str locus: locus name or URI (required)
        :return: list[Feature]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['locus']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_features" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'locus' is set
        if ('locus' not in params) or (params['locus'] is None):
            raise ValueError("Missing the required parameter `locus` when calling `list_features`")

        resource_path = '/features/{locus}'.replace('{format}', 'json')
        path_params = {}
        if 'locus' in params:
            path_params['locus'] = params['locus']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Feature]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_features_0(self, locus, term, **kwargs):
        """
        List the enumerated sequence features matching a term at a locus
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_features_0(locus, term, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str locus: locus name or URI (required)
        :param str term: Sequence Ontology (SO) term name, accession, or URI (required)
        :return: list[Feature]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_features_0_with_http_info(locus, term, **kwargs)
        else:
            (data) = self.list_features_0_with_http_info(locus, term, **kwargs)
            return data

    def list_features_0_with_http_info(self, locus, term, **kwargs):
        """
        List the enumerated sequence features matching a term at a locus
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_features_0_with_http_info(locus, term, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str locus: locus name or URI (required)
        :param str term: Sequence Ontology (SO) term name, accession, or URI (required)
        :return: list[Feature]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['locus', 'term']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_features_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'locus' is set
        if ('locus' not in params) or (params['locus'] is None):
            raise ValueError("Missing the required parameter `locus` when calling `list_features_0`")
        # verify the required parameter 'term' is set
        if ('term' not in params) or (params['term'] is None):
            raise ValueError("Missing the required parameter `term` when calling `list_features_0`")

        resource_path = '/features/{locus}/{term}'.replace('{format}', 'json')
        path_params = {}
        if 'locus' in params:
            path_params['locus'] = params['locus']
        if 'term' in params:
            path_params['term'] = params['term']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Feature]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_features_1(self, locus, term, rank, **kwargs):
        """
        List the enumerated sequence features matching a term and rank at a locus
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_features_1(locus, term, rank, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str locus: locus name or URI (required)
        :param str term: Sequence Ontology (SO) term name, accession, or URI (required)
        :param int rank: feature rank, must be at least 1 (required)
        :return: list[Feature]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_features_1_with_http_info(locus, term, rank, **kwargs)
        else:
            (data) = self.list_features_1_with_http_info(locus, term, rank, **kwargs)
            return data

    def list_features_1_with_http_info(self, locus, term, rank, **kwargs):
        """
        List the enumerated sequence features matching a term and rank at a locus
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_features_1_with_http_info(locus, term, rank, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str locus: locus name or URI (required)
        :param str term: Sequence Ontology (SO) term name, accession, or URI (required)
        :param int rank: feature rank, must be at least 1 (required)
        :return: list[Feature]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['locus', 'term', 'rank']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_features_1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'locus' is set
        if ('locus' not in params) or (params['locus'] is None):
            raise ValueError("Missing the required parameter `locus` when calling `list_features_1`")
        # verify the required parameter 'term' is set
        if ('term' not in params) or (params['term'] is None):
            raise ValueError("Missing the required parameter `term` when calling `list_features_1`")
        # verify the required parameter 'rank' is set
        if ('rank' not in params) or (params['rank'] is None):
            raise ValueError("Missing the required parameter `rank` when calling `list_features_1`")

        resource_path = '/features/{locus}/{term}/{rank}'.replace('{format}', 'json')
        path_params = {}
        if 'locus' in params:
            path_params['locus'] = params['locus']
        if 'term' in params:
            path_params['term'] = params['term']
        if 'rank' in params:
            path_params['rank'] = params['rank']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Feature]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
