/// <reference types="node" />
import { Architecture, AssetCode, Runtime } from 'aws-cdk-lib/aws-lambda';
import * as cdk from 'aws-cdk-lib/core';
import { BundlingOptions } from '../types';
/**
 * Options for bundling
 */
export interface BundlingProps extends BundlingOptions {
    readonly projectDir: string;
    readonly solutionDir: string;
    /**
     * The runtime of the lambda function
     */
    readonly runtime: Runtime;
    /**
     * The system architecture of the lambda function
     */
    readonly architecture: Architecture;
}
/**
 * Bundling
 */
export declare class Bundling implements cdk.BundlingOptions {
    private readonly props;
    static bundle(options: BundlingProps): AssetCode;
    private static runsLocally?;
    private static defaultBuildImage;
    readonly image: cdk.DockerImage;
    readonly command: string[];
    readonly environment?: {
        [key: string]: string;
    };
    readonly local?: cdk.ILocalBundling;
    private readonly msbuildParameters;
    private readonly relativeProjectPath;
    constructor(props: BundlingProps);
    createBundlingCommand(inputDir: string, outputDir: string, architecture: Architecture, osPlatform?: NodeJS.Platform): string;
}
