# coding: utf-8

"""
    Geo Engine Pro API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictBool, StrictStr, conint

from typing import Any, Optional, Union

from geoengine_openapi_client.models.get_capabilities_request import GetCapabilitiesRequest
from geoengine_openapi_client.models.get_legend_graphic_request import GetLegendGraphicRequest
from geoengine_openapi_client.models.get_map_format import GetMapFormat
from geoengine_openapi_client.models.get_map_request import GetMapRequest
from geoengine_openapi_client.models.wms_service import WmsService
from geoengine_openapi_client.models.wms_version import WmsVersion

from geoengine_openapi_client.api_client import ApiClient
from geoengine_openapi_client.api_response import ApiResponse
from geoengine_openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class OGCWMSApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def wms_capabilities_handler(self, workflow : Annotated[StrictStr, Field(..., description="Workflow id")], version : Optional[Any], service : WmsService, request : GetCapabilitiesRequest, format : Optional[Any], **kwargs) -> str:  # noqa: E501
        """Get WMS Capabilities  # noqa: E501

        Get WMS Capabilities  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.wms_capabilities_handler(workflow, version, service, request, format, async_req=True)
        >>> result = thread.get()

        :param workflow: Workflow id (required)
        :type workflow: str
        :param version: (required)
        :type version: WmsVersion
        :param service: (required)
        :type service: WmsService
        :param request: (required)
        :type request: GetCapabilitiesRequest
        :param format: (required)
        :type format: GetCapabilitiesFormat
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the wms_capabilities_handler_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.wms_capabilities_handler_with_http_info(workflow, version, service, request, format, **kwargs)  # noqa: E501

    @validate_arguments
    def wms_capabilities_handler_with_http_info(self, workflow : Annotated[StrictStr, Field(..., description="Workflow id")], version : Optional[Any], service : WmsService, request : GetCapabilitiesRequest, format : Optional[Any], **kwargs) -> ApiResponse:  # noqa: E501
        """Get WMS Capabilities  # noqa: E501

        Get WMS Capabilities  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.wms_capabilities_handler_with_http_info(workflow, version, service, request, format, async_req=True)
        >>> result = thread.get()

        :param workflow: Workflow id (required)
        :type workflow: str
        :param version: (required)
        :type version: WmsVersion
        :param service: (required)
        :type service: WmsService
        :param request: (required)
        :type request: GetCapabilitiesRequest
        :param format: (required)
        :type format: GetCapabilitiesFormat
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'workflow',
            'version',
            'service',
            'request',
            'format'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wms_capabilities_handler" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['workflow']:
            _path_params['workflow'] = _params['workflow']

        if _params['version']:
            _path_params['version'] = _params['version']

        if _params['service']:
            _path_params['service'] = _params['service']

        if _params['request']:
            _path_params['request'] = _params['request']

        if _params['format']:
            _path_params['format'] = _params['format']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/xml'])  # noqa: E501

        # authentication setting
        _auth_settings = ['session_token']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/wms/{workflow}?request=GetCapabilities', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def wms_legend_graphic_handler(self, workflow : Annotated[StrictStr, Field(..., description="Workflow id")], version : WmsVersion, service : WmsService, request : GetLegendGraphicRequest, layer : StrictStr, **kwargs) -> None:  # noqa: E501
        """Get WMS Legend Graphic  # noqa: E501

        Get WMS Legend Graphic  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.wms_legend_graphic_handler(workflow, version, service, request, layer, async_req=True)
        >>> result = thread.get()

        :param workflow: Workflow id (required)
        :type workflow: str
        :param version: (required)
        :type version: WmsVersion
        :param service: (required)
        :type service: WmsService
        :param request: (required)
        :type request: GetLegendGraphicRequest
        :param layer: (required)
        :type layer: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the wms_legend_graphic_handler_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.wms_legend_graphic_handler_with_http_info(workflow, version, service, request, layer, **kwargs)  # noqa: E501

    @validate_arguments
    def wms_legend_graphic_handler_with_http_info(self, workflow : Annotated[StrictStr, Field(..., description="Workflow id")], version : WmsVersion, service : WmsService, request : GetLegendGraphicRequest, layer : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get WMS Legend Graphic  # noqa: E501

        Get WMS Legend Graphic  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.wms_legend_graphic_handler_with_http_info(workflow, version, service, request, layer, async_req=True)
        >>> result = thread.get()

        :param workflow: Workflow id (required)
        :type workflow: str
        :param version: (required)
        :type version: WmsVersion
        :param service: (required)
        :type service: WmsService
        :param request: (required)
        :type request: GetLegendGraphicRequest
        :param layer: (required)
        :type layer: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'workflow',
            'version',
            'service',
            'request',
            'layer'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wms_legend_graphic_handler" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['workflow']:
            _path_params['workflow'] = _params['workflow']

        if _params['version']:
            _path_params['version'] = _params['version']

        if _params['service']:
            _path_params['service'] = _params['service']

        if _params['request']:
            _path_params['request'] = _params['request']

        if _params['layer']:
            _path_params['layer'] = _params['layer']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = ['session_token']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/wms/{workflow}?request=GetLegendGraphic', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def wms_map_handler(self, workflow : Annotated[StrictStr, Field(..., description="Workflow id")], version : WmsVersion, service : WmsService, request : GetMapRequest, width : conint(strict=True, ge=0), height : conint(strict=True, ge=0), bbox : StrictStr, format : GetMapFormat, layers : StrictStr, styles : StrictStr, crs : Optional[StrictStr] = None, time : Optional[StrictStr] = None, transparent : Optional[StrictBool] = None, bgcolor : Optional[StrictStr] = None, sld : Optional[StrictStr] = None, sld_body : Optional[StrictStr] = None, elevation : Optional[StrictStr] = None, exceptions : Optional[Any] = None, **kwargs) -> bytearray:  # noqa: E501
        """Get WMS Map  # noqa: E501

        Get WMS Map  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.wms_map_handler(workflow, version, service, request, width, height, bbox, format, layers, styles, crs, time, transparent, bgcolor, sld, sld_body, elevation, exceptions, async_req=True)
        >>> result = thread.get()

        :param workflow: Workflow id (required)
        :type workflow: str
        :param version: (required)
        :type version: WmsVersion
        :param service: (required)
        :type service: WmsService
        :param request: (required)
        :type request: GetMapRequest
        :param width: (required)
        :type width: int
        :param height: (required)
        :type height: int
        :param bbox: (required)
        :type bbox: str
        :param format: (required)
        :type format: GetMapFormat
        :param layers: (required)
        :type layers: str
        :param styles: (required)
        :type styles: str
        :param crs:
        :type crs: str
        :param time:
        :type time: str
        :param transparent:
        :type transparent: bool
        :param bgcolor:
        :type bgcolor: str
        :param sld:
        :type sld: str
        :param sld_body:
        :type sld_body: str
        :param elevation:
        :type elevation: str
        :param exceptions:
        :type exceptions: GetMapExceptionFormat
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the wms_map_handler_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.wms_map_handler_with_http_info(workflow, version, service, request, width, height, bbox, format, layers, styles, crs, time, transparent, bgcolor, sld, sld_body, elevation, exceptions, **kwargs)  # noqa: E501

    @validate_arguments
    def wms_map_handler_with_http_info(self, workflow : Annotated[StrictStr, Field(..., description="Workflow id")], version : WmsVersion, service : WmsService, request : GetMapRequest, width : conint(strict=True, ge=0), height : conint(strict=True, ge=0), bbox : StrictStr, format : GetMapFormat, layers : StrictStr, styles : StrictStr, crs : Optional[StrictStr] = None, time : Optional[StrictStr] = None, transparent : Optional[StrictBool] = None, bgcolor : Optional[StrictStr] = None, sld : Optional[StrictStr] = None, sld_body : Optional[StrictStr] = None, elevation : Optional[StrictStr] = None, exceptions : Optional[Any] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get WMS Map  # noqa: E501

        Get WMS Map  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.wms_map_handler_with_http_info(workflow, version, service, request, width, height, bbox, format, layers, styles, crs, time, transparent, bgcolor, sld, sld_body, elevation, exceptions, async_req=True)
        >>> result = thread.get()

        :param workflow: Workflow id (required)
        :type workflow: str
        :param version: (required)
        :type version: WmsVersion
        :param service: (required)
        :type service: WmsService
        :param request: (required)
        :type request: GetMapRequest
        :param width: (required)
        :type width: int
        :param height: (required)
        :type height: int
        :param bbox: (required)
        :type bbox: str
        :param format: (required)
        :type format: GetMapFormat
        :param layers: (required)
        :type layers: str
        :param styles: (required)
        :type styles: str
        :param crs:
        :type crs: str
        :param time:
        :type time: str
        :param transparent:
        :type transparent: bool
        :param bgcolor:
        :type bgcolor: str
        :param sld:
        :type sld: str
        :param sld_body:
        :type sld_body: str
        :param elevation:
        :type elevation: str
        :param exceptions:
        :type exceptions: GetMapExceptionFormat
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'workflow',
            'version',
            'service',
            'request',
            'width',
            'height',
            'bbox',
            'format',
            'layers',
            'styles',
            'crs',
            'time',
            'transparent',
            'bgcolor',
            'sld',
            'sld_body',
            'elevation',
            'exceptions'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method wms_map_handler" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['workflow']:
            _path_params['workflow'] = _params['workflow']


        # process the query parameters
        _query_params = []
        if _params.get('version') is not None:  # noqa: E501
            _query_params.append(('version', _params['version'].value))

        if _params.get('service') is not None:  # noqa: E501
            _query_params.append(('service', _params['service'].value))

        if _params.get('request') is not None:  # noqa: E501
            _query_params.append(('request', _params['request'].value))

        if _params.get('width') is not None:  # noqa: E501
            _query_params.append(('width', _params['width']))

        if _params.get('height') is not None:  # noqa: E501
            _query_params.append(('height', _params['height']))

        if _params.get('bbox') is not None:  # noqa: E501
            _query_params.append(('bbox', _params['bbox']))

        if _params.get('format') is not None:  # noqa: E501
            _query_params.append(('format', _params['format'].value))

        if _params.get('layers') is not None:  # noqa: E501
            _query_params.append(('layers', _params['layers']))

        if _params.get('crs') is not None:  # noqa: E501
            _query_params.append(('crs', _params['crs']))

        if _params.get('styles') is not None:  # noqa: E501
            _query_params.append(('styles', _params['styles']))

        if _params.get('time') is not None:  # noqa: E501
            _query_params.append(('time', _params['time']))

        if _params.get('transparent') is not None:  # noqa: E501
            _query_params.append(('transparent', _params['transparent']))

        if _params.get('bgcolor') is not None:  # noqa: E501
            _query_params.append(('bgcolor', _params['bgcolor']))

        if _params.get('sld') is not None:  # noqa: E501
            _query_params.append(('sld', _params['sld']))

        if _params.get('sld_body') is not None:  # noqa: E501
            _query_params.append(('sld_body', _params['sld_body']))

        if _params.get('elevation') is not None:  # noqa: E501
            _query_params.append(('elevation', _params['elevation']))

        if _params.get('exceptions') is not None:  # noqa: E501
            _query_params.append(('exceptions', _params['exceptions'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['image/png'])  # noqa: E501

        # authentication setting
        _auth_settings = ['session_token']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
        }

        return self.api_client.call_api(
            '/wms/{workflow}?request=GetMap', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
