# coding: utf-8

"""
    Geo Engine Pro API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Optional
from pydantic import BaseModel, Field, StrictStr, validator

class CompletedTaskStatus(BaseModel):
    """
    CompletedTaskStatus
    """
    description: Optional[StrictStr] = None
    info: Optional[Any] = None
    status: StrictStr = Field(...)
    task_type: StrictStr = Field(..., alias="taskType")
    time_started: StrictStr = Field(..., alias="timeStarted")
    time_total: StrictStr = Field(..., alias="timeTotal")
    __properties = ["description", "info", "status", "taskType", "timeStarted", "timeTotal"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('completed'):
            raise ValueError("must be one of enum values ('completed')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CompletedTaskStatus:
        """Create an instance of CompletedTaskStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if info (nullable) is None
        # and __fields_set__ contains the field
        if self.info is None and "info" in self.__fields_set__:
            _dict['info'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CompletedTaskStatus:
        """Create an instance of CompletedTaskStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CompletedTaskStatus.parse_obj(obj)

        _obj = CompletedTaskStatus.parse_obj({
            "description": obj.get("description"),
            "info": obj.get("info"),
            "status": obj.get("status"),
            "task_type": obj.get("taskType"),
            "time_started": obj.get("timeStarted"),
            "time_total": obj.get("timeTotal")
        })
        return _obj


