# coding: utf-8

"""
    Geo Engine Pro API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from geoengine_openapi_client.models.st_rectangle import STRectangle
from geoengine_openapi_client.models.time_step import TimeStep

class CreateProject(BaseModel):
    """
    CreateProject
    """
    bounds: STRectangle = Field(...)
    description: StrictStr = Field(...)
    name: StrictStr = Field(...)
    time_step: Optional[TimeStep] = Field(None, alias="timeStep")
    __properties = ["bounds", "description", "name", "timeStep"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateProject:
        """Create an instance of CreateProject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of bounds
        if self.bounds:
            _dict['bounds'] = self.bounds.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time_step
        if self.time_step:
            _dict['timeStep'] = self.time_step.to_dict()
        # set to None if time_step (nullable) is None
        # and __fields_set__ contains the field
        if self.time_step is None and "time_step" in self.__fields_set__:
            _dict['timeStep'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateProject:
        """Create an instance of CreateProject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateProject.parse_obj(obj)

        _obj = CreateProject.parse_obj({
            "bounds": STRectangle.from_dict(obj.get("bounds")) if obj.get("bounds") is not None else None,
            "description": obj.get("description"),
            "name": obj.get("name"),
            "time_step": TimeStep.from_dict(obj.get("timeStep")) if obj.get("timeStep") is not None else None
        })
        return _obj


