# coding: utf-8

"""
    Geo Engine Pro API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from geoengine_openapi_client.models.external_data_id_with_type import ExternalDataIdWithType
from geoengine_openapi_client.models.internal_data_id import InternalDataId
from typing import Union, Any, List, TYPE_CHECKING
from pydantic import StrictStr, Field

DATAID_ONE_OF_SCHEMAS = ["ExternalDataIdWithType", "InternalDataId"]

class DataId(BaseModel):
    """
    DataId
    """
    # data type: InternalDataId
    oneof_schema_1_validator: Optional[InternalDataId] = None
    # data type: ExternalDataIdWithType
    oneof_schema_2_validator: Optional[ExternalDataIdWithType] = None
    if TYPE_CHECKING:
        actual_instance: Union[ExternalDataIdWithType, InternalDataId]
    else:
        actual_instance: Any
    one_of_schemas: List[str] = Field(DATAID_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    discriminator_value_class_map = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = DataId.construct()
        error_messages = []
        match = 0
        # validate data type: InternalDataId
        if not isinstance(v, InternalDataId):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InternalDataId`")
        else:
            match += 1
        # validate data type: ExternalDataIdWithType
        if not isinstance(v, ExternalDataIdWithType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ExternalDataIdWithType`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in DataId with oneOf schemas: ExternalDataIdWithType, InternalDataId. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in DataId with oneOf schemas: ExternalDataIdWithType, InternalDataId. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> DataId:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> DataId:
        """Returns the object represented by the json string"""
        instance = DataId.construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("type")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `type` in the input.")

        # check if data type is `ExternalDataIdWithType`
        if _data_type == "ExternalDataIdWithType":
            instance.actual_instance = ExternalDataIdWithType.from_json(json_str)
            return instance

        # check if data type is `InternalDataId`
        if _data_type == "InternalDataId":
            instance.actual_instance = InternalDataId.from_json(json_str)
            return instance

        # check if data type is `ExternalDataIdWithType`
        if _data_type == "external":
            instance.actual_instance = ExternalDataIdWithType.from_json(json_str)
            return instance

        # check if data type is `InternalDataId`
        if _data_type == "internal":
            instance.actual_instance = InternalDataId.from_json(json_str)
            return instance

        # deserialize data into InternalDataId
        try:
            instance.actual_instance = InternalDataId.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ExternalDataIdWithType
        try:
            instance.actual_instance = ExternalDataIdWithType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into DataId with oneOf schemas: ExternalDataIdWithType, InternalDataId. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into DataId with oneOf schemas: ExternalDataIdWithType, InternalDataId. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())


