# coding: utf-8

"""
    Geo Engine Pro API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from geoengine_openapi_client.models.provider_layer_id import ProviderLayerId
from geoengine_openapi_client.models.symbology import Symbology
from geoengine_openapi_client.models.workflow import Workflow

class Layer(BaseModel):
    """
    Layer
    """
    description: StrictStr = Field(...)
    id: ProviderLayerId = Field(...)
    metadata: Optional[Dict[str, StrictStr]] = Field(None, description="metadata used for loading the data")
    name: StrictStr = Field(...)
    properties: Optional[conlist(conlist(StrictStr, max_items=2, min_items=2))] = Field(None, description="properties, for instance, to be rendered in the UI")
    symbology: Optional[Symbology] = None
    workflow: Workflow = Field(...)
    __properties = ["description", "id", "metadata", "name", "properties", "symbology", "workflow"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Layer:
        """Create an instance of Layer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of symbology
        if self.symbology:
            _dict['symbology'] = self.symbology.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workflow
        if self.workflow:
            _dict['workflow'] = self.workflow.to_dict()
        # set to None if symbology (nullable) is None
        # and __fields_set__ contains the field
        if self.symbology is None and "symbology" in self.__fields_set__:
            _dict['symbology'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Layer:
        """Create an instance of Layer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Layer.parse_obj(obj)

        _obj = Layer.parse_obj({
            "description": obj.get("description"),
            "id": ProviderLayerId.from_dict(obj.get("id")) if obj.get("id") is not None else None,
            "metadata": obj.get("metadata"),
            "name": obj.get("name"),
            "properties": obj.get("properties"),
            "symbology": Symbology.from_dict(obj.get("symbology")) if obj.get("symbology") is not None else None,
            "workflow": Workflow.from_dict(obj.get("workflow")) if obj.get("workflow") is not None else None
        })
        return _obj


