# coding: utf-8

"""
    Geo Engine Pro API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from geoengine_openapi_client.models.gdal_meta_data_list_with_type import GdalMetaDataListWithType
from geoengine_openapi_client.models.gdal_meta_data_regular_with_type import GdalMetaDataRegularWithType
from geoengine_openapi_client.models.gdal_meta_data_static_with_type import GdalMetaDataStaticWithType
from geoengine_openapi_client.models.gdal_metadata_net_cdf_cf_with_type import GdalMetadataNetCdfCfWithType
from geoengine_openapi_client.models.mock_meta_data_with_type import MockMetaDataWithType
from geoengine_openapi_client.models.ogr_meta_data_with_type import OgrMetaDataWithType
from typing import Union, Any, List, TYPE_CHECKING
from pydantic import StrictStr, Field

METADATADEFINITION_ONE_OF_SCHEMAS = ["GdalMetaDataListWithType", "GdalMetaDataRegularWithType", "GdalMetaDataStaticWithType", "GdalMetadataNetCdfCfWithType", "MockMetaDataWithType", "OgrMetaDataWithType"]

class MetaDataDefinition(BaseModel):
    """
    MetaDataDefinition
    """
    # data type: MockMetaDataWithType
    oneof_schema_1_validator: Optional[MockMetaDataWithType] = None
    # data type: OgrMetaDataWithType
    oneof_schema_2_validator: Optional[OgrMetaDataWithType] = None
    # data type: GdalMetaDataRegularWithType
    oneof_schema_3_validator: Optional[GdalMetaDataRegularWithType] = None
    # data type: GdalMetaDataStaticWithType
    oneof_schema_4_validator: Optional[GdalMetaDataStaticWithType] = None
    # data type: GdalMetadataNetCdfCfWithType
    oneof_schema_5_validator: Optional[GdalMetadataNetCdfCfWithType] = None
    # data type: GdalMetaDataListWithType
    oneof_schema_6_validator: Optional[GdalMetaDataListWithType] = None
    if TYPE_CHECKING:
        actual_instance: Union[GdalMetaDataListWithType, GdalMetaDataRegularWithType, GdalMetaDataStaticWithType, GdalMetadataNetCdfCfWithType, MockMetaDataWithType, OgrMetaDataWithType]
    else:
        actual_instance: Any
    one_of_schemas: List[str] = Field(METADATADEFINITION_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    discriminator_value_class_map = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = MetaDataDefinition.construct()
        error_messages = []
        match = 0
        # validate data type: MockMetaDataWithType
        if not isinstance(v, MockMetaDataWithType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MockMetaDataWithType`")
        else:
            match += 1
        # validate data type: OgrMetaDataWithType
        if not isinstance(v, OgrMetaDataWithType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `OgrMetaDataWithType`")
        else:
            match += 1
        # validate data type: GdalMetaDataRegularWithType
        if not isinstance(v, GdalMetaDataRegularWithType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GdalMetaDataRegularWithType`")
        else:
            match += 1
        # validate data type: GdalMetaDataStaticWithType
        if not isinstance(v, GdalMetaDataStaticWithType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GdalMetaDataStaticWithType`")
        else:
            match += 1
        # validate data type: GdalMetadataNetCdfCfWithType
        if not isinstance(v, GdalMetadataNetCdfCfWithType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GdalMetadataNetCdfCfWithType`")
        else:
            match += 1
        # validate data type: GdalMetaDataListWithType
        if not isinstance(v, GdalMetaDataListWithType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GdalMetaDataListWithType`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in MetaDataDefinition with oneOf schemas: GdalMetaDataListWithType, GdalMetaDataRegularWithType, GdalMetaDataStaticWithType, GdalMetadataNetCdfCfWithType, MockMetaDataWithType, OgrMetaDataWithType. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in MetaDataDefinition with oneOf schemas: GdalMetaDataListWithType, GdalMetaDataRegularWithType, GdalMetaDataStaticWithType, GdalMetadataNetCdfCfWithType, MockMetaDataWithType, OgrMetaDataWithType. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> MetaDataDefinition:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> MetaDataDefinition:
        """Returns the object represented by the json string"""
        instance = MetaDataDefinition.construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("type")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `type` in the input.")

        # check if data type is `GdalMetaDataListWithType`
        if _data_type == "GdalMetaDataList":
            instance.actual_instance = GdalMetaDataListWithType.from_json(json_str)
            return instance

        # check if data type is `GdalMetaDataListWithType`
        if _data_type == "GdalMetaDataListWithType":
            instance.actual_instance = GdalMetaDataListWithType.from_json(json_str)
            return instance

        # check if data type is `GdalMetaDataRegularWithType`
        if _data_type == "GdalMetaDataRegular":
            instance.actual_instance = GdalMetaDataRegularWithType.from_json(json_str)
            return instance

        # check if data type is `GdalMetaDataRegularWithType`
        if _data_type == "GdalMetaDataRegularWithType":
            instance.actual_instance = GdalMetaDataRegularWithType.from_json(json_str)
            return instance

        # check if data type is `GdalMetaDataStaticWithType`
        if _data_type == "GdalMetaDataStaticWithType":
            instance.actual_instance = GdalMetaDataStaticWithType.from_json(json_str)
            return instance

        # check if data type is `GdalMetadataNetCdfCfWithType`
        if _data_type == "GdalMetadataNetCdfCf":
            instance.actual_instance = GdalMetadataNetCdfCfWithType.from_json(json_str)
            return instance

        # check if data type is `GdalMetadataNetCdfCfWithType`
        if _data_type == "GdalMetadataNetCdfCfWithType":
            instance.actual_instance = GdalMetadataNetCdfCfWithType.from_json(json_str)
            return instance

        # check if data type is `GdalMetaDataStaticWithType`
        if _data_type == "GdalStatic":
            instance.actual_instance = GdalMetaDataStaticWithType.from_json(json_str)
            return instance

        # check if data type is `MockMetaDataWithType`
        if _data_type == "MockMetaData":
            instance.actual_instance = MockMetaDataWithType.from_json(json_str)
            return instance

        # check if data type is `MockMetaDataWithType`
        if _data_type == "MockMetaDataWithType":
            instance.actual_instance = MockMetaDataWithType.from_json(json_str)
            return instance

        # check if data type is `OgrMetaDataWithType`
        if _data_type == "OgrMetaData":
            instance.actual_instance = OgrMetaDataWithType.from_json(json_str)
            return instance

        # check if data type is `OgrMetaDataWithType`
        if _data_type == "OgrMetaDataWithType":
            instance.actual_instance = OgrMetaDataWithType.from_json(json_str)
            return instance

        # deserialize data into MockMetaDataWithType
        try:
            instance.actual_instance = MockMetaDataWithType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into OgrMetaDataWithType
        try:
            instance.actual_instance = OgrMetaDataWithType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into GdalMetaDataRegularWithType
        try:
            instance.actual_instance = GdalMetaDataRegularWithType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into GdalMetaDataStaticWithType
        try:
            instance.actual_instance = GdalMetaDataStaticWithType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into GdalMetadataNetCdfCfWithType
        try:
            instance.actual_instance = GdalMetadataNetCdfCfWithType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into GdalMetaDataListWithType
        try:
            instance.actual_instance = GdalMetaDataListWithType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into MetaDataDefinition with oneOf schemas: GdalMetaDataListWithType, GdalMetaDataRegularWithType, GdalMetaDataStaticWithType, GdalMetadataNetCdfCfWithType, MockMetaDataWithType, OgrMetaDataWithType. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into MetaDataDefinition with oneOf schemas: GdalMetaDataListWithType, GdalMetaDataRegularWithType, GdalMetaDataStaticWithType, GdalMetadataNetCdfCfWithType, MockMetaDataWithType, OgrMetaDataWithType. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())


