# coding: utf-8

"""
    Geo Engine Pro API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictStr, validator
from geoengine_openapi_client.models.ogr_source_dataset import OgrSourceDataset
from geoengine_openapi_client.models.vector_result_descriptor import VectorResultDescriptor

class OgrMetaDataWithType(BaseModel):
    """
    OgrMetaDataWithType
    """
    loading_info: OgrSourceDataset = Field(..., alias="loadingInfo")
    result_descriptor: VectorResultDescriptor = Field(..., alias="resultDescriptor")
    type: StrictStr = Field(...)
    __properties = ["loadingInfo", "resultDescriptor", "type"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('OgrMetaData'):
            raise ValueError("must be one of enum values ('OgrMetaData')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OgrMetaDataWithType:
        """Create an instance of OgrMetaDataWithType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of loading_info
        if self.loading_info:
            _dict['loadingInfo'] = self.loading_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of result_descriptor
        if self.result_descriptor:
            _dict['resultDescriptor'] = self.result_descriptor.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OgrMetaDataWithType:
        """Create an instance of OgrMetaDataWithType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OgrMetaDataWithType.parse_obj(obj)

        _obj = OgrMetaDataWithType.parse_obj({
            "loading_info": OgrSourceDataset.from_dict(obj.get("loadingInfo")) if obj.get("loadingInfo") is not None else None,
            "result_descriptor": VectorResultDescriptor.from_dict(obj.get("resultDescriptor")) if obj.get("resultDescriptor") is not None else None,
            "type": obj.get("type")
        })
        return _obj


