# coding: utf-8

"""
    Geo Engine Pro API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from geoengine_openapi_client.models.format_specifics import FormatSpecifics

class OgrSourceColumnSpec(BaseModel):
    """
    OgrSourceColumnSpec
    """
    bool: Optional[conlist(StrictStr)] = None
    datetime: Optional[conlist(StrictStr)] = None
    float: Optional[conlist(StrictStr)] = None
    format_specifics: Optional[FormatSpecifics] = Field(None, alias="formatSpecifics")
    int: Optional[conlist(StrictStr)] = None
    rename: Optional[Dict[str, StrictStr]] = None
    text: Optional[conlist(StrictStr)] = None
    x: StrictStr = Field(...)
    y: Optional[StrictStr] = None
    __properties = ["bool", "datetime", "float", "formatSpecifics", "int", "rename", "text", "x", "y"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OgrSourceColumnSpec:
        """Create an instance of OgrSourceColumnSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of format_specifics
        if self.format_specifics:
            _dict['formatSpecifics'] = self.format_specifics.to_dict()
        # set to None if format_specifics (nullable) is None
        # and __fields_set__ contains the field
        if self.format_specifics is None and "format_specifics" in self.__fields_set__:
            _dict['formatSpecifics'] = None

        # set to None if rename (nullable) is None
        # and __fields_set__ contains the field
        if self.rename is None and "rename" in self.__fields_set__:
            _dict['rename'] = None

        # set to None if y (nullable) is None
        # and __fields_set__ contains the field
        if self.y is None and "y" in self.__fields_set__:
            _dict['y'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OgrSourceColumnSpec:
        """Create an instance of OgrSourceColumnSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OgrSourceColumnSpec.parse_obj(obj)

        _obj = OgrSourceColumnSpec.parse_obj({
            "bool": obj.get("bool"),
            "datetime": obj.get("datetime"),
            "float": obj.get("float"),
            "format_specifics": FormatSpecifics.from_dict(obj.get("formatSpecifics")) if obj.get("formatSpecifics") is not None else None,
            "int": obj.get("int"),
            "rename": obj.get("rename"),
            "text": obj.get("text"),
            "x": obj.get("x"),
            "y": obj.get("y")
        })
        return _obj


