# coding: utf-8

"""
    Geo Engine Pro API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictStr, conlist
from geoengine_openapi_client.models.plot import Plot
from geoengine_openapi_client.models.project_layer import ProjectLayer
from geoengine_openapi_client.models.project_version import ProjectVersion
from geoengine_openapi_client.models.st_rectangle import STRectangle
from geoengine_openapi_client.models.time_step import TimeStep

class Project(BaseModel):
    """
    Project
    """
    bounds: STRectangle = Field(...)
    description: StrictStr = Field(...)
    id: StrictStr = Field(...)
    layers: conlist(ProjectLayer) = Field(...)
    name: StrictStr = Field(...)
    plots: conlist(Plot) = Field(...)
    time_step: TimeStep = Field(..., alias="timeStep")
    version: ProjectVersion = Field(...)
    __properties = ["bounds", "description", "id", "layers", "name", "plots", "timeStep", "version"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Project:
        """Create an instance of Project from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of bounds
        if self.bounds:
            _dict['bounds'] = self.bounds.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in layers (list)
        _items = []
        if self.layers:
            for _item in self.layers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['layers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in plots (list)
        _items = []
        if self.plots:
            for _item in self.plots:
                if _item:
                    _items.append(_item.to_dict())
            _dict['plots'] = _items
        # override the default output from pydantic by calling `to_dict()` of time_step
        if self.time_step:
            _dict['timeStep'] = self.time_step.to_dict()
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Project:
        """Create an instance of Project from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Project.parse_obj(obj)

        _obj = Project.parse_obj({
            "bounds": STRectangle.from_dict(obj.get("bounds")) if obj.get("bounds") is not None else None,
            "description": obj.get("description"),
            "id": obj.get("id"),
            "layers": [ProjectLayer.from_dict(_item) for _item in obj.get("layers")] if obj.get("layers") is not None else None,
            "name": obj.get("name"),
            "plots": [Plot.from_dict(_item) for _item in obj.get("plots")] if obj.get("plots") is not None else None,
            "time_step": TimeStep.from_dict(obj.get("timeStep")) if obj.get("timeStep") is not None else None,
            "version": ProjectVersion.from_dict(obj.get("version")) if obj.get("version") is not None else None
        })
        return _obj


