# coding: utf-8

"""
    Geo Engine Pro API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from geoengine_openapi_client.models.dataset_id_resource_id import DatasetIdResourceId
from geoengine_openapi_client.models.layer_collection_resource_id import LayerCollectionResourceId
from geoengine_openapi_client.models.layer_resource_id import LayerResourceId
from geoengine_openapi_client.models.model_id_resource_id import ModelIdResourceId
from geoengine_openapi_client.models.project_resource_id import ProjectResourceId
from typing import Union, Any, List, TYPE_CHECKING
from pydantic import StrictStr, Field

RESOURCEID_ONE_OF_SCHEMAS = ["DatasetIdResourceId", "LayerCollectionResourceId", "LayerResourceId", "ModelIdResourceId", "ProjectResourceId"]

class ResourceId(BaseModel):
    """
    ResourceId
    """
    # data type: LayerResourceId
    oneof_schema_1_validator: Optional[LayerResourceId] = None
    # data type: LayerCollectionResourceId
    oneof_schema_2_validator: Optional[LayerCollectionResourceId] = None
    # data type: ProjectResourceId
    oneof_schema_3_validator: Optional[ProjectResourceId] = None
    # data type: DatasetIdResourceId
    oneof_schema_4_validator: Optional[DatasetIdResourceId] = None
    # data type: ModelIdResourceId
    oneof_schema_5_validator: Optional[ModelIdResourceId] = None
    if TYPE_CHECKING:
        actual_instance: Union[DatasetIdResourceId, LayerCollectionResourceId, LayerResourceId, ModelIdResourceId, ProjectResourceId]
    else:
        actual_instance: Any
    one_of_schemas: List[str] = Field(RESOURCEID_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    discriminator_value_class_map = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ResourceId.construct()
        error_messages = []
        match = 0
        # validate data type: LayerResourceId
        if not isinstance(v, LayerResourceId):
            error_messages.append(f"Error! Input type `{type(v)}` is not `LayerResourceId`")
        else:
            match += 1
        # validate data type: LayerCollectionResourceId
        if not isinstance(v, LayerCollectionResourceId):
            error_messages.append(f"Error! Input type `{type(v)}` is not `LayerCollectionResourceId`")
        else:
            match += 1
        # validate data type: ProjectResourceId
        if not isinstance(v, ProjectResourceId):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ProjectResourceId`")
        else:
            match += 1
        # validate data type: DatasetIdResourceId
        if not isinstance(v, DatasetIdResourceId):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DatasetIdResourceId`")
        else:
            match += 1
        # validate data type: ModelIdResourceId
        if not isinstance(v, ModelIdResourceId):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ModelIdResourceId`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ResourceId with oneOf schemas: DatasetIdResourceId, LayerCollectionResourceId, LayerResourceId, ModelIdResourceId, ProjectResourceId. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ResourceId with oneOf schemas: DatasetIdResourceId, LayerCollectionResourceId, LayerResourceId, ModelIdResourceId, ProjectResourceId. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> ResourceId:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> ResourceId:
        """Returns the object represented by the json string"""
        instance = ResourceId.construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("type")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `type` in the input.")

        # check if data type is `DatasetIdResourceId`
        if _data_type == "DatasetId":
            instance.actual_instance = DatasetIdResourceId.from_json(json_str)
            return instance

        # check if data type is `DatasetIdResourceId`
        if _data_type == "DatasetIdResourceId":
            instance.actual_instance = DatasetIdResourceId.from_json(json_str)
            return instance

        # check if data type is `LayerResourceId`
        if _data_type == "Layer":
            instance.actual_instance = LayerResourceId.from_json(json_str)
            return instance

        # check if data type is `LayerCollectionResourceId`
        if _data_type == "LayerCollection":
            instance.actual_instance = LayerCollectionResourceId.from_json(json_str)
            return instance

        # check if data type is `LayerCollectionResourceId`
        if _data_type == "LayerCollectionResourceId":
            instance.actual_instance = LayerCollectionResourceId.from_json(json_str)
            return instance

        # check if data type is `LayerResourceId`
        if _data_type == "LayerResourceId":
            instance.actual_instance = LayerResourceId.from_json(json_str)
            return instance

        # check if data type is `ModelIdResourceId`
        if _data_type == "ModelId":
            instance.actual_instance = ModelIdResourceId.from_json(json_str)
            return instance

        # check if data type is `ModelIdResourceId`
        if _data_type == "ModelIdResourceId":
            instance.actual_instance = ModelIdResourceId.from_json(json_str)
            return instance

        # check if data type is `ProjectResourceId`
        if _data_type == "Project":
            instance.actual_instance = ProjectResourceId.from_json(json_str)
            return instance

        # check if data type is `ProjectResourceId`
        if _data_type == "ProjectResourceId":
            instance.actual_instance = ProjectResourceId.from_json(json_str)
            return instance

        # deserialize data into LayerResourceId
        try:
            instance.actual_instance = LayerResourceId.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into LayerCollectionResourceId
        try:
            instance.actual_instance = LayerCollectionResourceId.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ProjectResourceId
        try:
            instance.actual_instance = ProjectResourceId.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DatasetIdResourceId
        try:
            instance.actual_instance = DatasetIdResourceId.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ModelIdResourceId
        try:
            instance.actual_instance = ModelIdResourceId.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ResourceId with oneOf schemas: DatasetIdResourceId, LayerCollectionResourceId, LayerResourceId, ModelIdResourceId, ProjectResourceId. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ResourceId with oneOf schemas: DatasetIdResourceId, LayerCollectionResourceId, LayerResourceId, ModelIdResourceId, ProjectResourceId. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())


