# coding: utf-8

"""
    Geo Engine Pro API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from geoengine_openapi_client.models.search_types import SearchTypes

class SearchCapabilities(BaseModel):
    """
    SearchCapabilities
    """
    autocomplete: StrictBool = Field(...)
    filters: Optional[conlist(StrictStr)] = None
    search_types: SearchTypes = Field(..., alias="searchTypes")
    __properties = ["autocomplete", "filters", "searchTypes"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SearchCapabilities:
        """Create an instance of SearchCapabilities from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of search_types
        if self.search_types:
            _dict['searchTypes'] = self.search_types.to_dict()
        # set to None if filters (nullable) is None
        # and __fields_set__ contains the field
        if self.filters is None and "filters" in self.__fields_set__:
            _dict['filters'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SearchCapabilities:
        """Create an instance of SearchCapabilities from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SearchCapabilities.parse_obj(obj)

        _obj = SearchCapabilities.parse_obj({
            "autocomplete": obj.get("autocomplete"),
            "filters": obj.get("filters"),
            "search_types": SearchTypes.from_dict(obj.get("searchTypes")) if obj.get("searchTypes") is not None else None
        })
        return _obj


