# coding: utf-8

"""
    Geo Engine Pro API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from geoengine_openapi_client.models.axis_order import AxisOrder
from geoengine_openapi_client.models.bounding_box2_d import BoundingBox2D

class SpatialReferenceSpecification(BaseModel):
    """
    The specification of a spatial reference, where extent and axis labels are given in natural order (x, y) = (east, north)  # noqa: E501
    """
    axis_labels: Optional[conlist(StrictStr, max_items=2, min_items=2)] = Field(None, alias="axisLabels")
    axis_order: Optional[AxisOrder] = Field(None, alias="axisOrder")
    extent: BoundingBox2D = Field(...)
    name: StrictStr = Field(...)
    proj_string: StrictStr = Field(..., alias="projString")
    spatial_reference: StrictStr = Field(..., alias="spatialReference")
    __properties = ["axisLabels", "axisOrder", "extent", "name", "projString", "spatialReference"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SpatialReferenceSpecification:
        """Create an instance of SpatialReferenceSpecification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of extent
        if self.extent:
            _dict['extent'] = self.extent.to_dict()
        # set to None if axis_labels (nullable) is None
        # and __fields_set__ contains the field
        if self.axis_labels is None and "axis_labels" in self.__fields_set__:
            _dict['axisLabels'] = None

        # set to None if axis_order (nullable) is None
        # and __fields_set__ contains the field
        if self.axis_order is None and "axis_order" in self.__fields_set__:
            _dict['axisOrder'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SpatialReferenceSpecification:
        """Create an instance of SpatialReferenceSpecification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SpatialReferenceSpecification.parse_obj(obj)

        _obj = SpatialReferenceSpecification.parse_obj({
            "axis_labels": obj.get("axisLabels"),
            "axis_order": obj.get("axisOrder"),
            "extent": BoundingBox2D.from_dict(obj.get("extent")) if obj.get("extent") is not None else None,
            "name": obj.get("name"),
            "proj_string": obj.get("projString"),
            "spatial_reference": obj.get("spatialReference")
        })
        return _obj


