# coding: utf-8

"""
    Geo Engine Pro API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from geoengine_openapi_client.models.plot_result_descriptor_with_type import PlotResultDescriptorWithType
from geoengine_openapi_client.models.raster_result_descriptor_with_type import RasterResultDescriptorWithType
from geoengine_openapi_client.models.vector_result_descriptor_with_type import VectorResultDescriptorWithType
from typing import Union, Any, List, TYPE_CHECKING
from pydantic import StrictStr, Field

TYPEDRESULTDESCRIPTOR_ONE_OF_SCHEMAS = ["PlotResultDescriptorWithType", "RasterResultDescriptorWithType", "VectorResultDescriptorWithType"]

class TypedResultDescriptor(BaseModel):
    """
    TypedResultDescriptor
    """
    # data type: PlotResultDescriptorWithType
    oneof_schema_1_validator: Optional[PlotResultDescriptorWithType] = None
    # data type: RasterResultDescriptorWithType
    oneof_schema_2_validator: Optional[RasterResultDescriptorWithType] = None
    # data type: VectorResultDescriptorWithType
    oneof_schema_3_validator: Optional[VectorResultDescriptorWithType] = None
    if TYPE_CHECKING:
        actual_instance: Union[PlotResultDescriptorWithType, RasterResultDescriptorWithType, VectorResultDescriptorWithType]
    else:
        actual_instance: Any
    one_of_schemas: List[str] = Field(TYPEDRESULTDESCRIPTOR_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    discriminator_value_class_map = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = TypedResultDescriptor.construct()
        error_messages = []
        match = 0
        # validate data type: PlotResultDescriptorWithType
        if not isinstance(v, PlotResultDescriptorWithType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PlotResultDescriptorWithType`")
        else:
            match += 1
        # validate data type: RasterResultDescriptorWithType
        if not isinstance(v, RasterResultDescriptorWithType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RasterResultDescriptorWithType`")
        else:
            match += 1
        # validate data type: VectorResultDescriptorWithType
        if not isinstance(v, VectorResultDescriptorWithType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `VectorResultDescriptorWithType`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in TypedResultDescriptor with oneOf schemas: PlotResultDescriptorWithType, RasterResultDescriptorWithType, VectorResultDescriptorWithType. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in TypedResultDescriptor with oneOf schemas: PlotResultDescriptorWithType, RasterResultDescriptorWithType, VectorResultDescriptorWithType. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> TypedResultDescriptor:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> TypedResultDescriptor:
        """Returns the object represented by the json string"""
        instance = TypedResultDescriptor.construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("type")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `type` in the input.")

        # check if data type is `PlotResultDescriptorWithType`
        if _data_type == "PlotResultDescriptorWithType":
            instance.actual_instance = PlotResultDescriptorWithType.from_json(json_str)
            return instance

        # check if data type is `RasterResultDescriptorWithType`
        if _data_type == "RasterResultDescriptorWithType":
            instance.actual_instance = RasterResultDescriptorWithType.from_json(json_str)
            return instance

        # check if data type is `VectorResultDescriptorWithType`
        if _data_type == "VectorResultDescriptorWithType":
            instance.actual_instance = VectorResultDescriptorWithType.from_json(json_str)
            return instance

        # check if data type is `PlotResultDescriptorWithType`
        if _data_type == "plot":
            instance.actual_instance = PlotResultDescriptorWithType.from_json(json_str)
            return instance

        # check if data type is `RasterResultDescriptorWithType`
        if _data_type == "raster":
            instance.actual_instance = RasterResultDescriptorWithType.from_json(json_str)
            return instance

        # check if data type is `VectorResultDescriptorWithType`
        if _data_type == "vector":
            instance.actual_instance = VectorResultDescriptorWithType.from_json(json_str)
            return instance

        # deserialize data into PlotResultDescriptorWithType
        try:
            instance.actual_instance = PlotResultDescriptorWithType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RasterResultDescriptorWithType
        try:
            instance.actual_instance = RasterResultDescriptorWithType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into VectorResultDescriptorWithType
        try:
            instance.actual_instance = VectorResultDescriptorWithType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into TypedResultDescriptor with oneOf schemas: PlotResultDescriptorWithType, RasterResultDescriptorWithType, VectorResultDescriptorWithType. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into TypedResultDescriptor with oneOf schemas: PlotResultDescriptorWithType, RasterResultDescriptorWithType, VectorResultDescriptorWithType. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())


