# coding: utf-8

"""
    Geo Engine Pro API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.8.0
    Contact: dev@geoengine.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from geoengine_openapi_client.models.layer_update import LayerUpdate
from geoengine_openapi_client.models.plot_update import PlotUpdate
from geoengine_openapi_client.models.st_rectangle import STRectangle
from geoengine_openapi_client.models.time_step import TimeStep

class UpdateProject(BaseModel):
    """
    UpdateProject
    """
    bounds: Optional[STRectangle] = None
    description: Optional[StrictStr] = None
    id: StrictStr = Field(...)
    layers: Optional[conlist(LayerUpdate)] = None
    name: Optional[StrictStr] = None
    plots: Optional[conlist(PlotUpdate)] = None
    time_step: Optional[TimeStep] = Field(None, alias="timeStep")
    __properties = ["bounds", "description", "id", "layers", "name", "plots", "timeStep"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateProject:
        """Create an instance of UpdateProject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of bounds
        if self.bounds:
            _dict['bounds'] = self.bounds.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in layers (list)
        _items = []
        if self.layers:
            for _item in self.layers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['layers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in plots (list)
        _items = []
        if self.plots:
            for _item in self.plots:
                if _item:
                    _items.append(_item.to_dict())
            _dict['plots'] = _items
        # override the default output from pydantic by calling `to_dict()` of time_step
        if self.time_step:
            _dict['timeStep'] = self.time_step.to_dict()
        # set to None if bounds (nullable) is None
        # and __fields_set__ contains the field
        if self.bounds is None and "bounds" in self.__fields_set__:
            _dict['bounds'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if layers (nullable) is None
        # and __fields_set__ contains the field
        if self.layers is None and "layers" in self.__fields_set__:
            _dict['layers'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if plots (nullable) is None
        # and __fields_set__ contains the field
        if self.plots is None and "plots" in self.__fields_set__:
            _dict['plots'] = None

        # set to None if time_step (nullable) is None
        # and __fields_set__ contains the field
        if self.time_step is None and "time_step" in self.__fields_set__:
            _dict['timeStep'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateProject:
        """Create an instance of UpdateProject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateProject.parse_obj(obj)

        _obj = UpdateProject.parse_obj({
            "bounds": STRectangle.from_dict(obj.get("bounds")) if obj.get("bounds") is not None else None,
            "description": obj.get("description"),
            "id": obj.get("id"),
            "layers": [LayerUpdate.from_dict(_item) for _item in obj.get("layers")] if obj.get("layers") is not None else None,
            "name": obj.get("name"),
            "plots": [PlotUpdate.from_dict(_item) for _item in obj.get("plots")] if obj.get("plots") is not None else None,
            "time_step": TimeStep.from_dict(obj.get("timeStep")) if obj.get("timeStep") is not None else None
        })
        return _obj


