"""
    EVENTS AND TRANSCRIPTS API

    <p>The Calendar Events API provides access to FactSet’s Event Calendar data alongside business logic that allows users to replicate views and functionality consistent with the experience provided by the Workstation. This API provides the ability to pull Event Calendar data based on specific filters.</p> <p>Events Audio API provides access to historical as well as the latest audio recordings of various company events covered by FactSet. The events include, but are not limited to: earnings calls, conferences, and investor days. This API also provides relevant metadata such as timestamps and identifiers around each audio file.</p> <p>The  Near Real-time Transcripts API enables access to Near Real-time Transcripts provided by CallStreet to time-sensitive clients. This API also provides the relevant speaker metadata along with their confidence scores. This data caters to quant clients interested in building machine learning models. Clients can leverage this API to perform sentiment analysis through natural language processing or machine learning. It can also be used to complement analysis using FactSet's transcripts service.</p> <p>Transcripts API provides conference call transcripts for companies' publicly held conference calls and a wealth of information regarding upcoming corporate events, such as conference call date and time, phone number and password, type of conference call, and important company investor relations contact information.</p>    # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.EventsandTranscripts.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.EventsandTranscripts.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.EventsandTranscripts.exceptions import ApiException
from fds.sdk.EventsandTranscripts.model.error import Error
from fds.sdk.EventsandTranscripts.model.events_audio_daily import EventsAudioDaily
from fds.sdk.EventsandTranscripts.model.events_audio_daily_file_name import EventsAudioDailyFileName
from fds.sdk.EventsandTranscripts.model.events_audio_daily_ids import EventsAudioDailyIds
from fds.sdk.EventsandTranscripts.model.events_audio_history import EventsAudioHistory





class EventsAudioApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.get_docs_distributor_audio_v1_history_files_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (EventsAudioHistory,), 400: (Error,), 401: (Error,), 403: (Error,), 500: (Error,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/audio/history',
                'operation_id': 'get_docs_distributor_audio_v1_history_files',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'year',
                    'trimmed',
                ],
                'required': [
                    'year',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'year':
                        (int,),
                    'trimmed':
                        (bool,),
                },
                'attribute_map': {
                    'year': 'year',
                    'trimmed': 'trimmed',
                },
                'location_map': {
                    'year': 'query',
                    'trimmed': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_docs_distributor_audio_v1_list_files_date_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (EventsAudioDaily,), 400: (Error,), 401: (Error,), 403: (Error,), 500: (Error,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/audio/by-date',
                'operation_id': 'get_docs_distributor_audio_v1_list_files_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'start_date_relative',
                    'end_date_relative',
                    'source_code',
                    'ids',
                    'trimmed',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'source_code',
                    'sort',
                ],
                'validation': [
                    'sort',
                    'pagination_limit',
                ]
            },
            root_map={
                'validations': {
                    ('sort',): {

                        'max_items': 1,
                    },
                    ('pagination_limit',): {

                        'inclusive_maximum': 500,
                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                    ('source_code',): {

                        "PHONE": "Phone",
                        "WEBCAST": "Webcast",
                        "VENDOR": "Vendor",
                        "WEBCASTREPLAY": "WebcastReplay",
                        "FLASH": "Flash",
                        "REPLAY": "Replay"
                    },
                    ('sort',): {

                        "STARTDATE": "startDate",
                        "-STARTDATE": "-startDate"
                    },
                },
                'openapi_types': {
                    'start_date':
                        (date,),
                    'end_date':
                        (date,),
                    'start_date_relative':
                        (int,),
                    'end_date_relative':
                        (int,),
                    'source_code':
                        (str,),
                    'ids':
                        ([str],),
                    'trimmed':
                        (bool,),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'start_date_relative': 'startDateRelative',
                    'end_date_relative': 'endDateRelative',
                    'source_code': 'sourceCode',
                    'ids': 'ids',
                    'trimmed': 'trimmed',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'start_date_relative': 'query',
                    'end_date_relative': 'query',
                    'source_code': 'query',
                    'ids': 'query',
                    'trimmed': 'query',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                    'ids': 'csv',
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_docs_distributor_audio_v1_list_files_file_name_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (EventsAudioDailyFileName,), 400: (Error,), 401: (Error,), 403: (Error,), 500: (Error,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/audio/by-file-name',
                'operation_id': 'get_docs_distributor_audio_v1_list_files_file_name',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'file_name',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'file_name':
                        (str,),
                },
                'attribute_map': {
                    'file_name': 'fileName',
                },
                'location_map': {
                    'file_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_docs_distributor_audio_v1_list_files_ids_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (EventsAudioDailyIds,), 400: (Error,), 401: (Error,), 403: (Error,), 500: (Error,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/audio/by-ids',
                'operation_id': 'get_docs_distributor_audio_v1_list_files_ids',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'report_id',
                    'audio_source_id',
                    'trimmed',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'report_id':
                        (int,),
                    'audio_source_id':
                        (int,),
                    'trimmed':
                        (bool,),
                },
                'attribute_map': {
                    'report_id': 'reportId',
                    'audio_source_id': 'audioSourceId',
                    'trimmed': 'trimmed',
                },
                'location_map': {
                    'report_id': 'query',
                    'audio_source_id': 'query',
                    'trimmed': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_docs_distributor_audio_v1_list_files_upload_time_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (EventsAudioDaily,), 400: (Error,), 401: (Error,), 403: (Error,), 500: (Error,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/audio/by-upload-time',
                'operation_id': 'get_docs_distributor_audio_v1_list_files_upload_time',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'upload_time',
                    'source_code',
                    'ids',
                    'trimmed',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'source_code',
                    'sort',
                ],
                'validation': [
                    'upload_time',
                    'sort',
                    'pagination_limit',
                ]
            },
            root_map={
                'validations': {
                    ('upload_time',): {

                        'inclusive_maximum': -1,
                        'inclusive_minimum': -168,
                    },
                    ('sort',): {

                        'max_items': 1,
                    },
                    ('pagination_limit',): {

                        'inclusive_maximum': 500,
                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                    ('source_code',): {

                        "PHONE": "Phone",
                        "WEBCAST": "Webcast",
                        "VENDOR": "Vendor",
                        "WEBCASTREPLAY": "WebcastReplay",
                        "FLASH": "Flash",
                        "REPLAY": "Replay"
                    },
                    ('sort',): {

                        "UPLOADTIME": "uploadTime",
                        "-UPLOADTIME": "-uploadTime"
                    },
                },
                'openapi_types': {
                    'upload_time':
                        (int,),
                    'source_code':
                        (str,),
                    'ids':
                        ([str],),
                    'trimmed':
                        (bool,),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'upload_time': 'uploadTime',
                    'source_code': 'sourceCode',
                    'ids': 'ids',
                    'trimmed': 'trimmed',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'upload_time': 'query',
                    'source_code': 'query',
                    'ids': 'query',
                    'trimmed': 'query',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                    'ids': 'csv',
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )


    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")


    def get_docs_distributor_audio_v1_history_files(
        self,
        year,
        **kwargs
    ) -> EventsAudioHistory:
        """Retrieve historical audio recordings and related metadata within FactSet coverage.  # noqa: E501

         This endpoint retrieves an object containing a pre-signed URL from which an archive of all audio data for a specified year can be downloaded.  * Returns **untrimmed** historical audio recordings, which include complete audio files such as intro music & non-speaking portions, and related metadata dating back from May 10, 2011 to Sep 30, 2022.  * Returns **trimmed** historical audio recordings, which are audio files with the non-speaking portions removed, and related metadata dating back from May 10, 2011 to Dec 31, 2022.   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            year (int): Specifies the year for which the historical audio recordings and related metadata are to be retrieved. 

        Keyword Args:
            trimmed (bool): Specifies if trimmed/untrimmed historical audio recordings should be returned.. [optional] if omitted the server will use the default value of False
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EventsAudioHistory
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['year'] = \
            year
        return self.get_docs_distributor_audio_v1_history_files_endpoint.call_with_http_info(**kwargs)

    def get_docs_distributor_audio_v1_history_files_with_http_info(
        self,
        year,
        **kwargs
    ) -> typing.Tuple[EventsAudioHistory, int, typing.MutableMapping]:
        """Retrieve historical audio recordings and related metadata within FactSet coverage.  # noqa: E501

         This endpoint retrieves an object containing a pre-signed URL from which an archive of all audio data for a specified year can be downloaded.  * Returns **untrimmed** historical audio recordings, which include complete audio files such as intro music & non-speaking portions, and related metadata dating back from May 10, 2011 to Sep 30, 2022.  * Returns **trimmed** historical audio recordings, which are audio files with the non-speaking portions removed, and related metadata dating back from May 10, 2011 to Dec 31, 2022.   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            year (int): Specifies the year for which the historical audio recordings and related metadata are to be retrieved. 

        Keyword Args:
            trimmed (bool): Specifies if trimmed/untrimmed historical audio recordings should be returned.. [optional] if omitted the server will use the default value of False
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EventsAudioHistory
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['year'] = \
            year
        return self.get_docs_distributor_audio_v1_history_files_endpoint.call_with_http_info(**kwargs)

    def get_docs_distributor_audio_v1_history_files_async(
        self,
        year,
        **kwargs
    ) -> "ApplyResult[EventsAudioHistory]":
        """Retrieve historical audio recordings and related metadata within FactSet coverage.  # noqa: E501

         This endpoint retrieves an object containing a pre-signed URL from which an archive of all audio data for a specified year can be downloaded.  * Returns **untrimmed** historical audio recordings, which include complete audio files such as intro music & non-speaking portions, and related metadata dating back from May 10, 2011 to Sep 30, 2022.  * Returns **trimmed** historical audio recordings, which are audio files with the non-speaking portions removed, and related metadata dating back from May 10, 2011 to Dec 31, 2022.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            year (int): Specifies the year for which the historical audio recordings and related metadata are to be retrieved. 

        Keyword Args:
            trimmed (bool): Specifies if trimmed/untrimmed historical audio recordings should be returned.. [optional] if omitted the server will use the default value of False
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[EventsAudioHistory]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['year'] = \
            year
        return self.get_docs_distributor_audio_v1_history_files_endpoint.call_with_http_info(**kwargs)

    def get_docs_distributor_audio_v1_history_files_with_http_info_async(
        self,
        year,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[EventsAudioHistory, int, typing.MutableMapping]]":
        """Retrieve historical audio recordings and related metadata within FactSet coverage.  # noqa: E501

         This endpoint retrieves an object containing a pre-signed URL from which an archive of all audio data for a specified year can be downloaded.  * Returns **untrimmed** historical audio recordings, which include complete audio files such as intro music & non-speaking portions, and related metadata dating back from May 10, 2011 to Sep 30, 2022.  * Returns **trimmed** historical audio recordings, which are audio files with the non-speaking portions removed, and related metadata dating back from May 10, 2011 to Dec 31, 2022.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            year (int): Specifies the year for which the historical audio recordings and related metadata are to be retrieved. 

        Keyword Args:
            trimmed (bool): Specifies if trimmed/untrimmed historical audio recordings should be returned.. [optional] if omitted the server will use the default value of False
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(EventsAudioHistory, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['year'] = \
            year
        return self.get_docs_distributor_audio_v1_history_files_endpoint.call_with_http_info(**kwargs)


    def get_docs_distributor_audio_v1_list_files_date(
        self,
        **kwargs
    ) -> EventsAudioDaily:
        """Retrieve latest audio recordings and related metadata within FactSet coverage based on a specific date ranges.  # noqa: E501

        Retrieves the most recent audio recordings based on specified dates and allows filtering through both source code and Ids.  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            start_date (date): The earliest date of the audio file the API should fetch for.  - Format: Should be absolute (YYYY-MM-DD). . [optional]
            end_date (date): The latest date of the audio file the API should fetch for. - Format: Should be absolute (YYYY-MM-DD). . [optional]
            start_date_relative (int): The earliest date of the feed file the API should fetch based on the file timestamp.  - Format: Specify the date using a relative term as an integer: '0' for today, '-1' for yesterday, '-2' for two days ago, and so forth. Negative values are used to represent past dates.   - *Either `startDate` or `startDateRelative` should be used, but not both.* - *If both `startDate` and `startDateRelative` are provided in the same request, the API will return an error.* - *If users provide future dates in requests for `startDate` or `startDateRelative`, the API will not return any data.* . [optional]
            end_date_relative (int): The latest date of the feed file the API should fetch based on the file timestamp.   Format: Specify the date using a relative term as an integer: '0' for today, '-1' for yesterday, '-2' for two days ago, and so forth. Negative values are used to represent past dates.  - Either `endDate` or `endDateRelative` should be used, but not both. - If both `endDate` and `endDateRelative` are provided in the same request, the API will return an error. - If users provide future dates in requests for `endDate` or `endDateRelative`, the API will not return any data. . [optional]
            source_code (str): This parameter filters the results based on Source of the Audio file. Below are the descriptions for each Source Code - * Phone = Originated from phone call * Webcast = Originated from a webcast * Vendor = Received from vendor * WebcastReplay = Replay of a webcast * Flash = Identical to webcast; can merge with \"Webcast\" in the future * Replay = Phone replay. [optional]
            ids ([str]): This parameter filters the results based on ticker-region or Entity ID or the combination of both. A comma is used to separate each identifier. . [optional]
            trimmed (bool): This parameter helps to search for trimmed audio files, with the non-speaking portions removed, and related metadata. The data ranges from May 10, 2011 to Dec 31, 2022. . [optional] if omitted the server will use the default value of False
            sort ([str]): Enables sorting data in ascending or descending chronological order based on startDate. . [optional] if omitted the server will use the default value of ["-startDate"]
            pagination_limit (int): Specifies the number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EventsAudioDaily
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.get_docs_distributor_audio_v1_list_files_date_endpoint.call_with_http_info(**kwargs)

    def get_docs_distributor_audio_v1_list_files_date_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[EventsAudioDaily, int, typing.MutableMapping]:
        """Retrieve latest audio recordings and related metadata within FactSet coverage based on a specific date ranges.  # noqa: E501

        Retrieves the most recent audio recordings based on specified dates and allows filtering through both source code and Ids.  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            start_date (date): The earliest date of the audio file the API should fetch for.  - Format: Should be absolute (YYYY-MM-DD). . [optional]
            end_date (date): The latest date of the audio file the API should fetch for. - Format: Should be absolute (YYYY-MM-DD). . [optional]
            start_date_relative (int): The earliest date of the feed file the API should fetch based on the file timestamp.  - Format: Specify the date using a relative term as an integer: '0' for today, '-1' for yesterday, '-2' for two days ago, and so forth. Negative values are used to represent past dates.   - *Either `startDate` or `startDateRelative` should be used, but not both.* - *If both `startDate` and `startDateRelative` are provided in the same request, the API will return an error.* - *If users provide future dates in requests for `startDate` or `startDateRelative`, the API will not return any data.* . [optional]
            end_date_relative (int): The latest date of the feed file the API should fetch based on the file timestamp.   Format: Specify the date using a relative term as an integer: '0' for today, '-1' for yesterday, '-2' for two days ago, and so forth. Negative values are used to represent past dates.  - Either `endDate` or `endDateRelative` should be used, but not both. - If both `endDate` and `endDateRelative` are provided in the same request, the API will return an error. - If users provide future dates in requests for `endDate` or `endDateRelative`, the API will not return any data. . [optional]
            source_code (str): This parameter filters the results based on Source of the Audio file. Below are the descriptions for each Source Code - * Phone = Originated from phone call * Webcast = Originated from a webcast * Vendor = Received from vendor * WebcastReplay = Replay of a webcast * Flash = Identical to webcast; can merge with \"Webcast\" in the future * Replay = Phone replay. [optional]
            ids ([str]): This parameter filters the results based on ticker-region or Entity ID or the combination of both. A comma is used to separate each identifier. . [optional]
            trimmed (bool): This parameter helps to search for trimmed audio files, with the non-speaking portions removed, and related metadata. The data ranges from May 10, 2011 to Dec 31, 2022. . [optional] if omitted the server will use the default value of False
            sort ([str]): Enables sorting data in ascending or descending chronological order based on startDate. . [optional] if omitted the server will use the default value of ["-startDate"]
            pagination_limit (int): Specifies the number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EventsAudioDaily
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.get_docs_distributor_audio_v1_list_files_date_endpoint.call_with_http_info(**kwargs)

    def get_docs_distributor_audio_v1_list_files_date_async(
        self,
        **kwargs
    ) -> "ApplyResult[EventsAudioDaily]":
        """Retrieve latest audio recordings and related metadata within FactSet coverage based on a specific date ranges.  # noqa: E501

        Retrieves the most recent audio recordings based on specified dates and allows filtering through both source code and Ids.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            start_date (date): The earliest date of the audio file the API should fetch for.  - Format: Should be absolute (YYYY-MM-DD). . [optional]
            end_date (date): The latest date of the audio file the API should fetch for. - Format: Should be absolute (YYYY-MM-DD). . [optional]
            start_date_relative (int): The earliest date of the feed file the API should fetch based on the file timestamp.  - Format: Specify the date using a relative term as an integer: '0' for today, '-1' for yesterday, '-2' for two days ago, and so forth. Negative values are used to represent past dates.   - *Either `startDate` or `startDateRelative` should be used, but not both.* - *If both `startDate` and `startDateRelative` are provided in the same request, the API will return an error.* - *If users provide future dates in requests for `startDate` or `startDateRelative`, the API will not return any data.* . [optional]
            end_date_relative (int): The latest date of the feed file the API should fetch based on the file timestamp.   Format: Specify the date using a relative term as an integer: '0' for today, '-1' for yesterday, '-2' for two days ago, and so forth. Negative values are used to represent past dates.  - Either `endDate` or `endDateRelative` should be used, but not both. - If both `endDate` and `endDateRelative` are provided in the same request, the API will return an error. - If users provide future dates in requests for `endDate` or `endDateRelative`, the API will not return any data. . [optional]
            source_code (str): This parameter filters the results based on Source of the Audio file. Below are the descriptions for each Source Code - * Phone = Originated from phone call * Webcast = Originated from a webcast * Vendor = Received from vendor * WebcastReplay = Replay of a webcast * Flash = Identical to webcast; can merge with \"Webcast\" in the future * Replay = Phone replay. [optional]
            ids ([str]): This parameter filters the results based on ticker-region or Entity ID or the combination of both. A comma is used to separate each identifier. . [optional]
            trimmed (bool): This parameter helps to search for trimmed audio files, with the non-speaking portions removed, and related metadata. The data ranges from May 10, 2011 to Dec 31, 2022. . [optional] if omitted the server will use the default value of False
            sort ([str]): Enables sorting data in ascending or descending chronological order based on startDate. . [optional] if omitted the server will use the default value of ["-startDate"]
            pagination_limit (int): Specifies the number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[EventsAudioDaily]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.get_docs_distributor_audio_v1_list_files_date_endpoint.call_with_http_info(**kwargs)

    def get_docs_distributor_audio_v1_list_files_date_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[EventsAudioDaily, int, typing.MutableMapping]]":
        """Retrieve latest audio recordings and related metadata within FactSet coverage based on a specific date ranges.  # noqa: E501

        Retrieves the most recent audio recordings based on specified dates and allows filtering through both source code and Ids.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            start_date (date): The earliest date of the audio file the API should fetch for.  - Format: Should be absolute (YYYY-MM-DD). . [optional]
            end_date (date): The latest date of the audio file the API should fetch for. - Format: Should be absolute (YYYY-MM-DD). . [optional]
            start_date_relative (int): The earliest date of the feed file the API should fetch based on the file timestamp.  - Format: Specify the date using a relative term as an integer: '0' for today, '-1' for yesterday, '-2' for two days ago, and so forth. Negative values are used to represent past dates.   - *Either `startDate` or `startDateRelative` should be used, but not both.* - *If both `startDate` and `startDateRelative` are provided in the same request, the API will return an error.* - *If users provide future dates in requests for `startDate` or `startDateRelative`, the API will not return any data.* . [optional]
            end_date_relative (int): The latest date of the feed file the API should fetch based on the file timestamp.   Format: Specify the date using a relative term as an integer: '0' for today, '-1' for yesterday, '-2' for two days ago, and so forth. Negative values are used to represent past dates.  - Either `endDate` or `endDateRelative` should be used, but not both. - If both `endDate` and `endDateRelative` are provided in the same request, the API will return an error. - If users provide future dates in requests for `endDate` or `endDateRelative`, the API will not return any data. . [optional]
            source_code (str): This parameter filters the results based on Source of the Audio file. Below are the descriptions for each Source Code - * Phone = Originated from phone call * Webcast = Originated from a webcast * Vendor = Received from vendor * WebcastReplay = Replay of a webcast * Flash = Identical to webcast; can merge with \"Webcast\" in the future * Replay = Phone replay. [optional]
            ids ([str]): This parameter filters the results based on ticker-region or Entity ID or the combination of both. A comma is used to separate each identifier. . [optional]
            trimmed (bool): This parameter helps to search for trimmed audio files, with the non-speaking portions removed, and related metadata. The data ranges from May 10, 2011 to Dec 31, 2022. . [optional] if omitted the server will use the default value of False
            sort ([str]): Enables sorting data in ascending or descending chronological order based on startDate. . [optional] if omitted the server will use the default value of ["-startDate"]
            pagination_limit (int): Specifies the number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(EventsAudioDaily, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.get_docs_distributor_audio_v1_list_files_date_endpoint.call_with_http_info(**kwargs)


    def get_docs_distributor_audio_v1_list_files_file_name(
        self,
        **kwargs
    ) -> EventsAudioDailyFileName:
        """Retrieve latest audio recordings and related metadata within FactSet coverage based on file name.  # noqa: E501

        Retrieves the latest audio recordings corresponding to the provided file name.  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            file_name (str): This parameter is used to filter the data on based on the file name.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EventsAudioDailyFileName
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.get_docs_distributor_audio_v1_list_files_file_name_endpoint.call_with_http_info(**kwargs)

    def get_docs_distributor_audio_v1_list_files_file_name_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[EventsAudioDailyFileName, int, typing.MutableMapping]:
        """Retrieve latest audio recordings and related metadata within FactSet coverage based on file name.  # noqa: E501

        Retrieves the latest audio recordings corresponding to the provided file name.  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            file_name (str): This parameter is used to filter the data on based on the file name.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EventsAudioDailyFileName
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.get_docs_distributor_audio_v1_list_files_file_name_endpoint.call_with_http_info(**kwargs)

    def get_docs_distributor_audio_v1_list_files_file_name_async(
        self,
        **kwargs
    ) -> "ApplyResult[EventsAudioDailyFileName]":
        """Retrieve latest audio recordings and related metadata within FactSet coverage based on file name.  # noqa: E501

        Retrieves the latest audio recordings corresponding to the provided file name.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            file_name (str): This parameter is used to filter the data on based on the file name.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[EventsAudioDailyFileName]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.get_docs_distributor_audio_v1_list_files_file_name_endpoint.call_with_http_info(**kwargs)

    def get_docs_distributor_audio_v1_list_files_file_name_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[EventsAudioDailyFileName, int, typing.MutableMapping]]":
        """Retrieve latest audio recordings and related metadata within FactSet coverage based on file name.  # noqa: E501

        Retrieves the latest audio recordings corresponding to the provided file name.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            file_name (str): This parameter is used to filter the data on based on the file name.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(EventsAudioDailyFileName, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.get_docs_distributor_audio_v1_list_files_file_name_endpoint.call_with_http_info(**kwargs)


    def get_docs_distributor_audio_v1_list_files_ids(
        self,
        **kwargs
    ) -> EventsAudioDailyIds:
        """Retrieve the latest audio recordings along with their corresponding metadata from the FactSet coverage based on specific IDs.  # noqa: E501

        Retrieves the latest audio recordings based on the provided report ID and audio source ID.  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            report_id (int): Unique identifier for fetching the audio file for an event. The same ID is used for the transcript of the same event. . [optional]
            audio_source_id (int): Unique ID for an Internal recording specific to reportID. For example, ReportID X would have multiple recordings from different source (phone or webcast or vendor or replay). One ReportID can have multiple AudioSourceIDs. . [optional]
            trimmed (bool): This parameters helps to search trimmed audio files.. [optional] if omitted the server will use the default value of False
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EventsAudioDailyIds
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.get_docs_distributor_audio_v1_list_files_ids_endpoint.call_with_http_info(**kwargs)

    def get_docs_distributor_audio_v1_list_files_ids_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[EventsAudioDailyIds, int, typing.MutableMapping]:
        """Retrieve the latest audio recordings along with their corresponding metadata from the FactSet coverage based on specific IDs.  # noqa: E501

        Retrieves the latest audio recordings based on the provided report ID and audio source ID.  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            report_id (int): Unique identifier for fetching the audio file for an event. The same ID is used for the transcript of the same event. . [optional]
            audio_source_id (int): Unique ID for an Internal recording specific to reportID. For example, ReportID X would have multiple recordings from different source (phone or webcast or vendor or replay). One ReportID can have multiple AudioSourceIDs. . [optional]
            trimmed (bool): This parameters helps to search trimmed audio files.. [optional] if omitted the server will use the default value of False
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EventsAudioDailyIds
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.get_docs_distributor_audio_v1_list_files_ids_endpoint.call_with_http_info(**kwargs)

    def get_docs_distributor_audio_v1_list_files_ids_async(
        self,
        **kwargs
    ) -> "ApplyResult[EventsAudioDailyIds]":
        """Retrieve the latest audio recordings along with their corresponding metadata from the FactSet coverage based on specific IDs.  # noqa: E501

        Retrieves the latest audio recordings based on the provided report ID and audio source ID.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            report_id (int): Unique identifier for fetching the audio file for an event. The same ID is used for the transcript of the same event. . [optional]
            audio_source_id (int): Unique ID for an Internal recording specific to reportID. For example, ReportID X would have multiple recordings from different source (phone or webcast or vendor or replay). One ReportID can have multiple AudioSourceIDs. . [optional]
            trimmed (bool): This parameters helps to search trimmed audio files.. [optional] if omitted the server will use the default value of False
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[EventsAudioDailyIds]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.get_docs_distributor_audio_v1_list_files_ids_endpoint.call_with_http_info(**kwargs)

    def get_docs_distributor_audio_v1_list_files_ids_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[EventsAudioDailyIds, int, typing.MutableMapping]]":
        """Retrieve the latest audio recordings along with their corresponding metadata from the FactSet coverage based on specific IDs.  # noqa: E501

        Retrieves the latest audio recordings based on the provided report ID and audio source ID.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            report_id (int): Unique identifier for fetching the audio file for an event. The same ID is used for the transcript of the same event. . [optional]
            audio_source_id (int): Unique ID for an Internal recording specific to reportID. For example, ReportID X would have multiple recordings from different source (phone or webcast or vendor or replay). One ReportID can have multiple AudioSourceIDs. . [optional]
            trimmed (bool): This parameters helps to search trimmed audio files.. [optional] if omitted the server will use the default value of False
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(EventsAudioDailyIds, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.get_docs_distributor_audio_v1_list_files_ids_endpoint.call_with_http_info(**kwargs)


    def get_docs_distributor_audio_v1_list_files_upload_time(
        self,
        **kwargs
    ) -> EventsAudioDaily:
        """Retrieve latest audio recordings and related metadata within FactSet coverage based on upload time.  # noqa: E501

        Returns the latest audio recordings based on upload time and allows filtering through both source code and Ids.  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            upload_time (int): This parameter filters data based on uploadTime relative to the current time, in hours. For example:- uploadTime = -15 (fetches audio files between 15 hours ago and now)  Minimum is 1 hour i.e., uploadTime= -1  Maximum is 1 week/168 hours i.e., uploadTime=-168. [optional]
            source_code (str): This parameter filters the results based on Source of the Audio file. Below are the descriptions for each Source Code - * Phone = Originated from phone call * Webcast = Originated from a webcast * Vendor = Received from vendor * WebcastReplay = Replay of a webcast * Flash = Identical to webcast; can merge with \"Webcast\" in the future * Replay = Phone replay. [optional]
            ids ([str]): This parameter filters the results based on ticker-region or Entity ID or the combination of both. A comma is used to separate each identifier. . [optional]
            trimmed (bool): This parameter helps to search for trimmed audio files, with the non-speaking portions removed, and related metadata. The data ranges from May 10, 2011 to Dec 31, 2022. . [optional] if omitted the server will use the default value of False
            sort ([str]): Enables sorting data in ascending or descending chronological order based on uploadTime. . [optional] if omitted the server will use the default value of ["-uploadTime"]
            pagination_limit (int): Specifies the number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EventsAudioDaily
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.get_docs_distributor_audio_v1_list_files_upload_time_endpoint.call_with_http_info(**kwargs)

    def get_docs_distributor_audio_v1_list_files_upload_time_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[EventsAudioDaily, int, typing.MutableMapping]:
        """Retrieve latest audio recordings and related metadata within FactSet coverage based on upload time.  # noqa: E501

        Returns the latest audio recordings based on upload time and allows filtering through both source code and Ids.  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            upload_time (int): This parameter filters data based on uploadTime relative to the current time, in hours. For example:- uploadTime = -15 (fetches audio files between 15 hours ago and now)  Minimum is 1 hour i.e., uploadTime= -1  Maximum is 1 week/168 hours i.e., uploadTime=-168. [optional]
            source_code (str): This parameter filters the results based on Source of the Audio file. Below are the descriptions for each Source Code - * Phone = Originated from phone call * Webcast = Originated from a webcast * Vendor = Received from vendor * WebcastReplay = Replay of a webcast * Flash = Identical to webcast; can merge with \"Webcast\" in the future * Replay = Phone replay. [optional]
            ids ([str]): This parameter filters the results based on ticker-region or Entity ID or the combination of both. A comma is used to separate each identifier. . [optional]
            trimmed (bool): This parameter helps to search for trimmed audio files, with the non-speaking portions removed, and related metadata. The data ranges from May 10, 2011 to Dec 31, 2022. . [optional] if omitted the server will use the default value of False
            sort ([str]): Enables sorting data in ascending or descending chronological order based on uploadTime. . [optional] if omitted the server will use the default value of ["-uploadTime"]
            pagination_limit (int): Specifies the number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EventsAudioDaily
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.get_docs_distributor_audio_v1_list_files_upload_time_endpoint.call_with_http_info(**kwargs)

    def get_docs_distributor_audio_v1_list_files_upload_time_async(
        self,
        **kwargs
    ) -> "ApplyResult[EventsAudioDaily]":
        """Retrieve latest audio recordings and related metadata within FactSet coverage based on upload time.  # noqa: E501

        Returns the latest audio recordings based on upload time and allows filtering through both source code and Ids.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            upload_time (int): This parameter filters data based on uploadTime relative to the current time, in hours. For example:- uploadTime = -15 (fetches audio files between 15 hours ago and now)  Minimum is 1 hour i.e., uploadTime= -1  Maximum is 1 week/168 hours i.e., uploadTime=-168. [optional]
            source_code (str): This parameter filters the results based on Source of the Audio file. Below are the descriptions for each Source Code - * Phone = Originated from phone call * Webcast = Originated from a webcast * Vendor = Received from vendor * WebcastReplay = Replay of a webcast * Flash = Identical to webcast; can merge with \"Webcast\" in the future * Replay = Phone replay. [optional]
            ids ([str]): This parameter filters the results based on ticker-region or Entity ID or the combination of both. A comma is used to separate each identifier. . [optional]
            trimmed (bool): This parameter helps to search for trimmed audio files, with the non-speaking portions removed, and related metadata. The data ranges from May 10, 2011 to Dec 31, 2022. . [optional] if omitted the server will use the default value of False
            sort ([str]): Enables sorting data in ascending or descending chronological order based on uploadTime. . [optional] if omitted the server will use the default value of ["-uploadTime"]
            pagination_limit (int): Specifies the number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[EventsAudioDaily]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.get_docs_distributor_audio_v1_list_files_upload_time_endpoint.call_with_http_info(**kwargs)

    def get_docs_distributor_audio_v1_list_files_upload_time_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[EventsAudioDaily, int, typing.MutableMapping]]":
        """Retrieve latest audio recordings and related metadata within FactSet coverage based on upload time.  # noqa: E501

        Returns the latest audio recordings based on upload time and allows filtering through both source code and Ids.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            upload_time (int): This parameter filters data based on uploadTime relative to the current time, in hours. For example:- uploadTime = -15 (fetches audio files between 15 hours ago and now)  Minimum is 1 hour i.e., uploadTime= -1  Maximum is 1 week/168 hours i.e., uploadTime=-168. [optional]
            source_code (str): This parameter filters the results based on Source of the Audio file. Below are the descriptions for each Source Code - * Phone = Originated from phone call * Webcast = Originated from a webcast * Vendor = Received from vendor * WebcastReplay = Replay of a webcast * Flash = Identical to webcast; can merge with \"Webcast\" in the future * Replay = Phone replay. [optional]
            ids ([str]): This parameter filters the results based on ticker-region or Entity ID or the combination of both. A comma is used to separate each identifier. . [optional]
            trimmed (bool): This parameter helps to search for trimmed audio files, with the non-speaking portions removed, and related metadata. The data ranges from May 10, 2011 to Dec 31, 2022. . [optional] if omitted the server will use the default value of False
            sort ([str]): Enables sorting data in ascending or descending chronological order based on uploadTime. . [optional] if omitted the server will use the default value of ["-uploadTime"]
            pagination_limit (int): Specifies the number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(EventsAudioDaily, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.get_docs_distributor_audio_v1_list_files_upload_time_endpoint.call_with_http_info(**kwargs)


